' **********************************************************************
' ***
' ***	ctime.b		Show account connect time stats
' ***			(C)opyright 1994 Morgan Davis Group
' ***


#define IDENT_PROG "ctime"
#define IDENT_VERS "3.0"
#define IDENT_DATE "16mar94"
#define IDENT_NAME "Morgan_Davis"

#include <proline/proline.h>

#define	formatTime(mins, width, str)	_ftm = mins : _ftw = width : \
					gosub _formatTime : str = _fts$

#define formatDollars(amt, str)		_fda = amt : gosub _formatDollars : \
					str = _fds$

					
	gosub AppInit

	moy$ = "??JanFebMarAprMayJunJulAugSepOctNovDec"

	f$ = TEMP_PATH + "utmp"
	adm$ = ETC_PATH + "adm"

	fOpen f$
	fRead f$
		& get pl$
		& get t$
		& get 
		& get 
		input rpm,bal,owe
		input lgn,mnt,cmn,mcr,pmn,max,tmo
		input uid
	fClose

	fOpen adm$",L256"
	fRead adm$",R" uid
		& get un$
		fRead adm$ ",R" uid ",B132"
		& get cd$
	fClose

	& time(a$)
	print "Current Time: "a$
	print "  Login Time: "t$
	print "  Last Login: "pl$
	print 
	gosub getTimeInfo
	i = t
	j = day
	t$ = a$
	gosub getTimeInfo
	ti = t - i
	if j < > day then ti = 1440 - i + t

	print "Period" spc( 12)"Quota    Free    Used  Charge"
	& hlin 47,45
	print 

	formatTime(max / 30, 5, h$)
	formatTime(max / 30 - ti, 5, h1$)
	formatTime(ti, 5, h2$)
	formatDollars(ti * rpm, d$)
	print "This session:     " h$ "   " h1$ "   " h2$ "   " d$

	formatTime(max, 6, mx$)
	formatTime(max - mcr - ti, 6, h1$)
	i = mcr + ti
	formatTime(i, 6, h2$)
	formatDollars(i * rpm, d$)
	print "Month of " mid$(moy$,cmn * 3,3) ".:   " \
			mx$ "  " h1$ "  " h2$ "   " d$

	formatTime(pmn, 6, h$)
	formatDollars(pmn * rpm, d$)
	print "Previous month:  "mx$ spc( 6) "--  " h$ "   " d$

	formatTime(mnt + ti, 7, h$)
	print "Since" mid$ (cd$,5,10)":     --      -- " h$
	print 

	if rpm then 
		formatDollars(rpm * 60, d$)
		print "Connect rate:  "rpm" cents/min (" d$ "/hour)"
	endif
	print "Total logins:  "lgn" for "un$
	if tmo then print "Timeout grace: "tmo" days"
goto Exit


getTimeInfo:
	& pos (moy$, mid$ (t$,9,3)),moy
	moy = moy / 3
	y = val ( mid$ (t$,13,2))
	day = val ( mid$ ("??000031059090120151181212243273304334",moy * 3,3))\
		 + val ( mid$ (t$,6)) + (moy > 2 and y / 4 = int (y / 4))
	t = val ( mid$ (t$,16)) * 60 + val ( mid$ (t$,19))
return 

_formatTime:
	if _ftm < 0 then _ftm = 0
	_fth = int (_ftm / 60)
	_ftm = int (_ftm - _fth * 60)
	& right$ (str$(_ftm), 2, 48), _fts$
	& right$ (str$(_fth) + ":" + _fts$, _ftw, 48), _fts$
return 


_formatDollars:
	_fda = _fda + .5
	_fdj = int(_fda / 100)
	_fds$ = str$(int(_fda - _fdj * 100))
	& left$(_fds$, 2, 48), _fds$
	_fds$ = "$" + str$(_fdj) + "." + _fds$
return 


#include <proline/proline.lib>
