' ************************************************************************
' **									**
' **  csx.b 		ProLine Conference System (core)		**
' **			(C)opyright 1992 Morgan Davis Group		**
' **									**
' ** When    Who Ver	What						**
' ** ======= === ======	==============================================  **
' ** 19sep90 mwd 2.2	Converted old cs to MD-BASIC.			**
' ** 20jan91 mwd 2.3	Message word-wrap set to column 75.  Removed	**
' **			initial paging state retention upon exit.	**
' ** 18feb91 mwd	Fixed csdata file existence assumption.		**
' ** 03may91 mwd 2.4	Added CheckConfAccess for Show Info protection.	**
' ** 02aug91 mwd 2.5	Comment: field renamed to In-Reply-To:		**
' **			Merge only includes message now, with > quoting	**
' ** 04aug91 mwd	Added Organization support, auto updates itself	**
' **			to use cs.rsrc file now instead of cs.dir,	**
' **			commented out UNIXNAMES stuff.			**
' ** 14aug91 mwd	Replaced add>'s I(nput) command with I(nclude)	**
' **			and removed M(erge). Include merges, ala mail.  **
' ** 15aug91 mwd	Changed Include to allow any valid message.	**
' **			Fixed bug in Headers and Lookup which changed	**
' **			the current message marker.			**
' ** 16aug91 mwd	Message commented to becomes current message.	**
' ** 22aug91 mwd	Fixed bug in GetReadArgs, allowed fractions!	**
' ** 03sep91 mwd 2.6	Signature stop feature added			**
' ** 11sep91 mwd	Added "." to argument commands			**
' ** 22feb92 mwd 2.7	Removed moderator section for more RAM.		**
' ** 03sep93 mwd 2.7.1  Shuffled usenet header fields			**
' **									**
' ************************************************************************

#define IDENT_PROG "csx"
#include "cs.h"

	onerr goto HandleError
	if var$ = "" then
		gosub AppInit
		var$ = ENV_FILE
		fRestore var$
		print dd$ var$
		& on hangup goto csLogout
		goto wormHole
	endif

	& on hangup goto csLogout
	gosub Summary
	goto CPrompt


' ====================
' CurMsgFile
' ====================

CurMsgFile:
	cm = mg
CurMsgFile2:
	f$ = b$ + cn$ + "/" + tn$ + "/msg" + str$(mg)
return 


' ====================
  GetHeaderFields:
' ====================

	for q = 1 to FIELD_COUNT
		Hdr$[q] = ""
	next
	print do$f$
	print dr$f$",F1"
	repeat
		& get a$
		& pos (a$, ": "), q
		if q then
			& pos (Fields$, "=" + mid$(a$,1,q)), p
			if p then
				& spc(mid$(a$,q+2)),Hdr$[val(mid$(Fields$,p - 1))]
			endif
		endif
	until a$ = ""
	print dc$
return


' ====================
' FindFile
' ====================

FindFile:
	& getinfo f$,a$
	d% = a$ > ""
return 


' ====================
' FindConf
' ====================

FindConf:
	cn$ = a$
	cn% = 0
	for i = 1 to nc%
		if cn$(i) = a$ then 
			cn% = i
			i = nc%
		endif
	next 
return 


' ====================
' FindTopic
' ====================

FindTopic:
	ct% = 0
	for i = 1 to nt%
		if tn$(i) = a$ or a$ = str$(i) then 
			ct% = i
			i = nt%
		endif
	next 
return 


' ====================
' TopicList
' ====================

TopicList:
	print tp$ "s:";
	for i = 1 to nt%
		print " "i ") " tn$(i) chr$(44 * (i < nt%));
	next 
	print 
return 


' ====================
  ShowFile:
' ====================
	& getinfo a$, i$
	if i$ > "" then
		print
		& list a$
		print
	endif
return

	
' ====================
' Y/N
' ====================

GetYN_N:
	i = 0
	goto GetYNi

GetYN_Y:
	i = 1
GetYNi:
	print "? " left$ (y$[i],1)"^H";
	& clear 
	& rept
		get a$
		& ucase(a$)
		& pos ("^MYN",a$),y%
	& until(y%)
	y% = (a$ = "Y")
	if a$ = "^M" then y% = i
	print y$[y%]
return 


' ====================
' ConfExists
' ====================

ConfExists:
	cn$ = a$
	f$ = b$ + a$
	gosub FindFile
	if not d% then 
		print "No "cf$" "q$cn$q$
		goto CPrompt2
	endif
return 


' ==============================
' CheckConfAccess
' ==============================

CheckConfAccess:
	gosub ConfExists
	gosub GetIndex
	if not cs% and ID$[uName] < > cm$ and not SuperUser then 
		print confStatus$[0]" "cf$
		goto CPrompt
	endif
	print 
return

' ====================
' OK to Add?
' ====================

OKtoAdd:
	if ta$(ct%) > "" then
		gosub MailAccess
		if not mailstop% then return
	else
		if not guest% and not s%(ct%) or (ID$[uName] = cm$) or SuperUser then return
		print ro$
	endif
goto RPrompt2

CheckMailAccess:
	& pos (t0$,"!"),p
	& pos (t0$,"@"),q
	& pos (t0$,"%"),i
	if p or q or i then
		gosub MailAccess
		if mailstop% then goto RPrompt2
	endif
return

MailAccess:
	if mailstop% then print "No net access."
return

	
' ====================
' GetEOF
' ====================

GetEOF:
	print da$tmp$
	print dc$tmp$
	ch = 48840
	ch = peek(ch) + peek(ch + 1) * 256 + peek(ch + 2) * 65536
return 


' ====================
' ShowHeader
' ====================

ShowHeader:
	& time(a$)
	print "CS-ID: #"mg"."cn$"/"tn$"@" SysInfo$[plNode] " "ch" chars"
	print dateFld$ mid$(a$, 6) " " SysInfo$[plZone]
	print fromFld$ ID$[uName]" ("ID$[uFullName]")"
	print subjFld$ su$
	if co$ > "" then print co$ co2$
	print 
return 


' ====================
' Headers
' ====================

Headers:
	gosub ShowHeaderHeader
	for mg = s to e step st
		gosub CurMsgFile2
		gosub FindFile
		if d% then gosub ShowHeaderLine
		print df$
	next 
return 

ShowHeaderHeader:
	& ioctl(ioClearScreen)
	& ioctl(ioULOn)
	print "Msg #: ^I" dateFld$ spc(9)"^I" fromFld$ spc(9)"^I" subjFld$ spc(30)
	& ioctl(ioULOff)
	print
return


' ====================
  GetComInfo:
' ====================
	gosub GetHeaderFields
	i$ = Hdr$[SUBJECT_FIELD]
	if left$ (i$,3) < > "Re:" then i$ = "Re: " + i$
	co$ = "In-Reply-To: " + Hdr$[FROM_FIELD]
	co2$ = " in #" + str$(mg)

GetFromField:
	if Hdr$[REPLY_TO_FIELD] > "" then
		a$ = Hdr$[REPLY_TO_FIELD]
	else
		a$ = Hdr$[FROM_FIELD]
	endif
	& pos (a$, "<"), q
	if not q then
		gosub GetFirstWord
	else
		& pos right$ (a$, ">"),p
		& spc (mid$(a$, q + 1, p - q - 1)),a$
	endif
	fr$ = a$
return 


' ====================
' GetOwner
' ====================

GetOwner:
	gosub GetHeaderFields
	a$ = Hdr$[FROM_FIELD]
GetFirstWord:
	& pos (a$ + " "," "),q
	a$ = left$(a$, q - 1)
return 


' ====================
' MsgGone
' ====================

MsgGone:
	print "Msg "mg" is deleted"
return 

' ====================
' UpdateIndex
' ====================

UpdateIndex:
	if u% then
		u% = 0
		print dc$
		print do$b$cn$index$
		print dw$b$cn$index$
		print cm$
		print cs%","nt%
		for x = 1 to nt%
			print tn$(x);
			if ta$(x) > "" then 
				print ":" ta$(x) ":" inclsig%(x);
			endif
			print 
			print s%(x)","o(x)","n(x)
		next 
		print dc$
	endif

	if not nm(ct%,cn%) and ls(ct%,cn%) > = 0 then ls(ct%,cn%) = n(ct%)
return 


' ====================
' IsEmpty
' ====================

IsEmpty:
	if n(ct%) - o(ct%) < 1 then 
		print "-- no"mg$"s in "cn$"/"tn$
		goto RPrompt2
	endif
return 


' ====================
' GetReadArgs
' ====================

GetReadArgs:
	gosub GoGetArgs
	lastSArg = s
return

GoGetArgs:
	print v$" ";
	gosub IsEmpty
	i = n(ct%) - 1
	i% = 0
	st = 1
	a$ = ""

_103_:
	get ch$
	& ucase(ch$)
	if not i% then
		& pos ("^MCAFLPNUO?", ch$),p
		on p goto _118_,_118_,_123_,_124_,_125_, \
			_126_,_128_,_130_,_132_,_119_
	endif
	if ch$ <> "^M" then 
		& pos(".,-1234567890",ch$),p
		if i% < 11 and p then
			if ch$ = "." then ch$ = str$(lastSArg)
			i% = i% + len(ch$)
			a$ = a$ + ch$
			print ch$;
		else		
			if ch$ = "^?" then ch$ = "^H"
			if ch$ = "^H" and i% then
				print ch$" "ch$;
				i% = i% - 1
				a$ = mid$(a$,1,i%)
			endif
		endif
		goto _103_
	endif
	print df$

	print 
	s = val (a$)
	e = s
	& pos (a$,"-"),p
	& pos (a$,","),p%
	p = p + p%
	if p then
		e = val (mid$ (a$,p + 1))
		if p = 1 then s = o(ct%)
		if not e then e = i
	endif

	j = s
	k = e
	if s > e then 
		st = -1
		j = e
		k = s
	endif
	if not (j < o(ct%) or k > i) then return 
	print "Try "o(ct%)" to "n(ct%) - 1
goto RPrompt2


_118_:
	print "Current"mg$
	s = cm - (cm > i)
	e = s
return 


_119_:
	print "?^M^M" \
	"	Next		Current		Previous	Original^M" \
	"	First		Last		Unread		All"
	print \ 
	"	x		x-		-y		x-y^M^M" \
	"cs>read> ";
goto GetReadArgs

_123_:
	print "All"mg$"s"
	s = o(ct%)
	e = i
return 

_124_:
	print "First"mg$
	s = o(ct%)
	e = s
return 

_125_:
	print "Last"mg$
	s = i
	e = s
return 

_126_:
	print "Previous"mg$;
	if cm > o(ct%) then 
		s = cm - 1
		e = s
		print 
		return 
	endif
ShowNone:
	print " - none"
goto RPrompt2

_128_:
	print "Next"mg$;
	if cm = i then goto ShowNone
	print 
	s = cm + 1
	e = s
return 

_130_:
	if not nm(ct%,cn%) then goto ShowNone
	print ur$mg$"s"
	s = cm + 1
	e = i
return 

_132_:
	print "Original"mg$;
	gosub IsEmpty
	mg = cm - (cm > i)
	gosub CurMsgFile2
	gosub _136_
	print do$f$
	print dr$f$",f4"
	& get a$
	print dc$
	& pos (a$,"#"),p%
	if not p% then goto ShowNone
	mg = val (mid$ (a$,p% + 1))
	gosub CurMsgFile
	gosub _136_
	print 
	s = mg
	e = mg
return 

_136_:
	& getinfo f$,a$
	if a$ = "" then 
		print " -- ";
		gosub MsgGone
		goto RPrompt2
	endif
return 


' ====================
' GetConf
' ====================

GetConf:
	& read (31),a$
	& lcase(a$)
	& spc (a$),a$
	i$ = a$
	e$ = ""
	& pos (a$,"/"),p%
	if p% then 
		e$ = mid$ (a$, p% + 1)
		a$ = mid$ (a$,1 ,p% - 1)
	endif
	on a$ = "?" or a$ = "list" goto csList
return 


' ====================
' GetIndex
' ====================

GetIndex:
	print do$b$cn$index$
	print dr$b$cn$index$
	& get cm$
	input cs%,nt%
	for x = 1 to nt%
		& get a$
		input s%(x),o(x),n(x)
		& pos (a$,":"),p
		& pos (p + 1, a$, ":"), q
		if not p then p = len(a$) + 1
		if not q then q = 254
		tn$(x) = left$ (a$,p - 1)
		ta$(x) = mid$ (a$,p + 1, q - p - 1)
		inclsig%(x) = val(mid$(a$, q + 1))
	next 
	print dc$
return 



' ====================
' cs>
' ====================

CPrompt:
	& on int goto CPrompt
	& int on 
	print 
	onerr goto csHandleError

CPrompt2:
	& pop
	where% = atCSPrompt
	print df$
CPrompt3:
	print "cs> ";
	get a$
	& ucase(a$)
	& pos (c1$, a$),p%
	on p% goto csNext, csNext, csNext, csHelp, csHelp, moreOFF, moreOFF,\
		moreON, moreON, csBulk, csJoin, csQuit, csUnjoin, csStatus,\
		csList, csInfo
	print helpMe$
goto CPrompt3
		
		
csStatus:
	print "Status: ";
	showall% = 1
	gosub Summary
goto CPrompt


csInfo:
	print "Info on ";
	gosub GetConf
	on a$ = "" goto CPrompt2
	gosub CheckConfAccess
	print cf$": "cn$"  ("confStatus$(cs%)")^M" \
		"Moderator:  "cm$ "^M^M" \
		tp$ spc(11) "First   Next  Total  Comments"
	& hlin 60,45
	print 
	for i = 1 to nt%
		j = n(i) - o(i)
		print tn$(i) spc(21 - len (tn$(i)) - len (str$ (o(i))))o(i) spc(7 - len (str$ (n(i))))n(i) spc(7 - len (str$ (j)))j"  ";
		a$ = ta$(i)
		if a$ > "" then
			& pos(a$, ";"), p
			if p then a$ = mid$(a$, p + 1)
			print a$" ";
		endif
		if s%(i) then print ro$;
		print 
	next 
	& hlin 60,45
	print 
	a$ = b$ + cn$ + welcome$
	gosub ShowFile
goto CPrompt


csNext:
	cn% = 1
_230_:
	if not bulk% then print "Next " cf$ "^M"
	& pop 
	for i = cn% to nc%
		gosub _237_
	next 
	on cn% < 2 goto _234_
	for i = 1 to cn%
		gosub _237_
	next 

_234_:
	gosub NoNewMsgs
	bulk% = 0
goto CPrompt2

_237_:
	ct% = 0
	for j = 1 to nt%(i)
		if nm(j,i) then
			ct% = j
			j = nt%(i)
		endif
	next 
	if not ct% then return 

	cn% = i
	cn$ = cn$(i)
	gosub GetIndex
goto autoJoin


csQuit:
	print "Quit"
	gosub SaveCSData
goto Exit


csList:
	print "List "cf$"s^M"
	& list CS_LIST
goto CPrompt


csJoin:
	print "Join ";
	gosub GetConf
	on a$ = "" goto CPrompt2
	gosub FindConf
	if not cn% then
		gosub CheckConfAccess
		& ioctl(ioClearScreen)
		print "Welcome to the " q$cn$q$ " " cf$ "!"
		a$ = b$ + cn$ + welcome$
		gosub ShowFile
		mod% = 1
		nc% = nc% + 1
		cn% = nc%
		for j = 1 to nt%
			ls(j,nc%) = o(j)
			nm(j,cn%) = n(j) - o(j)
		next 
		jj% = 1
	else
		print 
		gosub GetIndex
	endif

	ct% = 1
	cn$(cn%) = cn$
	nt%(cn%) = nt%
	a$ = e$
	e$ = ""
on a$ > "" goto joinTopic2


joinTopic:
	if (nt% > 1) and not jj% then
		gosub TopicList
		print tp$ "? ";
		gosub GetConf
		print 
		if a$ > "" then
		    joinTopic2:
			gosub FindTopic
			if not ct% then 
				print "No " tp$ " "q$a$q$
				goto joinTopic
			endif
		else
			ct% = 1
		endif
	endif

autoJoin:	
	jj% = 0
	tn$ = tn$(ct%)
	if sgn (ls(ct%,cn%)) < 0 then
		ls(ct%,cn%) = abs (ls(ct%,cn%))
		gosub FixPtrs
		mod% = 1
		print "Re-";
	endif

	print "Joining ";
	gosub CountNew
	& pos (ta$[ct%], ";"), p
	if p then print " (" mid$(ta$[ct%], p + 1) ") ";
	if s%(ct%) then print ro$;
	print

	if ls(ct%,nc%) = o(ct%) then gosub ShowTopicInfo

	u% = 0
	cm = ls(ct%,cn%) - (ls(ct%,cn%) > 0)
goto RPrompt1

ShowTopicInfo:
	a$ = b$ + cn$ + "/"+ tn$ + welcome$
goto ShowFile

	
' ====================
' cs>read>
' ====================

BulkStop:
	bulk% = 0

RPrompt:
	if not nm(ct%,cn%) then print "^MLAST MESSAGE in "cn$"/"tn$;
	print 

RPrompt1:
	print dc$
	& on int goto BulkStop
	& int on 
	onerr goto csHandleError

RPrompt2:
	mid% = 0
	& pop 
	where% = atReadPrompt
	print df$
	if bulk% then goto readNext

RPrompt3:
	print "cs>read> ";
	get a$
	& ucase(a$)
	& pos (c2$,a$),p%

	on p% goto readNext, readNext, readNext, csHelp, csHelp, \
		moreOFF, moreOFF, moreON, moreON, csBulk, \
		readJoin, readQuit, readUnjoin, readSkip, readLookup, \
		readInfo, readAdd, readComment, readReply, readDelete, \
		MailReply, \
		readForward, readHeaders, readOriginal, readType, readWrite
		
	print helpMe$
goto RPrompt3



readUnjoin:
	print "Unjoin "cn$"/"tn$;
	gosub GetYN_N
	on not y% goto RPrompt
	ls(ct%,cn%) = - abs(ls(ct%,cn%))
	nm(ct%,cn%) = 0
	mod% = 1
goto readNext


readOriginal:
	i = n(ct%) - 1
	gosub _132_
	gosub _368_
goto RPrompt


readDelete:
	v$ = "Delete"
	gosub GetReadArgs
	if abs(e - s) < 3 then gosub Headers
	print "^MSure";
	gosub GetYN_N
	on not y% goto RPrompt2
	if s > e then 
		t = e
		e = s
		s = t
	endif
	for i = s to e
		mg = i
		gosub CurMsgFile2
		gosub FindFile
		on not d% goto _283_
		on SuperUser goto _282_
		gosub GetOwner
		if a$ <> ID$[uName] and cm$ <> ID$[uName] and not SuperUser then 
			print "Can't delete #"i
			goto _286_
		endif

	_282_:
		print dd$f$

	_283_:
		o(ct%) = o(ct%) + (i = o(ct%))
		cm = cm + (cm < o(ct%))
		if o(ct%) > n(ct%) then 
			o(ct%) = n(ct%)
		endif
		u% = 1
		gosub MsgGone

	_286_:
	next 
	gosub UpdateIndex
goto RPrompt2

readInfo:
	print "Info: You're at"mg$" "cm" in ";
	gosub CountNew
	print
	gosub ShowTopicInfo
goto RPrompt2


readSkip:
	v$ = "Skip to"
	gosub GetReadArgs
	ls(ct%,cn%) = e + 1
	nm(ct%,cn%) = n(ct%) - (e + 1)
	gosub _368_
goto RPrompt


readNext:
	if not nm(ct%,cn%) then 
		gosub UpdateIndex
		goto _230_
	endif
	if bulk% then 
		print 
		on not nm(ct%,cn%) goto RPrompt
		goto _295_
	endif
	print "Next"
	& ioctl (ioClearScreen)

_294_:
	& on int goto RPrompt
	on not nm(ct%,cn%) goto RPrompt

_295_:
	mg = ls(ct%,cn%)
	gosub CurMsgFile
	ls(ct%,cn%) = ls(ct%,cn%) + 1
	nm(ct%,cn%) = nm(ct%,cn%) - (nm(ct%,cn%) > 0)
	gosub FindFile
	on not d% goto _294_
	& list f$
	mod% = 1
goto RPrompt


readJoin:
	print "Join"
goto joinTopic


readForward:
	v$ = "Forward"
	gosub GetReadArgs
	mg = s
	gosub CurMsgFile2
	gosub FindFile
	if not d% then 
		gosub MsgGone
		goto RPrompt2
	endif
	& read (74),"To: ",t0$
	& spc (t0$),t0$
	gosub CheckMailAccess
	gosub GetHeaderFields
	co$ = ""
	print subjFld$;
	& read (70,Hdr$[SUBJECT_FIELD]),su$
	if t0$ > "" then 
		emailFlag% = 1
		gosub SendMail
		print 
	endif
goto RPrompt2


readQuit:
	print "Quit "cn$"/"tn$
goto CPrompt


' ======================================================================

MailReply:
	v$ = "Mail reply to"
	emailFlag% = 1
goto _309_

readAdd:
	gosub OKtoAdd
	print "Add"mg$
	i$ = ""
	co$ = ""
	fr$ = ""
	emailFlag% = 0
goto _312_

readComment:
readReply:
	v$ = "Reply to"
	gosub OKtoAdd
	emailFlag% = 0
_309_:
	gosub GetReadArgs
	mg = s
	gosub CurMsgFile2
	gosub FindFile
	if not d% then 
		gosub MsgGone
		goto RPrompt2
	endif
	gosub GetComInfo
	print co$ co2$

_312_:
	print subjFld$;
	& read (70,i$),su$
	on su$ = "" goto RPrompt2
	if emailFlag% then
		t0$ = fr$
		gosub CheckMailAccess
'		print "Private"mg$": ";
	else
		mg = n(ct%)
		if ta$(ct%) = "" then 
'			print "Msg #"mg": ";
			t0$ = ""
		else
			mid% = 1
'			print "Net"mg$": ";
			t0$ = ta$(ct%)
		endif
	endif
	print "New"mg$": ";
	
_315_:
	onerr goto _317_
	print dd$tmp$
_317_:
	& pop 
	& int stop 
	onerr goto csHandleError
_318_:
	& on int goto APrompt
	print "enter text, end with "q$"."q$" alone.^M"
	print da$tmp$
	& int on 
	i$ = ""
_321_:
	& read (75,i$),":",a$
	if mid$ (a$,1,1) < > "." then 
		print a$
		goto _321_
	endif
	if len (a$) > 2 then 
		print a$
		goto _321_
	endif
	dc% = 0
	if len (a$) = 2 then 
		dc% = 1
		a$ = right$ (a$,1)
	endif

APrompt:
	& on int goto _325_
	where% = atAddPrompt
	onerr goto csHandleError

_325_:
	& pop 
	print dc$
	print 
	if dc% then 
		dc% = 0
		goto _327_
	endif

_326_:
	print "cs>read>add> ";
	get a$

_327_:
	& ucase(a$)
	& pos ("GSAQELCI?/P",a$),p
	on p goto _456_,_338_,_359_,_349_,_353_,_357_,_347_,RInclude,\
		csHelp,csHelp,_335_
	print helpMe$
goto _326_


RInclude:
	oldmg = mg
	v$ = "Include"
	gosub GetReadArgs
	for mg = s to e step st
		gosub CurMsgFile2
		gosub FindFile
		if d% then
			gosub GetHeaderFields
			if emailFlag% then
				if Hdr$[NEWSGROUPS_FIELD] > "" then
					i$ = "In "+Hdr$[NEWSGROUPS_FIELD] + " y"
				else
					i$ = "Y"
				endif
				i$ = i$ + "ou write:"
			else
				if Hdr$[MESSAGE_ID_FIELD] > "" then
					i$ = "In " + Hdr$[MESSAGE_ID_FIELD]
					if len(i$) + len(Hdr$[FROM_FIELD]) > 70 then
						i$ = i$ + "^M"
					else
						i$ = i$ + " "
					endif
				else
					i$ = ""
				endif
				i$ = i$ + Hdr$[FROM_FIELD] + " writes:"
			endif
			print da$ tmp$
			print i$
			print

			onerr goto riEOF
			print do$ f$
			print dr$ f$
			repeat
				& get a$
			until a$ = ""
			do
				print dr$ f$
				& get a$
				print dw$ tmp$
				print ">" a$
			loop
			riEOF:
			& onerr
			print dw$ tmp$
			print
			print dc$
		endif
	next
	mg = oldmg
goto APrompt

_335_:
	a$ = fr$
	& read (-76, a$),"Post to: ", fr$
	& spc (fr$), fr$
	if fr$ > "" then
		emailFlag% = 1
		t0$ = ""
	endif

_338_:
	if emailFlag% and t0$ = "" then t0$ = fr$

	if t0$ = "" then print "Saving "mg" ";
	gosub GetEOF
	if not ch then 
		print "- empty"
		goto _326_
	endif
	if t0$ > "" then 
		f$ = tmp$
		gosub SendMail
		goto _345_
	endif
	gosub CurMsgFile2
	print do$f$
	print dw$f$
	gosub ShowHeader
	print dc$
	print df$
	& add(tmp$ to f$)
	n(ct%) = mg + 1
	u% = 1
	mod% = 1
	if n(ct%) - o(ct%) > MAX_MSGS then 
		mg = o(ct%)
		gosub CurMsgFile2
		o(ct%) = mg + 1
		cm = cm + (cm = mg)
		& getinfo f$,i$
		if i$ then print dd$f$
	endif
	gosub UpdateIndex

_345_:
	print dd$tmp$
	& int stop 
	print
goto RPrompt

_347_:
	print "Clear"mg$;
	gosub GetYN_Y
	on not y% goto _326_
	print "Done..";
goto _315_

_349_:
	print "Quit"mg$;
	gosub GetYN_Y
	on not y% goto _326_
	print "Save it";
	gosub GetYN_N
	if y% then
		gosub writeToFile
		if accOK then
			print df$
			& add(tmp$ to fi$)
		endif
	endif
	print dd$ tmp$
goto RPrompt

_353_:
	print "Edit...";
	fStore var$
	& restore ProgStack_Cell to a$
	& store AppPath$ + ":" + a$ to ProgStack_Cell
	& left$("^A^B",7,0),i$
	& store i$ + ID$[uEditor] + chr$(0) + tmp$ + chr$(0) to ShellArgs_Cell
	fLaunch BIN_PATH + id$[uEditor]

_357_:
	print "List"
	& ioctl(ioClearScreen)
	gosub GetEOF
	gosub ShowHeader
	& list tmp$
	print 
goto _326_

_359_:
	print "Add -- ";
goto _318_

readType:
	v$ = "Type"
	gosub GetReadArgs
	gosub _368_
goto RPrompt


_368_:
	mod% = 1
	for mg = s to e step st
		gosub CurMsgFile
		gosub FindFile
		if not d% and s = e then 
			gosub MsgGone
		else
			if d% then
				if s = e then
					& ioctl(ioClearScreen)
				else
					print
				endif
				& list f$
				print 
			endif
		endif
	next 
return 


readHeaders:
	v$ = "Headers"
	gosub GetReadArgs
	gosub Headers
goto RPrompt


csUnjoin:
	print "Unjoin ";
	gosub GetConf
	on a$ = "" goto CPrompt2
	gosub FindConf
	if not cn% then goto CPrompt2

	on e$ = "" goto _378_
	gosub GetIndex
	a$ = e$
	gosub FindTopic
	if not ct% then 
		print q$e$q$" not in "cn$
		goto CPrompt
	endif
	ls(ct%,cn%) = - abs (ls(ct%,cn%))
	nm(ct%,cn%) = 0

_378_:
	mod% = 1
	print "Done."
	on e$ = "" gosub Unjoin
goto CPrompt

	
csHandleError:
	print dc$
	& onerr e,l
	if e = 6 or e = 7 then 
		print "Not found."
		goto wormHole
	endif

	print argv$[0]": error #"e" at "l
goto wormHole


csHelp:
	print "?^M"
	& ioctl(ioClearScreen)
	& list HELP_PATH + "cs." + mid$ ("cra",where%,1)
wormHole:
	on where% goto CPrompt,RPrompt,APrompt
goto CPrompt


SaveCSData:
	onerr goto HandleError
	if (not mod%) or guest% then return 
	& getinfo usersData$,i$
	if i$ > "" then print dd$ usersData$
	if nc% then
		print do$ usersData$
		print dw$ usersData$
		for i = 1 to nc%
			print cn$(i)","nt%(i)
			for j = 1 to nt%(i)
				print ls(j,i)
			next 
		next 
		print dc$
	endif
return 


csLogout:
	onerr goto HandleError
	print dc$
	gosub UpdateIndex
	gosub SaveCSData
	& getinfo tmp$,i$
	if i$ > "" then print dd$tmp$
goto Logout

	
' ====================
' SendMail(F$,T0$,SU$)
' ====================

SendMail:
	& pos (t0$ + ";", ";"), p
	group$ = mid$(t0$, p + 1)
	t0$ = left$(t0$, p - 1)
	print "Sending to ";
	if group$ > "" then
		print group$;
	else
		print t0$;
	endif
	& time(t$)
	& pos ("?anebarprayunulugepctovec", mid$ (t$,10,2)),m%
	d% = val (mid$ (t$,6))
	& right$ (str$ (val (mid$ (t$,16)) * 3600 + val (mid$ (t$,19)) * 60 + val (right$ (t$,2))),5,48),tf$
	tf$ = chr$(64 + m% / 2) + chr$ (48 + d% + 7 * (d% > 9)) + tf$
	tf$ = SPOOL_MAIL_PATH + tf$
	print do$tf$
	print dw$tf$
	print "From "ID$[uName]" " left$ (t$,3) mid$ (t$,8,5) mid$ (t$,6,3) right$ (t$,8)" 19" mid$ (t$,13,3)

	i$ = dateFld$ + left$(t$,5) + str$(val(mid$ (t$,6))) +  \
		mid$(t$,8) + " " + SysInfo$[plZone]
	a$ = fromFld$ + ID$[uName] + " (" + ID$[uFullName] + ")"
	if mid% then print "Path: " SysInfo$[plNode] "!" ID$[uName]
	print i$
	print a$
	print "To: "t0$
	print subjFld$ su$
	if mid% then
		if group$ > "" then
			print "Newsgroups: " group$
			print "Distribution: world"
		endif
		print "Message-ID: <19"\
			mid$(t$,13,2) mid$(t$,9,3) d% \
			"." mid$(t$,16,2) mid$(t$,19,2) mid$(t$,22,2) \
			"." mg "@" SysInfo$[plNode] SysInfo$[plDomain] ">"
		print "Organization: " organization$
		if Hdr$[MESSAGE_ID_FIELD] > "" then
			print "References: " Hdr$[MESSAGE_ID_FIELD]
		else
			if co$ > "" then print co$
		endif
	endif
	print 
	print dc$
	print df$
	& add(f$ to tf$)
	if emailFlag% or inclsig%(ct%) then
		t$ = ID$[uHome] + "/signature"
		& getinfo t$,i$
		print df$
		if i$ > "" then & add(t$ to tf$)
	endif
return 


' ====================
' CountNew
' ====================

CountNew:
	print cn$"/"tn$", "nm(ct%,cn%)" new"mg$s$[nm(ct%,cn%) < > 1];
return 

	
' ====================
' readWrite
' ====================

readWrite:
	v$ = "Write"
	gosub GetReadArgs
	gosub writeToFile
	if accOK then
		for mg = s to e step st
			gosub CurMsgFile
			gosub FindFile
			print df$
			if d% then & add(f$ to fi$)
		next
	endif
goto RPrompt


writeToFile:
	accOK = 0
	& read (64),"to file: ",fi$
	& spc(fi$), fi$
	if fi$ = "" then return

	& getinfo fi$,a$
	m = accWrite + (accDestroy * (a$ > ""))
	gosub Access
	if not accOK then 
		print i$": can't write"
		return
	endif
	if m <> accWrite then 
		print fi$" exists, append";
		gosub GetYN_Y
		if not y% then
			print "Replace";
			gosub GetYN_Y
			accOK = y%
			if accOK then print dd$ fi$
		endif
	endif
return

	
' ====================
' Access
' ====================

Access:
	AccFile$ = fi$
	AccMode = m
goto CheckAccess


_456_:
	& read (64),"Get: ",fi$
	& getinfo fi$,a$
	if a$ = "" then 
		print fi$": not found"
	else
		m = accRead
		gosub Access
		if not accOK then 
			print i$": can't read"
		else
			print df$
			& add(fi$ to tmp$)
		endif
	endif
goto _326_


moreOFF:
	print "- More"
	& page stop 
goto wormHole

	
moreON:
	print "+ More"
	& page on 
goto wormHole


csBulk:
	print "Bulk-show";
	gosub GetYN_Y
	bulk% = y%
	if y% then on where% goto csNext, readNext
goto wormHole


' ====================
  readLookup:
' ====================

	v$ = "Look in"
	gosub GetReadArgs
	& read (30),"for: ",ss$
	& spc (ss$),ss$
	if ss$ = "" then goto RPrompt2
	print "Headers only";
	gosub GetYN_N
	if y% then
		gosub ShowHeaderHeader
	else
		print
	endif
	& ucase(ss$)
	for mg = s to e step st
		& ioctl(ioCR)
		if s <> e then print percent(s,e,mg) "%";
		gosub CurMsgFile2
		gosub FindFile
		if d% then
			print do$f$
			print dr$f$",F1"
			& rept
				& get a$
				& ucase(a$)
				& pos (a$,ss$),sr%
				if sr% then 
					print dc$
					gosub erasePercent
					if y% then
						gosub ShowHeaderLine
					else
						& list f$
						print
					endif
					a$ = ""
				endif
			& until(a$ = "")
			print dc$
		endif
		print df$
	next 
	gosub erasePercent
goto RPrompt

erasePercent:
	& ioctl(ioCR)
	print spc(4)
	& ioctl(ioCR)
return

ShowHeaderLine:
	gosub GetHeaderFields
	a$ = Hdr$[DATE_FIELD]
	& pos (a$, " "), p
	if p < 4 then
		p = 1
	else
		p = p + 1
	endif

	& right$(str$(val(mid$(a$,p))), 2), i$
	&pos (p + 1, a$, " "),p
	i$ = i$ + "-" + mid$(a$,p+1,3) + "-"
	&pos (p + 5,a$," "),p
	print mg "^I" i$ mid$(a$,p-2,2) mid$(a$,p,6) "^I";
	gosub GetFromField
	a$ = left$(fr$,15)
	print a$;
	& hlin 1 + (len(a$) < 8), 9
	print left$(Hdr$[SUBJECT_FIELD],39)
return 



' ====================
  Summary:
' ====================

	gosub JoinedCount
	hd% = 0
	if nc% then
		cn% = 1
		repeat
			cn$ = cn$(cn%)
			f$ = b$ + cn$
			gosub FindFile
			if not d% then 
				gosub ConfGone
			else
				gosub GetIndex
				nt%(cn%) = nt%
				for j = 1 to nt%
					if 1 + sgn (ls(j,cn%)) then 
						ct% = j
						gosub FixPtrs
						if nm(j,cn%) or showall% then
							tn$ = tn$(j)
							if not hd% then gosub SummaryHeading
							print cn$ "/" tn$;
							& hlin 4 - int((len(cn$ + tn$) + 1) / 8), 9
							print spc(4 - len (str$ (nm(j,cn%))))nm(j,cn%)
						endif
					endif
				next
				cn% = cn% + 1
			endif
		until cn% > nc%
		if hd% then goto SummaryDashes
	endif
	
	print "-- ";
NoNewMsgs:
	print "No new" mg$ "s."
return 


' ====================
' FixPtrs
' ====================

FixPtrs:
	if ls(ct%,cn%) < o(ct%) then ls(ct%,cn%) = o(ct%)
	if ls(ct%,cn%) > n(ct%) then ls(ct%,cn%) = n(ct%)
	nm(ct%,cn%) = n(ct%) - ls(ct%,cn%)
return 


' ====================
' JoinedCount
' ====================

JoinedCount:
	print "Joined to "nc%" "cf$s$[nc% < > 1]" ";
return 


' ====================
' SummaryHeading
' ====================

SummaryHeading:
	print "^M^M"cf$"/" tp$ "^I^I New"

' ====================
' Dashes
' ====================

SummaryDashes:
	& hlin 36,45
	print
	hd% = not hd%
return 


' ====================
' ConfGone
' ====================

ConfGone:
	on not hd% gosub SummaryHeading
	print cn$;
	& hlin 3 - int(len(cn$) / 8), 9
	print " * REMOVED *"

' ====================
' Unjoin
' ====================

Unjoin:
	mod% = 1
	for x = 1 to nt%(cn%)
		ls(x,cn%) = 0
		nm(x,cn%) = 0
	next 
	nc% = nc% - 1
	if nc% + 1 = cn% then return
	for x = cn% to nc%
		cn$(x) = cn$(x + 1)
		nt%(x) = nt%(x + 1)
		for j = 1 to nt%(x)
			ls(j,x) = ls(j,x + 1)
			nm(j,x) = nm(j,x + 1)
		next 
	next 
return 


#define ONLY_SYSINFO
#include <proline/proline.lib>
#include <proline/access.lib>
