' **********************************************************************
' ***
' ***	chat.b	Admin/user split-screen chat program
' ***		(C)opyright 1994 Morgan Davis Group
' ***
' *** When	Who Ver	Description
' *** =========	=== ===	================================================
' *** 14-Nov-91	mwd 1.0	Creation
' *** 18-Jan-92 mwd 1.1 Fixed bug in scrolling after a ^X clear
' *** 16-Jan-94 mwd 3.0 Updated launching and IDENT stuff
' ***

#define	IDENT_PROG "chat"
#define	IDENT_VERS "3.0"
#define	IDENT_DATE "6may94"
#define	IDENT_NAME "Morgan_Davis"

#include <appleio.h>
#include <basic.h>
#include <prodos.h>
#include <proline/proline.h>

#define	DEFAULT_RINGS	6	' Number of rings before giving up
#define DEFAULT_VOLUME	7	' Volume level

#define	CHATLINES	8	' Number of lines in chat windows
#define	CHATSCROLL	3	' Number of lines to scroll at a time
#define WRAPCOL		78	' Column where word wrapping begins
#define	DIAMOND_LOC	1062	' Screen location for diamond

#define	ADMIN		0	' ID for top window
#define	USER		1	' ID for bottom window

#define	ADMIN_TOPLINE	2	' Row positions for windows
#define USER_TOPLINE	12
#define STATUS_LINE	22


	' Variables used

#declare SuperUser, SysInfo$, ID$, argv$' System stuff
#declare i$, a$, i, j, k, msg$, ioAlt	' Misc variables
#declare who, lastWho			' Keeps track of current chatter
#declare Name$				' Login name
#declare Line$, userLine,		' Chat text, and line count
#declare userTop, userX, userY		' Status line and cursor positions
#declare key, keys$			' Input stuff
#declare CommandLine$			' Used to invoke mail with Launch
#declare ReturnPath$			' "
#declare AppPath$			' "
#declare SetRoot			' "
#declare options$, optchar$, optarg$	' Option handling
#declare ttyOnly			' Override split-screen mode
#declare volume				' Volume of ringing signal
#declare maxRings			' Maximum rings before giving up
#declare fastScroll			' Terminal can do fast scrolling


' ****************************************
' *
' * Main
' *

	gosub AppInit				' Initialize everything
	volume = DEFAULT_VOLUME			' Default loudness
	maxRings = DEFAULT_RINGS		' Default rings

	& fn fnOutputMode, ioAlt		' Set up for alt output mode

	if pdl(0) < 128 then goto ChatExit	' Paddle says sysop not here

	optchar$ = ""
	options$ = "r:tv:"
	repeat
		gosub getopt
		if optchar$ = "r" then maxRings = val(optarg$)
		if optchar$ = "v" and SuperUser then volume = val(optarg$)
		if optchar$ = "t" then ttyOnly = TRUE
		if optchar$ = "?" then
			print "Usage: " argv$[0] " [-r rings] [-t] [-v volume]"
			goto Exit
		endif
	until optchar$ = ""

	gosub CallSysop				' phone home

	
' ****************************************
' *
' *  Do TTY chat if no GotoXY
' *	

	& ioctl (ioGotoXY), i
	if (not i) or ttyOnly then
		print
		print "You are now chatting with the sysop."
		print "Type a period (.) on a new line to exit."
		print
		i$ = ""
		repeat
			& read (78,i$),a$
		until a$ = "."
		goto Exit
	endif

' ****************************************
' *
' * Prepare for split-screen chat!
' *	

	dim Line$[USER,CHATLINES], Name$[USER], userTop[USER],\
		userLine[USER], userX[USER], userY[USER]

	Name$[ADMIN] = SysInfo$[plAdminFull]
	Name$[USER] = ID$[uFullName]
	if Name$[ADMIN] = Name$[USER] then
		Name$[ADMIN] = "console"
		Name$[USER] = "modem"
	endif

	userTop[ADMIN]	= ADMIN_TOPLINE
	userTop[USER]	= USER_TOPLINE
	userY[ADMIN]	= ADMIN_TOPLINE + 1
	userY[USER]	= USER_TOPLINE + 1


	& ioctl(ioDeleteLine), i
	& ioctl(ioInsertLine), j
	fastScroll = i and j		' Flag fast scrolling ability
	
	keys$ = "^X^H^?^L^M"		' Control keys we know about
	
	who = ADMIN
	lastWho = who
	gosub DrawScreen
	gosub ShowCursor

	' Get a keypress, set "who" entered it, and handle the input

	& on int goto eventQuit
	onerr goto eventQuit
	do
		& fn fnScanInput, key
		if key then
			who = key < 128
			if not who then key = key - 128
			gosub HandleInput
		endif
	loop

	eventQuit:
	& pop
	onerr goto HandleError
	gosub HideCursor
	& ioctl (ioGotoXY, 0, 23)
goto Exit		


' ****************************************
' *
' * HandleInput -- process input

HandleInput:
	if who <> lastWho then
		gosub HideCursor
		lastWho = who
		& ioctl (ioGotoXY, userX[who], userY[who])
	endif
	i = len(Line$[who,userLine[who]])
	& pos (keys$, chr$(key)),j
	if j then
		gosub HideCursor
		on j gosub ClearWindow, DelChar, DelChar, DrawScreen, DoWrap
		goto ShowCursor
	endif
	if key < 31 then return

	if i = WRAPCOL then
		gosub HideCursor
		gosub DoWrap
		if key = 13 then goto ShowCursor
	endif

	Line$[who,userLine[who]] = Line$[who,userLine[who]] + chr$(key)
	& print chr$(key);
	userX[who] = userX[who] + 1

ShowCursor:
	& pr ioConsole		' Fake a cursor for the console
	inverse
	& print " ^H";
	normal
	& pr ioAlt
return

HideCursor:
	& pr ioConsole		' Erase fake cursor
	& print " ^H";
	& pr ioAlt
return


' ****************************************
' *
' * ClearWindow -- erases user's window
' *

ClearWindow:
	i = userTop[who] + 1
	userY[who] = i
	userX[who] = 0
	& ioctl (ioGotoXY, 0, i)
	for i = 0 to userLine[who]
		& ioctl (ioClearEOL)
		print
		Line$[who, i] = ""
	next
	userLine[who] = 0
	& ioctl (ioGotoXY, 0, userY[who])
return

' ****************************************
' *
' * DoWrap -- handle's word wrapping and
' *	chat window scrolling.
' *

DoWrap:
	if key = 32 then key = 13
	i$ = ""
	if key <> 13 then
		& pos right$ (Line$[who,userLine[who]], " "),i
		if i then
			i$ = mid$(Line$[who,userLine[who]], i + 1)
			Line$[who,userLine[who]] = \
				mid$(Line$[who,userLine[who]], 1, i - 1)
			& ioctl (ioGotoXY, i - 1, userY[who])
			& ioctl (ioClearEOL)
		endif
	endif

	if userLine[who] < CHATLINES then
		userLine[who] = userLine[who] + 1
		userY[who] = userY[who] + 1
		print
	else
		gosub ScrollWindow
	endif
	i = 0
	userX[who] = len(i$)
	Line$[who, userLine[who]] = i$
	& ioctl (ioGotoXY, 0, userY[who])
	& print i$;
return


' ****************************************
' *
' * ScrollWindow -- scrolls chat window
' *

ScrollWindow:
	& ioctl(ioGotoXY, 0, userTop[who] + 1)
	if fastScroll then
		& ioctl(ioDeleteLine)
		& ioctl(ioGotoXY, 0, userTop[who] + CHATLINES + 1)
		& ioctl(ioInsertLine)
		for i = 1 to CHATLINES
			Line$[who, i - 1] = Line$[who, i]
		next
		Line$[who, CHATLINES] = ""
	else
		userLine[who] = CHATLINES - CHATSCROLL + 1
		for i = 0 to CHATLINES - 1
			if i < userLine[who] then
				Line$[who, i] = Line$[who, i + CHATSCROLL]
			else
				Line$[who, i] = ""
			endif
			& print Line$[who, i];
			& ioctl (ioClearEOL)
			& print
		next
		& ioctl (ioClearEOL)
		userY[who] = userTop[who] + 1 + userLine[who]
	endif
return


' ****************************************
' *
' * DelChar -- delete character left
' *

DelChar:
	if i then
		Line$[who,userLine[who]] = \
			mid$(Line$[who,userLine[who]], 1, i - 1)
		& print "^H ^H";
		userX[who] = userX[who] - 1
	endif
return


' ****************************************
' *
' * DrawScreen -- (re)draws everything
' *

DrawScreen:
	& page clear
	& ioctl (ioClearScreen)
	for j = ADMIN to USER
		& ioctl (ioGotoXY, 0, userTop[j])
		a$ = "( " + Name$[j] + " )"
		i = 39 - int(len(a$) / 2)
		& hlin i, $2D
		& print a$;
		& hlin 80 - i - len(a$), $2D
		& ioctl (ioGotoXY, 0, userTop[j] + 1)
		for i = 0 to userLine[j]
			& print Line$[j, i]
		next
	next
	& ioctl (ioGotoXY, 0, STATUS_LINE)
	& ioctl (ioInverse)
	a$ = "===== ProLine Chat Mode " + IDENT_VERS + " "
	i$ = " (Use Interrupt Key to Quit) ===== "
	& print a$;
	& hlin 80 - len(i$) - len(a$), $3D
	& print i$;
	& ioctl (ioNormal)
	& ioctl (ioGotoXY, userX[who], userY[who])
return


' ****************************************
' *
' * ConsoleMessage -- put a message on the
' *	local console only
' *

ConsoleMessage:
	& pr ioConsole
	inverse
	& int stop
	& print msg$;
	& int on
	normal
	& print
	& pr ioAlt
return

ClearMessage:
	& pr ioConsole
	& ioctl (ioUp)
	& ioctl (ioEraseLine)
	& ioctl (ioDown)
	& pr ioAlt
return	


' ****************************************
' *
' * CallSysop -- make a phone ringing sound
' *

CallSysop:
	msg$ = "<< PRESS A KEY TO ENTER CHAT MODE >>"
	gosub ConsoleMessage
	&poke 768,169,28,133,0,162,16,160,38,44,48,192,138,32,168,252,44,48,\
		192,169,volume,32,36,3,136,16,238,232,224,18,208,231,198,0,\
		208,225,96,240,253,133,1,198,1,208,252,96,0
	i = 0
	newRing:
		j = 0
		k = 2 + (i > 0) * 2
		delay:
			& time(a$)
			repeat
				& fn fnScanInput, key	
				if key then goto Answer
				& time(i$)
			until a$ <> i$
			j = j + 1
		if j < k then goto delay
		
		if not i then print "Calling the sysop, one moment";
		call 768
		print ".";
		i = i + 1
	if i < maxRings then goto newRing

	Answer:
	gosub ClearMessage
	if key < 128 then
		print
		print
		goto ChatExit
	endif	
	poke DIAMOND_LOC,32			' Erase diamond in status bar
	print
return


' ****************************************
' *
' * ChatExit -- sysop not available.
' * 	Offer e-mail option.
' *

ChatExit:
	Name$ = SysInfo$[plAdmin]
	print "The sysop (" Name$ ") is not available for chatting."
	print "Send private mail to " Name$"? (y/n) N^H";
	& get (1),a$
	& ucase (a$)
	if a$ <> "Y" then
		print "N"
		poke DIAMOND_LOC,91		' Put diamond in status bar
		goto Exit
	endif
	print a$
	print
	Launch("mail " + Name$, "", FALSE)

#include <proline/proline.lib>
#include <proline/launch.lib>
#include <proline/getopt.lib>
#include <proline/access.lib>
