' ======================================================================
'
'	calls.b		Tracks system calls
'			(C)opyright 1994 Morgan Davis Group
'
' ======================================================================

#define IDENT_PROG "calls"
#define IDENT_VERS "3.0"
#define IDENT_DATE "24jan94"
#define	IDENT_NAME "Morgan_Davis"

#include <basic.h>
#include <proline/proline.h>

#define	SPEED_COUNT	14
#define	SPEED_LIST	"@=  300A= 0600B= 1200C= 2400D= 4800E= 7200"\
			"F= 9600G=12000H=14400I=16800J=19200K=38400"\
			"L=57600M=local"
#define	LOCAL_ID	13


	gosub AppInit

	logfile$ = SPOOL_LOGS_PATH + "syslog"

	gosub testOutput
	if accFile$ > "" then
		on not AccOK goto Exit
		if k = 1 and accMode > accWrite then fDelete accFile$
		outputFile$ = accFile$
	endif
	
	options$ = "f:ust"
	optchar$ = ""
	repeat
		gosub getopt
		if optchar$ = "f" then
			AccFile$ = optarg$
			AccMode = accRead
			gosub CheckAccess
			if not accOK then
				& print argv$[0]": can't read " optarg$
				goto ExitError
			endif
			logfile$ = optarg$
		endif
		if optchar$ = "u" then showUsers% = TRUE
		if optchar$ = "s" then showStats% = TRUE
		if optchar$ = "t" then showChart% = TRUE
		if optchar$ = "?" then showUsage% = TRUE
	until optchar$ = ""

	if showUsage% then 
		print "Usage: " argv$[0] " [-f logfile] [-ust]"
		goto ExitError
	endif

	if showStats% + showChart% + showUsers% = 0 then
		showUsers% = TRUE
		showStats% = TRUE
		showChart% = TRUE
	endif
	
	speeds$ = SPEED_LIST
	def fn rsf(x) = int (x * 10 ^ sg + .5) / (10 ^ sg)

	dim tc[SPEED_COUNT], tt[SPEED_COUNT], md[12], ti[23]

	data 31,28,31,30,31,30,31,31,30,31,30,31	' days in each month
	for i = 1 to 12
		read md[i]
	next 
	
	gosub Gather
	if not ExitStatus% then
		if showChart% then gosub PrintChart
		if showStats% then gosub PrintStats
		if outputFile$ > "" then fClose outputFile$
	endif
goto Exit


testOutput:
	accFile$ = ""
	if asc(argv$[argc-1]) = 62 then
		argc = argc - 1
		accFile$ = argv$[argc]
		k = len(accFile$)
		& spc (accFile$, 62), accFile$
		k = k - len(accFile$)
		gosub testAccFile
	endif
return

testAccFile:
	& getinfo accFile$,i$
	accMode = accWrite + accWrite * (i$ > "")
	gosub CheckAccess
	if not accOK then
		print argv$[0] ": can't open " accFile$
		status% = -1
	endif
return



Gather:
	& getinfo logfile$,i$
	if i$ = "" then
		& print argv$[0]": " logfile$ " not found"
		ExitStatus% = -1
		return
	endif

	fOpen logfile$
	fRead logfile$
	onerr goto logEOF

	if showUsers% then
		if outputFile$ > "" then fAppend outputFile$
		print "Caller           Date     Time     Mins.  Speed"
		print "---------------  -------  -------  -----  -----"
		fRead logfile$
	endif

	& get a$
	first$ = a$
	goto firstTime

	dataLoop:
	& get a$
	firstTime:
	
	' hourly calls plus total time summary
	' Sum up total calls at each baud rate and the number of minutes used

	x = val(mid$ (a$,21,2))
	ti[x] = ti[x] + 1
	tt = val (mid$ (a$,31,2)) * 60 + val (mid$ (a$,33,2))

	& pos (a$,"!"),p
	if p then 
		tc[LOCAL_ID] = tc[LOCAL_ID] + 1
		tt[LOCAL_ID] = tt[LOCAL_ID] + tt
		goto dataLoop
	endif

	bd$ = mid$(a$, 15,5)
	& pos (speeds$, "=" + bd$), p
	if p then
		x = asc(mid$(speeds$, p - 1)) - 64
		tc[x] = tc[x] + 1
		tt[x] = tt[x] + tt
	endif

	if showUsers% then 
		ct$ = mid$ (a$,26,4)
		cu$ = str$(tt)
		& right$ (cu$,5),cu$
		t$ = "a"
		i = val (left$(ct$,2))
		if i > = 12 then 
			t$ = "p"
			i = i - 12
		endif
		if not i then i = 12
		& right$ (str$(i) + ":" + right$ (ct$,2) + t$ + "m",7),ct$
		if outputFile$ > "" then fAppend outputFile$
		print mid$(a$,36,15) tab(18) left$(a$,7) "  " ct$ "  " cu$"  " mid$(a$,15,5)
		fRead logfile$
	endif
	goto dataLoop

	logEOF:
	onerr goto HandleError
	& onerr
	fClose logfile$
	last$ = a$

	' Total all calls and minutes

	for i = 0 to SPEED_COUNT - 1
		totalTime = totalTime + tt[i]
		totalCalls = totalCalls + tc[i]
	next

	if outputFile$ > "" then fAppend outputFile$
	if showUsers% then print
return 


PrintStats:
	print "Statistics for Calls Reviewed"
	print "---------- --- ----- --------"
	print "Logins for system:     " totalCalls
	print "Minutes system used:   " totalTime

	' Figure uptime
	
	a$ = "?anebarprayunulugepctovec"

	& pos(a$, mid$(last$, 3, 3)), cm
	cm = cm / 2

	& pos(a$, mid$(first$, 3, 3)), pm
	pm = pm / 2

	me = cm - pm
	if mc > 1 then 
		for i = cm + 1 to pm - 1
			td = td + md[i]		' total tween days
		next
	endif

	if me then
		td = td + val(left$ (last$,2)) + (md[cm] - val(left$ (first$,2)))
	else
		td = td + val (left$ (last$,2)) - val (left$ (first$,2)) - 1
	endif

	td = td * 1440
	yr = val (mid$(last$,6,2))
	yr = mod(yr, 4)
	if (not yr) and (pm < = 2) and (cm > = 2) then td = td + 1440

	th = val (mid$ (last$,21,2)) + val (mid$(last$,23,2)) / 60
	ts = 24 - (val (mid$ (first$,23,2)) / 60 + val(mid$ (first$,21,2)))
	t = td + (th + ts) * 60

	k = t
	gosub _910_
	& spc(a$), a$
	print "Minutes system uptime: "a$

	k = (t - totalTime) / t * 100
	sg = 2
	k = fn rsf(k) + .001
	gosub _910_
	&spc(a$),a$
	print "Idle percentage:       "a$
	print 

	print "Speed   % Calls   % Time"
	print "-----   -------   ------"
	for i = 0 to SPEED_COUNT - 1
		if tc[i] then
			t1 = (tc(i) / totalCalls) * 100
			if totalTime then
				t2 = (tt(i) / totalTime) * 100
			else
				t2 = 0
			endif
			sg = 2
			k = fn rsf(t1) + .001
			gosub _910_
			b$ = a$
			k = fn rsf(t2) + .001
			gosub _910_
			print mid$(speeds$, i * 7 + 3, 5) "    " b$ "   " a$
		endif
	next 
	print
return 


_910_:
	j = int((k - int (k)) * 100)
	k = int (k)
	& right$ (str$ (k),3),i$
	& left$ (str$ (j),2,48),a$
	a$ = i$ + "." + a$
return 



PrintChart:
	if not totalCalls then return

	print tab(23) "Average Calls Per Hour"
	print tab(24) "(" left$ (first$,7)" to " left$ (last$,7)")"
	print
	
	' Figure Graph Scaling

	t = 0
	for i = 0 to 23
		if ti[i] > t then t = ti(i)
	next 

	t = 50 / ((t / totalCalls) * 100)
	' T is now the scaling factor 50 marks at maximum

	print  "  Hour^I| Calling Activity"
	& right$ ("", 60, 45), l$
	print l$

	for i = 0 to 23
		a$ = str$(i)
		& right$(a$,2,48),b$
		a$ = "  " + b$ + ":00 | "
		x = ti(i) / totalCalls * 100
		sg = 2
		x = int (fn rsf(x) * t) + 1
		& right$ (" ",x,$23),i$
		print a$ i$
	next 
	print l$
	print "Each '#' represents " left$ ( str$ (1 / t),3)"% of total time in use."
	print l$
	print 
return 

	
#include <proline/proline.lib>
#include <proline/access.lib>
#include <proline/getopt.lib>
