.TH PLAPP S
.DA 30 March 1994
.SH Name
plapp - How to create ProLine applications
.SH Description
This document describes the procedures recommended
for creating applications for use in the ProLine environment.
.PP
One of the best things about ProLine is its ``extendibility'' in the form
of user-written programs, and the ease with which they can be created.
Not only does this provide custom functions for individual sites, but
such extensions can be distributed to others, and everyone benefits. 
This has already been done, and the Morgan Davis Group (MDG) would like
to encourage additional development along with some reasonable guidelines.
.PP
Before starting on any new or converted program for ProLine, you should
have the ModemWorks Programmer's Manual, available from MDG.
This manual describes all the commands and techniques for
managing the communications interface between BASIC programs and the
system.  MD-BASIC is also highly recommended for doing your ProLine
development.
.PP
.PP The Hard Way
.BR
Creating a ProLine program using Applesoft's immediate input mode is
possible.  In fact, until 1990, ProLine was created and maintained for
six years in this way.  Everyone has immediate mode Applesoft, so anyone
can easily create ProLine applications without any special tools -- it's
just painfully inconvenient compared to using MD-BASIC.
.PP
It also becomes difficult to maintain and support when core
functionality in ProLine changes to accommodate new features.  ProLine
programs written in MD-BASIC using the core set of ProLine library
functions need only be recompiled with little or no changes to the
program source code.  Programs written in Applesoft require extensive
changing after analyzing the raw output from newer MD-BASIC-generated
programs.
.PP
Thus, this method of development is highly discouraged since compatibility
with updated versions of ProLine cannot be guaranteed nor easily maintained.
.PP
.PP The Easy Way
.BR
MD-BASIC comes with a complete subroutine library and interfaces for
creating ProLine applications in a very neat and powerful C-like
environment for BASIC.
.PP
Here is a sample program for ProLine written in MD-BASIC:
.IP 5
.AF
#define IDENT_PROG "args"
#define IDENT_VERS "1.0"
#define IDENT_DATE "30mar94"
#define IDENT_NAME "Morgan_Davis"
.BR
#include <proline/proline.h>            ' Include ProLine interface
.BR
        gosub AppInit                   ' Initialize environment
        for arg = 0 to argc - 1         ' Loop through arguments
                print argv$[arg] " ";   ' Display them
        next
        print                           ' Finish up with a newline
        goto Exit                       ' And then exit
.BR
#include <proline/proline.lib>          ' Include subroutine library
.AF 1
.IP
See the _proline.h_ and _proline.lib_, files for important instructions
and handy constant definitions.  ProLine developers can also take
advantage of additional libraries, such as _launch.lib_ (a simple
command line processor that can be used to launch external programs and
return back to yours), _getopt.lib_ (a command line option processor
making it easy to parse mixed arguments and flags), and more.
.PP
.PP Resource Files
.BR
If your program includes various settings and adjustments that the user
may want to configure, keep them in an external data file.  Do not
hard-code settings into your program.  That's ugly and gross, and not
very friendly. Let the administrator change the operation of your
program by editing settings with an editor.
.PP
Your external data files, called ``resource files'', are stored in the
$/etc/rsrc directory, and end with the _.rsrc_ extension.  The first
part of the resource file name should match the name of your application
(e.g. the ``sendmail'' application has a ``sendmail.rsrc'' file).
.PP
Do not deviate from this naming convention, as a future resource editing
utility might expect to find matching ``.rsrc'' files.  The format of your
resource file should be fairly simple -- one data item per line if
possible.  Lists of items should include a count line preceding the
lines of items.
.PP
If your program must store a data file for each user who uses it
(e.g. user preference settings), determine if your program should allow
the user to edit the file (and possibly mess up its format) if saved in
the user's home directory.  Preference files that are changed by your
program only should be stored in the user's $/adm directory
($/adm/_username_) which is inaccessible to the user.
.PP
.PP Input and Output
.BR
Using HOME in your program does not clear a caller's screen.  Nor will
commands like HTAB and VTAB -- they work only on the ProLine host's
display.  Refer to the &IOCTL command in the ModemWorks manual for
details on local and remote screen manipulation.
.PP
Avoid Applesoft's INPUT statement for getting input, especially for
numeric input.  This is because Applesoft has some gross error messages
that will be displayed if the user enters something it doesn't like
(e.g. ?REENTER or ?EXTRA IGNORED).  Plus, INPUT won't allow the user to
enter certain characters.  Instead, use AmperWorks' more powerful &READ
statement.
.PP
When reading data from a file, use AmperWorks' &GET statement.  &GET is
clean.  Applesoft's INPUT does stupid things like clearing the screen
from the cursor to the end of the line, and then moving the cursor down
one line.
.PP
Don't assume anything about the configuration of other sites. The only
directories/volumes that you can reasonably assume to exist are those
that are distributed with ProLine.  For example, if you provide a
program (or script) that makes use of ``/ram'', it will fail on any site
that doesn't have a volume named ``/ram'' online!
.PP
.PP Good Programming Tips
.BR
Here are some tips for creating good, high-performance code:
.IP 5 1)
Use multiple statements per line.  Your program executes faster
and occupies less memory.  For each line conserved, you save at least
six bytes.  (MD-BASIC automatically does this.)
.IP 5 2)
Renumber by ones.  Line numbers take up one byte per digit. The
shorter your line numbers, the more you save.  A good renumbering
utility is recommended.  (MD-BASIC automatically does this.)
.IP 5 3)
Modularize large programs.  If your application is larger than 20K
in size, you should break it down into modules to leave enough RAM
left for variable storage.  Smaller programs run faster.
.IP 5 4)
Eliminate unneeded processing in loops.  If a statement in a loop is
not necessary, move it outside of the loop.  For each iteration of the
loop, the statement will be executed, slowing things down.
.IP 5
Bad:
.IP 10
.AF
for i = 1 to 100
    j = q * 34 / c
    r = i + j
    gosub process_r
next
.AF 1
.IP 5
Good:
.IP 10
.AF
j = q * 34 / c
for i = 1 to 100
    r = i + j
    gosub process_r
next
.AF 1
.IP 5 5)
Place frequently accessed routines at the top.  Applesoft searches
for program lines starting at the beginning of your program on down to
the last line.  The closer a referenced line is to the top, the sooner
Applesoft finds it.  It goes without saying: put the least commonly used
routines at the bottom of your program.
.IP 5 6)
Declare commonly used variables and constants at the start of the
program. Give them short variable names (unless you're using MD-BASIC
which optimizes long variable names to short ones).  Applesoft can
evaluate a constant value faster if it is contained within a variable.
.IP 5 7)
Use special (sneaky) effects to hide processing delays.  If the program
is about to begin some lengthy number crunching, the user perceives the
passage of time is faster if there is a diversion (e.g. something to
read).  What might pass for a friendly delay loop for reading, might
actually have been the initialization of a large matrix, or maybe some
disk access.
.IP
.PP Distribution
.BR
ProLine boasts a powerful and convenient online help system that
displays help documents in a programmable format for the best viewing on
any screen, dot-matrix printer, or PostScript-compatible laser printer. 
Always include documentation in ``man'' formatted text files with your
applications.  See the man(CT) and manuals(M) entries for more details.
.PP
If you are distributing more than one file (e.g. the program file and
its ``man'' file), place them into a ProLine archive (_par_) file. Be sure
the archive retains the standard ProLine directory structure so that it
can be easily unpacked on the target systems.  To do this, always create
ProLine archives from the perspective of the top-level ProLine System
Directory ($/).  Introduce new subdirectories before any files within it
are referenced.
.PP
When you distribute your archive, include installation instructions
(e.g. in the e-mail letter accompanying transmission of your archive, or
secondary text file).  This describes how to unpack your archive, be it
encoded (uuencode or BinSCII) or compressed (ShrinkIt). If you can't (or
won't) include installation notes, make sure the file's suffix is
descriptive of what's inside:
.IP 5
ProLine Archive (par)
.BR
ShrinkIt Archive (shk)
.BR
Uuencoded (uu)
.BR
Uuencoded, compressed archive (shk.uu)
.IP
Steps for assembling a typical distribution:
.IP 5 1)
Put all the files into a ProLine archive.
.IP 5 2)
If larger than 10K, put the resulting .par file into a ShrinkIt archive
(to take advantage of the compression).
.IP 5 3)
_Uuencode_ the resulting file for transmission via e-mail.
.IP
.SH Files
$/pub/proline/plapp.exe - ProLine Application subroutines.
.SH See Also
man(CT), manps(CT), manuals(M), par(C), updates(ADM), uuencode(C)
