.TH PLUSH F
.DA 25 February 1994
.SH Name
plush - Menu format and programming
.SH Description
The $/etc/plush.m text file contains specially-formatted menu definitions
that can be modified to alter the way _plush_ presents commands to the
user.  The exact formatting of this file is critical -- a mistake will cause
incorrect operation which may not be reported.  Since the file contains
text commands, any text editor can be used to edit it.
.PP
The Menu Definition File consists of individual structures, one for each
menu.  Multiple menus are separated by blank lines.  The definition file
is terminated by the ``END'' command.  The typical layout of this file
would be:
.IP 5
Menu #1 Structure
.BR
<a blank line>
.BR
Menu #2 Structure
.BR
<a blank line>
.BR
Menu #N Structure
.BR
END
.IP
Note that there is no blank line between the last structure and ``END''.
.PP
.PP Format of a Menu Structure
.BR
Each menu structure consists of three items: a menu title, the menu's prompt,
and the menu's key-command list:
.IP 5
Menu Title
.BR
Menu Prompt
.BR
<First key-command line>
.BR
<Second key-command line>
.BR
.RC 3 .
.BR
<Last key-command line>
.BR
<Key-command list terminator>
.IP
Here is an actual menu structure for a "Games Menu":
.IP 5
.AF
Games Menu:
Games:
3,2,0,Ll,L,L - List all games,DO ls $/games
3,2,0,Pp,P,P - Play a game,IN Which game;DO $/games/$IN
3,2,0,,,,
3,2,0,Ff,F,F - Fortune cookie,DO $/games/fortune
3,2,0,Oo,O,O - Other fun things,>> Other Fun Things
9,9,9,,,,
.AF
.IP
The first line contains the name of the menu (Games Menu). 
.PP
The second line is the menu's prompt string (Games:).  If the prompt
begins with a < (less-than) character it identifies a menu as an
_extension_ menu. Extension menus allow the user to make one selection,
and then the menu is closed.  Normally, once a menu is opened it remains
open until the user manually closes it by pressing a ``backup'' key. 
.PP
Beginning with the third line is the key-command list (key-command lines
are discussed in detail next).  This list contains seven fields that reside
completely on one line of text, though the line can be longer than the
screen's width.
.PP
.PP Key-Command Lines
.BR
Each key-command line contains seven fields, separated by commas.  Fields
are presented in the following order (using a sample line as reference):
.IP 5
.AF
3,2,0,Ll,L,L - List all games,DO ls $/games
.AF
.IP 15 Group-ID:
(3) Determines if this line is accessible based on the user's group-ID. 
Groups are: (0) root or sysop, (1) staff, (3) guest.  If the group-ID field
contains a number which is less than the user's group-ID, the command is
not available.  This can allow certain commands to be inaccessible for
lower-level users.
.IP 15 Location:
(2) This code, 0 through 2, determines if the selection
is available based on the user's current location: (0) the local console,
(1) remote terminal, or (2) either local or remote.
.IP 15 Priority:
(0) Priority is: (0) standard, or (1) super-user override.  This allows
_plush_ to perform certain commands that would otherwise be illegal due
to the user's group-ID permissions.  As an example, a guest or staff
level user cannot view a text file in the $/etc directory.  But if
root-user priority (1) is specified, such access is permitted.
.BR 2
WARNING: Giving root-level access to some commands could allow a
non-root user to damage your system!
.IP 15 Keys:
(Ll) Two letters or symbols, or blank.  These characters define the
keystrokes that invoke the command for this line.  Usually, upper and
lowercase versions are used. "+=" would be used so that pressing
the "+" key would not require the user to hold down SHIFT.  If this
field is left blank, this item is not selectable but the description
is displayed in the command list.  This can be used to create blank
lines or special separators.
.IP 15 Response:
(L) This letter, or string of characters, is echoed back to the user
after pressing one of the two keys as long as the "hot-key" input mode
is used.
.IP 15 Description:
(L - List all games) Describes the command.  Shown when the command list
is displayed.  A blank line is displayed if the response field is blank.
However, if the response field contains characters and the description is
blank, the menu item is treated like any other, only it is not displayed.
This is useful for creating hidden menu items.
.IP 15 Command:
(DO ls $/games) The command line.  Commands start with a two-letter
code followed by arguments (if any).  Multiple commands can be placed
in this line by separating them with a semicolon (;).
.IP
The key-command list is terminated by a key-command line that consists
of a group-ID of 9, location of 9, priority of 9, and the remaining fields
all blank.  Example:
.IP 5
.AF
9,9,9,,,,
.AF
.IP
.PP Command Codes
.BR
_Plush_ interprets the following two-letter commands (uppercase required):
.LM 5
.IP 5 DO
Launches an external program.  _Plush_ searches $/bin, $/sys/bin, $home/bin,
and $/sys/local/bin to find the program.  If it does not
reside in one of those areas, include the complete path to the program.
Use $/ to specify the ProLine System Prefix.  The DO command name is
optional, ``DO df'' and ``df'' will produce the same results.
.IP 5 ED
Edits a file.  The full path to the editable text file must be given.
.IP 5 VU
Views the text file given as the argument.
.IP 5 >>
Opens the submenu whose name is given as the argument. It is best to
place the named menu AFTER the menu in which this command is issued. 
This is because _plush_ first searches for menus in a forward direction
(from the current menu down to the last menu).   If the menu can't be
found, _plush_ searches from the current menu backwards to the first
menu in an attempt to locate it.
.IP 5 <<
Closes the current menu and returns to the previous one.
.IP 5 EX
Exits _plush_.  This is allowed if _plush_ is invoked from _csh_ or
some other shell.
.IP 5 BY
Bye.  Logs the user out, disconnecting the modem.
.IP 5 PR
Prints a message.  If no argument is given a blank line is printed.
.IP 5 CD
Changes directories to the argument given.  If no directory is specified,
the current working directory becomes the user's home directory.
.IP 5 RM
Removes the named file.
.IP 5 IN
Accepts a line of input, storing it in a special variable called $IN.
.IP 5 QY
Query-yes.  Prompts the user with a Yes/No question, Yes being the default.
If the user's response is Yes, any remaining commands in the command line
are performed.  If a negative response is given, the command line is
immediately terminated.
.IP 5 QN
Query-no.  Same as QY, except the default is No.
.IP 5 CL
Clears the screen.
.IP 5 TB
Test blank.  Checks the argument that follows to see if it evaluates
to nothing, a blank value.  For example, ``TB $IN'' cancels the command line
if the last user input was blank (nothing entered).
.IP 5 TF
Test file.  Checks the file argument that follows to see if it exists.
For example, ``TF $IN'', cancels the command line if the file name in $IN
is not found.
.IP
.LM -5
.PP Special Characters
.BR
It is very important that no illegal characters such as commas, colons or
misplaced quotation marks are used within any of the seven fields of the
key-command line.  Commas and colons can be used as long as the entire
field is enclosed in quotes.  For example:
.IP 5
.AF
3,2,0,Bb,B,"B - Bye: disconnect, hangup",BY
.AF
.IP
To invoke a command with a single argument that consists of spaces, enclose
the argument in single-quotes (').  Example:
.IP 5
.AF
0,2,0,Mm,M,M = MDSS Account,adduser -m 'bin/mdss -x BLX'
.AF
.IP
_Plush_ supports the standard C-Shell escape (\) and control-code (^)
prefix characters.  Any tilde (~) character is replaced with the
path to the user's home directory.
.PP
.PP Variables
.BR
_Plush_ recognizes the following variables:
.PP
$IN
.TB 15
Input from the most recent IN command.
.BR
$/
.TB 15
Path to the ProLine System Directory.
.BR
$spool
.TB 15
Path to the spool directory.
.BR
$tmpdir
.TB 15
Path to the temporary files directory.
.PP
.PP Notes
.BR
_Plush_ supports 100 menus, and each menu can include 30 items.  This
limitation exceeds the capacity of most of the system's text editors,
so working with a large plush.m file may require utilizing an external
text editor or word processor.
.PP
Since _plush_ works with only one menu at a time, it operates faster if
the menu file is located on a fast disk (e.g. a RAM disk). To utilize the
$tmpdir option, include a copy command in the $/etc/rc file to put a
copy of plush.m into $tmpdir.
.PP
See plush(C) for details on where _plush_ looks for its menu files.
.SH Files
$/adm/*/environs - user's environment settings,
.BR
$tmpdir/plush.env - temporary environment file.
.SH See Also
csh(C), plush(C), setenv(C)
