.TH MANUALS F
.DA 27 March 1992
.SH Name
manuals - Format of manuals
.SH Description
The ProLine Reference Manual consists of individual files, called
_entries_, that describe a part of the system, be it a command, a file
format, miscellaneous information, etc.
.PP
Manuals follow a specific visual format.  Shown at the top of each page is
an entry's title and section, e.g. MANUALS(F), and at the bottom
is its modification date, page number, and date printed.
.PP
.PP Subheaders
.BR
These subheaders are standard in manual entries and typically
follow in the order presented here:
.IP 15 Name
A short, one-line summary of the document follows.
.IP 15 Syntax
Included for entries that describe a command with parameter arguments.
.IP 15 Description
Begins the descriptive body of the entry. The body of an entry is
generally undefined.  Though, it should not use any subheader other than
those described here.  It may contain, however, its own paragraph
headings.
.IP 15 Note
(or Notes, Bugs, Warning, Important, etc.) This subheader proceeds
important information that should stand out from the body of the
description, such as hazards or side effects.
.IP 15 Diagnostics
Error messages and their meanings.
.IP 15 Files
If any files are associated with an entry, they are listed after this
subheader, usually near the end of the entry.  Each file listed should
include a short description.
.IP 15 See Also
Usually, an entry ends with a ``See Also'' subheader, followed by a
reference list to related entries.
.IP 15 Author
(Optional).  The name of the author (for the entry and/or the command
it describes) is given, along with the author's e-mail address.  If
this subheader is not included, it is assumed that the author is
Morgan Davis.
.IP
.PP Internal Structure
.BR
Manuals are punctuated with ``dot'' commands for interpretation by
processing programs such as _man_ and _manps_.  Each command has the
form of a period (.) followed by a two-letter command name.  Arguments
to a command are separated from the command by a space. Text that does
not start with a period is considered text to be processed. Text
portions need not be formatted in the source file, as the processing
programs will perform all the necessary formatting.
.PP
.PP Dot Commands
.BR
The ``dot'' commands are described below.  In the descriptions,
``s'' denotes a set of characters while ``n'' denotes a number.
Arguments shown between [ ] brackets are optional.  If the optional
number is omitted, zero is assumed, unless otherwise noted.
.IP 15 .TH s1 s2
Title Header.  _s1_ is the entry's title, followed by
a space, and then the associated section, _s2_.  Both arguments
must be in uppercase. (e.g. .TH MANUALS F)
.IP 15 .DA s
Date.  _s_ contains the date of the last modification of the entry
in this format: 12 March 1992.
.IP 15 .SH s
Subheader.  Displays _s_ fully left justified.
.IP 15 .LM [n]
Left Margin.  The value of _n_ is added to the current left margin.
A negative value narrows the margin, while a positive value widens it.
.IP 15 .RM [n]
Right Margin.  The value of _n_ is added to the current right margin.
A negative value narrows the margin, while a positive value widens it.
.IP 15 .PP [s]
New Paragraph (with optional _s_ paragraph header).
.IP 15 .IP [n [s]]
Indented Paragraph.  Begins a new paragraph, setting the indentation to
_n_ columns.  If _s_ is included, it is displayed at the left margin,
and the print position tabs out to the indentation point.  The
effect is what you see here -- the dot commands are left-margin justified,
while the descriptions are indented.  Use .IP with no arguments to disable
indentation.
.IP 15 .CN s
Centers _s_, followed by line break.
.IP 15 .SP [n]
Spaces.  Print _n_ spaces (default is 1).
.IP 15 .RC [n] s
Repeat Character.  Prints the _s_ character _n_ times.  If _n_ is omitted,
_s_ is repeated up to the right margin and a line break follows.  Use this
command to display characters that would be misinterpreted if included
in text (e.g. ``.RC 1
.SP
.RC 1 _
'').
.IP 15 .BR [n]
Break.  Inserts _n_ line breaks (default is 1).  This moves the printing
position to the next line, respecting current indentation settings.
.IP 15 .AF [n]
Auto-Fill.  If _n_ is given, auto-fill is turned on (1) or off (0). If
no argument is given auto-fill is toggled.  Proceeding text lines
are displayed with no formatting.  Blank lines are ignored, but
commands such as .BR are still recognized.
.IP 15 .UC [s]
Underline Character.  Sets the emphasis-toggle character to _s_ (default
is the underscore `
.RC 1 _
'). Text selections surrounded by this character are
emphasized. For video displays, this results in either highlighted or
underscored text.  For dot matrix printers, the text is underlined.  For
PostScript devices, the text is italicized.
.IP 15 .NP
New Page.  Ends the current page by printing the appropriate number of
lines, followed by the page footer.
.IP 15 .IF n
If fewer than _n_ lines remain on the page, a new page (.NP)
is performed.  Include .IF before tables or lists that should
not be broken across pages.  The .SH, .PP and .IP commands include
built-in widow control, as if ``.IF 2'' precede them.
.IP 15 .TB n
Tab to column _n_ from current print position.
.IP
An excellent way to learn to ``program'' a new manual entry is to
compare the contents of an existing entry with its printed output,
noting how each dot command effects the display.
.PP
.PP Typographic Conventions
.BR
Whenever reference is made to the command being described by the entry,
always highlight it using the underscore/highlight quoting character.
Similarly, reference to other commands should be highlighted as well.
Highlighting is valuable for making urgent or important passages of
text stand out.  Such text is displayed in italics on PostScript printers.
.PP
Use typographer's quotation marks.  These consist of the apostrophe (')
and accent grave (`) characters, either singularly or in pairs.  ``Like
this,'' for example.
.PP
Whenever examples are used that reference items that the user might see
on the screen, turn off the auto-fill mode (.AF).  Text that is not
auto-filled is displayed in Courier, a monospace font, on PostScript
printers. This has a the desirable effect of making the text
stand out in a ``computer-like'' typeface.
.SH Files
$/sys/man/* - contains manual sections and entries.
.SH See Also
man(CT), manps(CT), whatis(C)
