.TH SERVER C
.DA 16 May 1991
.SH Name
server - Internet file server
.SH Syntax
server
.SH Description
_Server_ processes any file server requests found in the server's mailbox
file.  Requests are made by sending mail to server@host, putting the
request in the Subject field of the message.  If the ``Subject:'' field
is blank or not found, the request is assumed to be in the first line
of the body of the message.
.PP
Request commands are:
.LM 5
.IP 20 DIR [dir ...]
Request directory listings
.IP 20 HELP
Request help on using the server
.IP 20 INDEX [dir ...]
Request index files for the server directories
.IP 20 MAP [host ...]
Request a site map from the host's archives
.IP 20 SEND [dir/]file ...
Request a file from the server's archives
.IP
.LM -5
The optional [dir] argument (without the brackets, of course) is the
name of a subdirectory area within the server's main directory.  The
user needn't specify a complete path to the directory, only the
directory's name.  Example:
.IP 5
.AF
index apple2
.AF
.IP
Should the directory itself contain another directory, the user can access
it by using a slash to separate the two (e.g. ``index apple2/programs'').
.PP
The server commands (except for HELP) can take multiple arguments. 
Example:
.IP 5
.AF
send file1 file2 dir/file3
.AF
.IP
If the MAP command is given without an argument, a directory listing of
the map archive area is sent.
.PP
.PP Server Default Directories
.BR
By default, the server's domain includes $/pub and all the directories
within it, and the site maps are assumed to be found in $/sys/maps. The
administrator may choose different paths to these areas by
editing the server resource file (_$/etc/rsrc/server.rsrc_) and placing
the complete path to the main server directory in the first line of the
file, and the complete path to the map directory in the second line.
.PP
.PP Notes On Using INDEX and DIR
.BR
When these commands are used without any arguments, the entire structure
within the main server directory is referenced.  This means that if DIR
alone were specified, the user would get directories for all the
subdirectories inside of the server's domain.  Likewise, INDEX alone
would get indexes for all server areas.
.PP
When a directory argument is used with DIR or INDEX, the structure
including that directory and its domain is referenced.  In short, these
commands return the entire tree (if no argument is given), or branches
of the tree depending on the argument given.  Most server archives have
directory structures only a level or two deep.
.PP
.PP Setting Up The Server
.BR
As stated, the server's domain is the $/pub directory and all files and
subdirectories within it.  If your server archives contain numerous files
it is best to organize them into subdirectory areas.
.PP
Each area (including $/pub) should contain a file named INDEX
which gives a quick table of contents for that area.  The INDEX file format
is not rigid, though it should at least contain this information:
.IP 5 o
Name of the host system
.IP 5 o
Name of the area
.IP 5 o
Date when the index was last modified
.IP 5 o
Contents of the area
.IP
Typically, the content list contains entries, one per file, giving the
name of the file and a short description.  You can add more information if
you desire, though it is best to be as brief as possible, giving only the
information necessary for browsing.
.PP
.PP Access Protection
.BR
The server abides by the permission attributes assigned to directories
in the server archives.  If a user requests a file from a directory that
does not have read permission, the request is stored in the queue file
called $/etc/server.req (which can be used as a shell script later on).
The root user can validate each entry, removing those without
clearance, then launch the file as a shell script in order for
the file requests to be fulfilled.  Example:
.IP 5
.AF
source server.req
.AF
.IP
The file's type is text, and requires the shell's ``source''
command in order to run.
.PP
.PP Server Message
.BR
Every outgoing file sent by the server can also include an optional
message.  This message is stored in the $/etc/help/server.msg file.
This could include short messages such as rules regarding server
usage, and so on.  It should probably end with a dashed ``cut here''
line to let the requester know when the real file starts.
.PP
.PP Server Log
.BR
The server maintains a log file ($spool/logs/servlog) listing the requests and
when they were processed.
.SH Files
$/pub - server's domain,
.BR
$/sys/maps - site map archive area,
.BR
$/sys/mail/server - server's mailbox,
.BR
$spool/logs/servlog - server log file,
.BR
$/etc/server.req - server requests pending validation,
.BR
$/etc/help/server - server help file,
.BR
$/etc/help/server.msg - server message file,
.BR
$/etc/rsrc/server.rsrc - server's resources.
.SH See Also
rcp(NET), sendmail(C)
