.TH MV C
.DA 16 May 1992
.SH Name
mv - Move a file
.SH Syntax
.PP
mv _file_... [ _target_ ]
.SH Description
_Mv_ moves one or more files to another file or directory. The source file
may be in another directory, in which case a path must be given.  _Mv_
is useful for renaming a file as well.
.PP
If the _target_ is a directory, the source _files_ are moved to files
in the _directory_ using their original filenames.
.PP
If the destination file does not exist, it is created, and the contents
of the source files are moved.
.PP
If a source _file_ is given, but no target _file_, the current working
directory is assumed as the target area, preserving the original filename,
though _mv_ refuses to move a file to itself.
.PP Example:
.IP 5
.AF
mv godel escher bach $/usr/mdavis
.AF
.IP
This moves three files from the current working directory to the
directory $/usr/mdavis.
.IP 5
.AF
mv tycho brahe
.AF
.IP
In this example, ``tycho'' is simply renamed ``brahe''.  If ``brahe''
existed before _mv_ was used, it is deleted before the name change is done.
.SH See Also
add(C), cp(C)
