.TH MAIL C
.DA 30 March 1994
.SH Name
mail - ProLine mail
.SH Syntax
mail [ -m mbox ]
.BR
mail [ -n ]
.BR
mail [ -s ] user ...
.SH Description
_Mail_ is an interactive electronic mail management system that lets you
send, receive, and store messages.  Because of its interactive nature, _mail_
is best learned by use.  To invoke _mail_, use any of the following
examples:
.LM 5
.IP 20 mail
Reads messages in your mailbox.
.IP 20 mail -m letters
Reads messages in the file ``letters''.
.IP 20 mail -n
This flag causes mail to display ``No new mail'' and exit if your mailbox
has not been changed since the last time you read mail.
.IP 20 mail user
Sends mail to ``user''.
.IP 20 mail -s
_Mail_ prompts you for the name of a user to send to.
.LM -5
.IP
The command levels in _mail_ respond to single-key abbreviations for
command names.  They are expanded for you automatically. A list of
available commands is displayed by typing a ``?'' at any prompt.
.PP
Upon entering _mail_, the mailbox will be scanned for all your messages.
A report is then listed which shows various information about each message,
including the sender's name and the subject.
.PP
.PP Reading Mail
.BR
_mail_ recognizes the following interactive commands at the mail> prompt.
To invoke a command, enter the first letter of its name:
.IP 20 [RETURN] / [SPACE]
Pressing the RETURN or SPACE keys advances you to the next message, and
displays it.  (Displays the first message if none have been read.)
.IP 20 Next
Marks the current message for deletion, then displays the next message.
(Displays the first message if none have been read.)
.IP 20 Previous
Displays the previous message.
.IP 20 Type <msgs>
Displays the selected messages.  The ``current message'' number will be
set to the last message printed.
.IP 20 Again
Displays the current message.
.IP 20 Headers <msgs>
Prints a one-line header for the selected messages. The header contains:
a `*' if that message is marked for deletion, the number of the message,
the number of characters in the message, the sender's name, and the
subject.
.IP 20 List
Lists headers for all the messages (same as Headers All).
.IP 20 Send
Sends a message.  You are asked to fill in the ``To:'' field with the name
of the recipient (enter nothing at all to cancel), and the subject of
the message. You may then start typing the body of your message. (see
_Sending Mail_ below for more details)
.IP 20 Forward <msgs>
Forwards selected messages to others.  You address the message
as with Send above, and then enter some introductory comments of your
own which will appear at the start of the message. Once you leave text entry
mode, the forwarded message is appended into the outgoing message.
.IP 20 Reply to <msg>
Sends a reply to a message. _mail_ fills in the ``To:'', and
``Subject:'' lines of your reply. You have the option of entering the
addresses for additional recipients (if any) in order to send ``carbon
copies'' (Cc:).
.IP 20 Delete <msgs>
Marks selected messages for deletion when quitting. Messages marked for
deletion will have a `*' after their number in their header. Deletion
marks may be removed with the Undelete command.  Note: this only marks
messages to be deleted later.  Marked letters are still
accessible until you Quit.
.IP 20 Undelete <msgs>
Removes the deletion marks for the selected messages.
.IP 20 Write <msgs>
Writes the selected messages to a file.  If the target file exists, you
are asked if the messages should overwrite it or be appended to it.
.IP 20 View
Views a file from disk.
.IP 20 Edit
Allows you to edit a file while working in _mail_.
.IP 20 $ Edit Vars
Invokes the editor on your ``mailrc'' file which defines variables
that you may use with _mail_.  (See _Variables_ below for details.)
.IP 20 ! Shell Command
Executes a command line you enter at the ``!'' prompt.  Commands can be
anything that can be executed in a normal command line shell, including
invoking an interactive shell (_csh -c_ for example).  When the command
is completed, you can continue to enter additional commands at the ``!''
prompt, or press Enter to return to the current prompt in _mail_.
.IP 20 Open
Opens a new mailbox, allowing you to close the current one.  If the current
mailbox has messages marked for deletion, you are asked to confirm their
removal before the new mailbox is opened and processed.
.IP 20 Quit
Quits _mail_.  You are asked to confirm the removal of any messages
marked for deletion before quitting.
.IP 20 ? (help)
Shows a list of all the available commands.
.IP
The <msgs> argument to some commands may be one of the following:
.PP
.LM 5
All
.TB 25
All of the messages in the current mailbox
.BR
Current
.TB 25
Last message typed (same as RETURN)
.BR
Next
.TB 25
Next message (current message + 1)
.BR
Previous
.TB 25
Previous message (current message - 1)
.BR
First
.TB 25
Message number 1 (the oldest message)
.BR
Last
.TB 25
The highest numbered (most recent) message
.LM -5
.IP
Or <msgs> may be a list of numbers, as in these examples:
.PP
.LM 5
2
.TB 25
message 2
.BR
11-15
.TB 25
messages 11 through 15 (inclusive)
.BR
-15
.TB 25
first message through message 15
.BR
3-
.TB 25
message 3 through the last message
.LM -5
.IP
.PP Special Keys
.BR
All command levels in _mail_ support the + and - keys which turn
the _--More--_ prompt on and off, respectively.  Additionally, the
mail> and send> prompts allow you to type in a number (or numeric
range) to display the specified messages from your mailbox.  Using
the ``;'' key at any command prompt will list the headers of all
messages in your mailbox (same as the List command at the mail> prompt).
.PP
.PP Mail Strategy
.BR
Here's a strategy for reading and processing your mail efficiently
using _mail_.  Upon entering _mail_, examine the report of your messages to get
an idea of the kind of mail you have, the sizes of various messages, and
whether or not there are any which require immediate attention.
.PP
If you don't have any urgent messages, you can read each in turn with the
Next command.  Once a message has been displayed, it is referred
to as the ``current'' message.  You can reply to the current message with the
command ``Reply to Current''; this begins an outgoing message in
response to the message you've just read.
.PP
Using Next automatically marks the current message for deletion, and
then proceeds to display the next message.  If you press RETURN or
SPACE to advance to the next message, the status of the current message
is not affected. You can, however, mark any message to be deleted later
with the ``Delete'' command.  You may also want to proceed to the
next one.  If you want to read a message out of order, use the ``Type''
command followed by the number of the message and a RETURN.  Or, you
can simply type in the message's number (or a range) at any prompt,
followed by a RETURN.
.PP
In general, it is easier to deal with each message one at a time, as you read
it, although some people like to read all of their mail first, then go back
and delete and/or store away some of their messages.
.PP
When you are ready to leave _mail_, use the ``Quit'' command.  If you
have marked any messages for deletion, you will be asked if you actually
want them permanently removed. You may save a message marked for
deletion at any time with the ``Undelete'' command.
.PP
.PP Sending Mail
.BR
_Mail_ lets you send a message to one or more users on your local site,
as well as to users on distant sites on the network.  To address a
local message, you provide the user's account name (not the user's actual
name). You can specify a group of names (each separated by a space) in
order to send a single message to multiple users. Network mail addresses
can be entered using the ``user@site'' or ``site!user'' syntaxes.
.PP
After entering the address of the message, you are asked to fill in the
``Subject:'' field. Then, you'll be placed in text entry mode.  Anything
you type that does not start with your exit character (usually a period
``.'') is added to the body of your letter.  Word wrapping occurs at
column 75.  To exit text entry, type the exit character at the beginning
of a new line followed by RETURN.
.PP
The following interactive commands are recognized at the send> prompt,
as well as from text entry mode by prefixing them with the exit character
(i.e., ``.s'' is the same as typing ``s'' from the send> command prompt).
.IP 20 Add
Continues to add text at the end of your message.
.IP 20 List
Lists the header and body of your message.
.IP 20 Edit
Calls up the editor for use with your message.  After saving your editing
changes, you'll be returned to the send> prompt for further commands.
.IP 20 Include <msgs>
Includes the bodies of the specified messages from your mailbox into the
message, prefixing each line with the prefix character as defined in
the $prefix variable (usually the > symbol).
.IP 20 Headers ... <msgs>
Same as Include above, but it includes the header and body
portions of messages.
.IP 20 Forward <msgs>
Includes the header and body of the specified messages without formatting.
.IP 20 Get
Gets a file from disk and appends it to the end of the message.
.IP 20 Send
Sends the message to all the specified recipients.  If any outgoing network
addresses were specified, the file named _signature_, if it exists in your
home directory, is appended to the end of the message.
.IP 20 Modify
Modifies the To, Subject, Cc, and Bcc fields in the header of your
message.
.IP 20 To
Specifies the target recipient (To) addresses.
.IP 20 Reply-To
Specifies a Reply-To address for when the recipient of the letter generates
a reply, the reply will be sent to the address in this field instead of
the original author of the message.
.IP 20 Cc
Specifies ``carbon copy'' (Cc) addresses.
.IP 20 Bcc
Specifies ``blind carbon copy'' (Bcc) addresses.  These are like Cc's, but only
the users in the ``Bcc:'' field will be aware that they received copies of
your message.  The recipients in the ``To:'' and ``Cc:'' fields will not be
aware that additional copies were sent.
.IP 20 View
Views a file.
.IP 20 Write
Writes the body of your message to a file (with the option of to include
the header).
.IP 20 $ Edit Vars
Allows you to edit or peruse your variables.  (See _Variables_ below for details.)
.IP 20 ! Shell Command
Execute a command line.
earlier).
.IP 20 Open
Opens a new mailbox.
.IP 20 Quit
Quits without sending the message.
.IP
Messages are not actually delivered until you log off the system or
issue the _sendmail_ command from the C-Shell.
.PP
.PP Variables
.BR
_Mail_ accepts variables as shortcuts for lengthy or hard to remember
input. A variable is a keyword that begins with a dollar-sign ($), such as
$prompt.  When used in areas where text arguments are supplied, the values
of these variables are inserted (except in text input mode and the
``Subject:'' field of outgoing messages).  Variables can also be used
to control and customize the behavior of _mail_.
.PP
Some variables are defined for you automatically:
.IP 10 /
Contains the system's startup prefix. (Cannot be deleted)
.IP 10 addsig
If set to 1 (default), _mail_ attaches your ``signature'' file to
messages you send.
.IP 10 askcc
If set to 1 (default), you're asked if you want to include all
recipients in the carbon-copy field of outgoing messages.
.IP 10 clear
Controls the clearing of the screen at various points in _mail_. If set
to 0, disables any screen clearing.  If set to 1 (the default),
_mail_ will clear the screen upon entry and before any
list, file, or message is displayed.
.IP 10 current
Keeps track of the current message between sessions.
Delete this variable to disable this feature.
.IP 10 delmark
The character used to mark deleted messages, usually ``*''.
.IP 10 escape
If this variable is not defined or empty, your preferred editor will be
invoked for message input.  By setting the escape variable to any
character, _mail_ uses its built-in input mode for message composition. 
(You can still invoke your editor later).  The built-in editor
accepts one line of input at a time, until you enter a line that contains
only the character stored in the escape variable, which lets
you ``escape'' from input mode.  Escape sequences may include
one extra character which causes _mail_ to exit input mode and act on
the next character as if it were entered at the send> prompt.  The
default escape is `.', causing _mail_ to use the built-in input mode.
.IP 10 home
The path to your home directory. (Cannot be deleted)
.IP 10 lastime
This variable should not be changed.  It is maintained by mail
to keep track of the last time you read any mail.  Its purpose
is to hold the date and time (in a special decimal format)
for use with the -n flag when _mail_ is invoked.
.IP 10 mail
The path to your incoming mailbox.  (Cannot be deleted)
.IP 10 nomail
Controls exiting from _mail_ if the mailbox is empty.  If set to 0, invoking
_mail_ with an empty mailbox leaves you at the mail> prompt.  If set to 1,
an empty mailbox causes mail to report, ``No mail,'' and then quits.
.IP 10 org
Holds the name of the user's organization that is placed into the
Organization: field of outgoing messages.
.IP 10 prompt
This character (or string) is displayed for each new line of input
while in built-in text input mode.  (See _escape_).
.IP 10 quote
This character (or string) is used to ``quote'' each line included
from your mailbox into a reply.
.IP 10 replyto
Holds an address that is placed into the Reply-To: field of outgoing
messages.
.IP 10 summary
Controls the display of the message summary after entering _mail_.  If
set to 0, no summary is displayed.  If set to 1 (the default), a summary
of all messages in your mailbox is shown.  If set to 2, a summary of
only the current message to the last is shown.
.IP 10 wrtdel
If set to 1 causes messages written to a file to be marked for
deletion.  (default is 0)
.IP
The dollar-sign ($) introduces each variable used as input.
If you wanted to write a message to a file, you could enter:
.IP 10
mail> Write Current
.BR
to file: $home/tempfile
.IP
_mail_ sees $home and substitutes it for the path to your home directory,
saving you a few keystrokes.
.PP
Another example: You regularly correspond with a group of writers. 
Typing in all the names is a tedious task. Instead, you create a
variable to make life much simpler.  Let's say you've created your own
variable called ``writers'' in your _mailrc_ file:
.IP 10
.AF
writers=brock ryan dang rlouv davew garyw@site.com
.AF
.IP
To use it, follow this scenario:
.IP 10
mail> Send
.BR
To: $writers
.IP
_Mail_ replaces your variable with its value, which actually ends up
addressing the message like so:
.IP 10
To: brock ryan dang rlouv davew garyw@site.com
.IP
Variables can be used to substitute any part of a pathname, address, or
filename. They're not case-sensitive, and can reference other variables.
.SH Files
$home/mailrc - variable assignments,
.BR
$/usr/*/signature - signature file,
.BR
$/adm/*/mailstop - prevents sending offsite mail.
.SH See Also
sendmail(C), rcp(NET)
.SH Author
Morgan Davis
