.TH ITC C
.DA 30 January 1994
.SH Name
itc - InteleTerm Pro script compiler
.SH Syntax
itc [ _name_ ]
.SH Description
_Itc_ is a script compiler that generates scripts for use with _it_,
the InteleTerm Pro terminal program.
.PP
Without arguments, _itc_ asks for the name of
a script to compile.  You can also the script _name_ in the
command line by including its name only (not the full path) as an argument
to _itc_.  Leave off the .src extension as _itc_ adds it for you.
Example:
.IP 10
.AF
itc bix
.AF
.IP
This compiles the ``bix.src'' script, writing the compiled output to
``bix''.  You can also use the [C]ompile command from the
[S]cript menu within _it_.
.PP
.PP Creating and Editing Scripts
.BR
_It_ scripts can be created with your text editor.  From the [S]cript
menu in _it_, choose [N]ew to create a new script, or [E]dit to edit
an existing one.  Again, leave off the ``.src'' extension when
referencing your script.
.PP
The format of a script file follows these rules:
.LM 5
.IP 4 1.
Each instruction is on a line by itself
.IP 4 2.
Labels are declared on lines by themselves and a colon (:) follows the
label name.
.IP 4 3.
When labels are referenced, the colon is not used.
.IP 4 4.
Indenting is optional, but aids in keeping
your script readable.
.IP 4 5.
Quoted text arguments can have control characters
imbedded in them by entering a caret (^) followed
by the letter (upper or lowercase) of the corresponding
control character.  For example, to put a carriage
return at the end of a PRINT instruction, you would use:
.BR 2
.SP 5
PRINT "Testing^M"
.IP 4 6.
Quoted text arguments can include characters like quotes, carets, and
backslash by prefixing them with the backslash (\).
.IP 4 7.
Text arguments containing spaces must be put
between quotation marks, otherwise the program will
only recognize the first word in a series of words.
.IP 4 8.
A space character must separate a command from its
argument(s).
.IP 4 9.
Comments can be placed on lines by themselves following any of these
comment characters: pound (#), semi-colon (;), apostrophe ('), asterisk (*).
.IP
.LM -5
.PP
.PP Scripting Language
.BR
The script language consists of these commands:
.IP 15 do label
Causes script execution to begin executing instructions at _label_.
When a return instruction is encountered, program flow resumes with the next 
instruction following the do command.
.IP 15 term
Temporarily pauses script execution and puts you into terminal mode.  When
you exit terminal mode, script execution continues.
.IP 15 goto label
Diverts script execution to a certain label.  Unlike do, a return will
not return to the instruction after the goto.
.IP 15 clear
Clears the screen and puts the cursor in the upper left corner.
.IP 15 print "text"
Displays text on the screen, but is not sent to the modem.  Add ``^M''
at the end of the text to issue a carriage return.
.IP 15 speed bps
speed will set the bits per second rate for use with _it_.  Values for _bps_
are 300, 1200, 2400, 9600, 19200, 38400, and 57600.
.IP 15 echo mode
Sets up local or remote echo modes for terminal mode.  Arguments for _mode_
are on and off.  Echo on is half duplex (local echo).  Echo off is full
duplex (remote echo).
.IP 15 dial number
Dials a phone number.
.IP 15 connect
Attempts to connect with a host computer after dialing.  Use the IF
statement after executing connect to determine if connection was
successfully established.
.IP 15 return
Causes script execution to return to the line following the corresponding do
instruction.
.IP 15 wait "text"
Halts script execution until ``text'' has been received.  This is
used for handshaking on incoming data.  Use the if instruction to determine
if pattern was found.
.IP 15 if condition [ then goto ] label
.BR
IF is used to test the most recent function performed by the script, such as
attempting to connect with a host computer, sending or receiving a file, or
handshaking on incoming text.  Example conditions for use with IF are:
.BR 2
.AF 0
if found goto ...    if ok goto ...
if connect goto ...  if good goto ...
if failed goto ...   if bad goto ...
if true goto ...     if success goto ...
if false goto ...    if no goto ...
if yes goto ...
.AF 1
.BR
Place not or no in front of a condition to negate it, such as ``if not
found goto label''.  The words ``then'' and ``goto'' are optional.  If
the condition is true, the script branches to the label referenced
at the very end of the if instruction.
.IP 15 send "text"
Works like print, except sends text to the modem and not to the
screen.  If you need to send a carriage return, use ``^M'' (caret
followed by the letter M).
.IP 15 hangup
Disconnects the modem with the host, and hangs up the phone.
.IP 15 sendfile file [ delay [ char ] ]
.BR
Send the text in _file_, line by line.  Output is paused
after each line for _delay_ seconds if included. The next line is not sent
until _char_ is received if the optional _char_ argument is included.
Example:
.BR 2
.AF
sendfile bletch.txt 2 :
.AF
.BR
This sends the file ``bletch.txt'' line by line, with an interline delay of
2, and waits for a colon from the host before each line is sent.
.IP 15 break
Sends a modem break tone.
.IP 15 sleep seconds
Causes script execution to pause for the _seconds_ specified, then execution
resumes.
.IP 15 exec command
Executes the system command line in _command_.  This can be used to
run any program on the system, such as external protocols, or a C-Shell
that invokes a shell script.  Examples:
.BR 2
.LM 5
.AF 0
exec "csh cd /profile/mail; rm tempfile"
exec "sz filename"
exec "csh source batch.script"
.AF 1
.LM -5
.BR
Commands with spaces must be enclosed in quotation marks.
.BR 2
When the command is complete, control returns to _it_ and the
script continues.  ``If'' statements can be used to test the success
of the exec command.
.IP 15 run script
Lets you run a different script file from within a script.
.IP 15 end
Causes a script to stop running.  If you're online, you're taken right to
terminal mode.
.IP 15 exit
Causes the script to stop running and forces _it_ to quit.
.IP 15 printer mode
Specifies whether any output which is shown inside the terminal mode window
will be sent to the printer or not.  Values for _mode_ are on and off.
Printer on sends output to the printer, while printer off does not.
.IP 15 emulate terminal
.BR
Initializes terminal emulation for the named terminal template file.
.IP
.PP Function Key Labels
.BR
Labels that begin with the name ``fkey'', followed by a digit from
0 to 9 (e.g., fkey5:, fkey8:, etc.), denote entry points in loaded scripts
when the Command key and a digit are pressed in terminal mode.  Issuing
a function key is like choosing the Goto command from the Scripts menu
in _it_ and selecting a label.  As soon as the script ends, control returns
to terminal mode.  This makes it possible to create ten key-triggered
functions in each script.
.SH Files
$home/src - directory containing scripts.
.SH See Also
it(C)
