.TH INSPECT C
.DA 28 September 1993
.SH Name
inspect - Inspect contents of files
.SH Syntax
inspect [ _options_ ] _file_
.SH Description
_Inspect_ describes the contents of _file_. If _file_ is determined to
be a NuFX (``SHK''), Compact Pro (``CPT'') or StuffIt (``SIT'') archive,
its enclosed files, folders and disk images are listed. If _file_ is
determined to be a CompuServe GIF(tm) format graphic, information about
its size and color depth is provided.
.PP
_Inspect_ takes two options:
.IP 5 -b
displays Binary II or MacBinary information if present.
.IP 5 -i
identifies the file as a particular type, but does not list its contents.
If the last argument given to _list_ begins with `>', it redirects
output to the filename that follows.
.IP
.SH Notes
Full support for self-extracting CPT and SIT archives is provided, but
support for self-extracting SHK archives created by GS ShrinkIt is not.
.PP
Primitive support for ``MOD'' format music files is provided in that files
beginning with ``MOD.'' or ending with ``.MOD'' list their internal music
score names.
.PP
The ProDOS 8 filetype lookup table has been placed at the end of the program
to facilitate modification or expansion by any BASIC programmer.
.PP
_Inspect_ uses 16-bit CRC routines placed in the public domain by Jim Ferr.
.SH Diagnostics
``Could not load OMM module CRC'' -- the support module $/sys/modules/CRC
could not be found and loaded into memory.
.PP
``NuFX master header damaged'' -- The file is determined to be a SHK
archive, but its master header is not in the proper format.
.PP
``NuFX local header damaged'' -- The file is determined to be a SHK
archive, but one or more of its entries are not in the proper format.
.PP
``StuffIt archive header damaged'' -- The file is determined to be a SIT
archive, but its master header is not in the proper format.
.SH Files
$/sys/modules/CRC - support module with CRC routines
.SH See Also
unpar(C)
.SH Author
Jon C. Thomason (jonct@pro-applepi)
