.TH IF C
.DA 12 May 1992
.SH Name
if - Conditional command execution
.SH Syntax
if _expression_ then [ _command1_ [ else _command2_ ] ]
.SH Description
_If_ tests the _expression_, and if it results in a true value, performs
_command1_ following the _then_ keyword.  If the _expression_
is false, and an _else_ keyword is given, _command2_ is performed.
.PP
.PP Multiple Lines
.BR
_If_ statements can span more than one line in order to issue multiple
commands.  This is an example of a compound _if_ statement:
.IP 5
.AF
if expression then
     command
     command
     ...
endif
.AF
.IP
The _endif_ keyword denotes the end of a compound _if_ statement.
Here's an example using an _else_ option:
.IP 5
.AF
if expression then
     command1
     ...
else
    command2
     ...
endif
.AF
.IP
.PP Expressions
.BR
Typical expressions include:
.IP 10 x = y
Equality (== can be used)
.IP 10 x <> y
Inequality (!= can be used)
.IP 10 x > y
Greater
.IP 10 x < y
Smaller
.IP 10 x >= y
Greater or equal
.IP 10 x <= y
Less or equal
.IP 10 -f file
Existence of a file
.IP
The values for x and y in expressions can be any kind of argument, including
variables.  Multiple expressions can be included as well, with parenthesis
used for precedence.  To mix expressions logically, separate them
with these two keywords or symbols: and (&&), or (||).  To negate the result
of an expression, precede it with the keyword _not_ (also !).  Example:
.IP 5
.AF
if $a = $b then echo TRUE else echo FALSE
.AF
.IP
Another example:
.IP 5
.AF
if $time[0] = "Sun" and -f workfile then
     echo It is Sunday AND the workfile exists!
else
     echo EITHER it is not Sunday
     echo OR the workfile does not exist.
endif
.AF
.IP
.PP Nested Statements
.BR
Nested _if_ statements can be used in a script, as shown:
.IP 5
.AF
if ( expr1 ) then
     if ( expr2 ) then
          echo "expr1 AND expr2 are true"
     endif
else
     echo "Either expr1 OR expr2 is false"
endif
.AF 1
.IP
Each _if_ must have a matching _endif_.
.SH See Also
csh(C), scripts(M)
