.TH DL C
.DA 3 May 1988
.SH Name
dl - Data Librarian
.SH Syntax
dl
.SH Description
(Throughout this manual entry, _dl_ denotes the location of the Data
Library).
.PP
The data librarian offers an easy way to upload and download programs.
The library metaphor is used extensively throughout this program.  Users of
the data library can ``open'' specific card catalogs (a program category; ie.,
Business, Games, Graphics, Utilities, etc.) and ``browse'' through the
descriptions for each title on the ``shelf'', selecting which files they want to
``reserve'' (flag) for ``check out'' (download) when they're ready to leave.
.PP
Each file in the library has an ``index card'' describing the file name, type,
size, author, and a short synopsis of what the file is used for.  The user can
search through all index cards in a particular card catalog using ``key words''
in the title and/or description (ie., ``word'' would display all index cards
that have the search pattern anywhere on the card -- wordprocessing, PC-Word,
wordwrap, and ``the latest word'' would trigger a match).  At the bottom of each
card is a ``cross-reference index'' that links the card to various card catalogs
in the library, so that only one card (file) has to be ``donated'' (uploaded). 
This method makes it easier for the user to find a particular file, and
makes multiple uploads into different file areas unnecessary.
.PP
XMODEM protocol is used for transferring data files, although if the
file is text (TXT) the user can request an ASCII text transfer and
capture the file to disk or a copy buffer.
.PP
The data library program is highly interactive, and contains an excellent
built-in tutorial (the ``information desk''), so the best way to learn it is to
use it.
.SH Files
_dl_/lib/prog/*
.TB 22
- program files in the library,
.BR
_dl_/lib/desc/*
.TB 22
- description files for catalog cards,
.BR
_dl_/lib/link/*
.TB 22
- link file indexes,
.BR
_dl_/lib/dl.vars
.TB 22
- environment file,
.BR
_dl_/lib/dl.data
.TB 22
- data definitions,
.BR
_dl_/lib/dl.user
.TB 22
- last online database for See What's New,
.BR
$/sys/pdl/dl.dir
.TB 22
- working prefix for the data library,
.BR
$/sys/pdl/dl.sort
.TB 22
- DL code overlay for data/pointer sorting,
.BR
$/sys/pdl/dl.xfer
.TB 22
- DL code overlay for upload/download,
.BR
$/sys/pdl/*
.TB 22
- text files for data library online help.
.SH See Also
dl.maint(C), rx(C), rz(C), sx(C), sz(C)
.SH Author
Jerry Hewett
