.TH CSH C
.DA 6 May 1994
.SH Name
csh - Command shell
.SH Syntax
csh [ -c ] [ _command_ ]
.SH Description
_Csh_ is a command interpreter.  Without any arguments, _csh_ goes
through a normal startup procedure, eventually giving you a command line
where you can enter more commands.
.PP
If _csh_ is invoked with a _command_ argument, it processes that command
and exits when finished.  If the -c flag is included, _csh_ processes the
command, but does not exit.  If only -c is given, the shell immediately
presents a command line for entering commands (it does not run your _login_
script, described later).
.PP
.PP About The Shell
.BR
_Csh_ is the central program from which all other programs can be
accessed. It is often called a command interpreter, acting as a liaison
between you and the system.  To instruct the system to perform a task,
you enter your request on a command line.  The shell processes the
command line to carry out your request by means of a built-in shell
function, or by selecting a program external to the shell to complete
the request. The shell contains many internal functions for use in the
shell environment. There are even more external programs that
can be called upon from the shell.  After a command line is processed,
the shell prompts you for additional commands until you're ready to
quit.
.PP
The shell can also process a series (or _batch_) of commands contained
in a file, as if they had been entered by hand on the command line. 
Files containing shell commands are called _shell scripts_.  Scripts
use special features to control the execution of commands in a way
that reduces arduous tasks into simple, automated procedures.  More on
scripts later.
.PP
.PP The Command Line
.BR
Executing a built-in or external command from the shell is simple --
just type in the command's name.  While typing in a command line,
various editing keystrokes are available:
.IP 10 ^X
cancel what you've entered so far
.IP 10 ^H/DEL
rubout the character left of the cursor
.IP 10 ^W
rubout the word left of the cursor
.IP
.PP Command Line History
.BR
The shell maintains a history of the 20 most recently entered commands.
You can scroll through command lines entered and repeat one by pressing
Control-P (for previous) to move backward in time toward the
oldest command lines. Pressing Control-N (for next) moves forward
to the most recent command lines.  
.PP
The shell also recognizes the exclamation point (!) character at the
beginning of each line as a way of referencing specific history lines.
.IP 10 !!
Selects the last entered command line.
.IP 10 !#
Selects a command line by the number associated with #.
.IP 10 !text
Selects the most recent command line that begins with a pattern of text.
.IP
.PP Arguments and Special Characters
.BR
In many cases, you may need to give extra information, or _arguments_, to
a command. To help the shell determine which items are commands and
arguments, separate them with space characters.
.PP
To specify a single argument that may contain spaces within it, enclose
the argument in quotation marks.  Example:
.IP 5
.AF
echo "This is one argument"
.AF
.IP
The shell ignores most control characters entered on the command line. To
insert a control character, use a caret before the corresponding
letter (e.g., ``^G'' for Control-G).
.PP
If you need to enter a quotation mark or caret in an argument, prefix
it with a backslash ``\'' character.  Likewise, to enter a backslash,
prefix _it_ with a backslash (in other words, two backslash characters
make one). Examples:
.IP 5
.AF
echo "\"Wow!\" she exclaimed."
echo "Here is a caret: \^"
echo "Here is a backslash: \\"
.AF
.IP
Using a backslash to insert special characters is known as _escaping_. 
There are other characters the shell recognizes as having special
meanings, such as the dollar sign ($), tilde (~), period (.), and
asterisk (*).  These are discussed later.
.PP
.PP Built-In Commands
.BR
The shell has many built-in commands.  They are listed below along with the
arguments they require.  Optional arguments are shown between [ brackets ].
Arguments shown with ``...'' following means ``one or more of the same''.
.IP 20 add src... [targ]
Adds source file(s) onto the end of the target file.  If one file argument
is given, the file must reside outside of the current directory and will be
appended to a file in the current directory with the same name.  If more than
one argument is given, the final argument is the target file, and all others
are appended onto it.
.IP 20 alias [old new...]
Substitutes a command name with a new name (and any additional
arguments). The new replacement arguments may contain the following
special characters: !^ (inserts the first argument from the command line
here), !$ (inserts the last argument here), and !* (inserts all
arguments here).  Entering alias without any arguments displays a list
of the current aliases.
.IP 20 cat file...
Short for ``concatenate''.  _Cat_ is normally used to display the contents
of a file, but is also useful for redirecting a file to other files
or devices (e.g. a printer).
.IP 20 cd [dir]
Changes the current working directory.  If the argument is omitted, the
current directory becomes your $home directory.
.IP 20 clear
Clears the screen.
.IP 20 cp src... [targ]
Copies a file.  If only one file is given, it must reside outside
of the current directory, and is copied to a file of the same name within
the current directory.  If more than one argument is given, the source files
are copied onto the target file.  If the target is a directory, the files
are copied into the directory, retaining their names.
.IP 20 echo [-n] args...
Echoes any arguments that follow.  If the -n option is given, no newline
is printed after the final argument.  To redirect output from echo
to a file, include >file as the last argument.  To append output to an
existing file, use >>file.
.IP 20 exec command...
This replaces the current shell with a new command interpreter.  If
called from a shell script, the script is terminated.
.IP 20 exit [n]
Tells the shell to quit and return to the calling process. Typing
Control-D is recognized as the _exit_ command, too.  The optional number
argument useful for returning a result code to the calling process
(default is zero).
.IP 20 history
Displays the 20 most recent command lines.
.IP 20 if expr then [...]
Conditional test to execute commands.  This is normally used within
shell scripts and is discussed later.
.IP 20 logout
Terminate connection immediately.
.IP 20 mkdir dir...
Makes a subdirectory.
.IP 20 mv src... [targ]
Moves a file from one place to another.  It works identically to _cp_,
except it deletes the source file after copying it to the target.
It is also used to rename a file if both src and targ reside in the
same directory.
.IP 20 pwd
Prints out the name of the current Working Directory.
.IP 20 read var
Reads input from the user and assigns it to a variable.
.IP 20 rm file...
Removes files and empty directories.
.IP 20 set [var=value...]
Sets shell variables to specified values.  Set without arguments displays
the currently set variables.
.IP 20 shift [var]
Shifts the arguments in the command line down by removing the first
argument.  Without arguments, _shift_ affects argv (see the discussion
on variables later for details). By including an optional variable name,
that variable is affected.  This command is typically used by shell
scripts for argument parsing.
.IP 20 source file
Executes shell commands from a text file.
.IP 20 unalias name...
Removes aliases.
.IP 20 unset var...
Removes variables.
.IP
Many more commands can be called up from disk by the shell.  One such
command is _ls_, which lists the contents of a directory.  To see
the names of all the disk-based commands, enter:
.IP 10
ls $path
.IP
Entering a command without any arguments usually displays a line of
``usage'' information.  You can get more information about a command by
using the _man_ command (short for ``manual'').  _Man_ requires the name
of the item you want more help on as an argument.  It prints out nicely
formatted pages from the online manual. (Try the ``man man'' command -- it
lets _man_ tell you more about itself).
.PP
.PP Access Permissions
.BR
The shell watches certain requests to make sure the user has the
required access permissions. There are four types of file access:
reading from a file, writing to or creating a file, destroying a file,
and executing a file.  Under ProLine, access permissions are specified
for the entire contents of a single directory level, rather than on a
file-by-file basis.  (See _dstat_ for more details).
.PP
.PP Output Redirection
.BR
If you're using the system from the local console, you can redirect the
output from the shell and other programs to a printer attached to the
computer.  To do this, include _>.printer_ as the final argument to a
command line. This tells the shell to turn on printer output.  It's only
good for one command, so there is no additional command to turn it off;
it will do so when it wants another command from you.
.PP
Example:
.IP 10
.AF
echo This is a test >.printer
.AF
.IP
Another form of output redirection is to send output into a file, rather
than to the console or printer.  The syntax is similar to _>.printer_.
.PP
Example:
.IP 10
.AF
man csh >temp
.AF
.IP
In this case, it is _man_'s job to handle redirecting its output into the file
called ``temp'' (or whatever name you provide). Unfortunately, not all programs
on the system provide this ability. Check with _man_ to see if a certain command
provides file output redirection.
.PP
.PP Directory Shorthand
.BR
The shell looks at the arguments you give to see if any start with
special characters that reference directories.  These characters are one
or two periods (.), and the tilde (~).
.PP
When the shell encounters a single period, it replaces it with the path
to the current working directory.  If it sees two periods, it replaces
them with the name of the parent directory of the current working
directory.  In other words, two periods means to step back one directory
level.  So, if a single periods refers to $/usr/jholt, then two periods
refer to $/usr.
.PP
The tilde (~) is directory shorthand for referencing home directories.
To access a file in your home directory called stuff when the current
directory is not your home, use ``~/file''.  The shell sees ``~/''
and knows that you're referencing your home directory (which is
shorthand for ``$/usr/your_login_name/file'').  By introducing the
login name of another user between ~ and /, you reference that user's
home directory.  For example, ``~jsbach/sonata'' is short for
$/usr/jsbach/sonata.
.PP
.PP Shell Variables
.BR
Shell variables are short names given to command line items that are
cumbersome or hard to remember.   The shell comes with a number of
preset variables containing useful information. To obtain the value of a
variable, a dollar sign ($) is placed before its name (e.g. _$path_)
.PP
Variables the shell defines for you are:
.IP 10 /
Directory in which ProLine resides on the local file system.
Since one ProLine system may have a startup prefix that is different
from another ProLine, the _$/_ variable allows ProLine systems to work
consistently in the shell from one system to the next.
.IP 10 argc
Contains the count (+1) of the arguments passed to a shell script.
.IP 10 argv
Contains the shell script's name and arguments passed.
.IP 10 caller
The system caller ID number.
.IP 10 cwd
The current working directory.
.IP 10 date
The current date and time in the standard ProLine date format:
.BR 2
Sat, 18 Apr 92 10:22:19 PDT
.IP 10 editor
The name of the editor used to edit text files on ProLine.
.IP 10 exit
If set, any errors in a shell script cause the script to halt.
By unsetting this variable, errors will allow a script to continue
processing.
.IP 10 gid
Your group-ID number.
.IP 10 home
Your home directory.
.IP 10 host
The name of the host system.
.IP 10 login
Your login name.
.IP 10 mail
The path to your mailbox file.
.IP 10 name
Your first and last name.
.IP 10 path
A list of paths to directories containing external command files.
.IP 10 prompt
Your shell prompt.
.IP 10 shell
Path to the shell program.
.IP 10 shlvl
The number of nested shell levels.
.IP 10 status
The result of the last command.
.IP 10 time
The current day of the week, date, month, year, hours, minutes, seconds,
and day of week number in this format:
.BR 2
Sat 18 04 92 10 22 19 6
.BR 2
Month values are 01 for Jan up to 12 for Dec.
Day of week values are 0 for Sun up to 6 for Sat.
All numeric values (except for day of the week number) are padded with
zeroes to fill out to two digits.
.IP 10 tmpdir
Path to a directory for temporary file storage (usually a RAM disk or
fast hard disk volume).
.IP 10 tty
Contains ``modem'' or ``console'' depending on how you logged in -- remotely
or locally.
.IP 10 uid
Your user-ID number.
.IP 10 version
The shell's version information.
.IP
.PP Subscripted Variables
.BR
You can access individual words within a variable by including a
subscript after the variable's name.  For example, to access the first
word of the $time variable (the day of the week), use $time[0].  To
access the hours, use $time[4].  To access arguments passed to a script
from within the script, use $argv[x] as appropriate.
.PP
.PP Avoiding Variable Expansion
.BR
The shell always expands variables to the values they contain, even when
placed inside quotation marks.  To cause the shell to pass a dollar sign
and a word through unexpanded, prefix it with a backslash.  (e.g.
``\$time'').  Consider the following:
.IP 5
.AF
alias   bye   "echo Login: $date[4]^MLogout: \$date[4]; logout"
.IP
.AF 1
In this alias definition, ``bye'' is defined with an echo command that
includes the $date variable in two places.  The first instance is not
escaped by a backslash, and therefore when this _alias_ command is
executed, the current time is inserted.  The second instance of $date
_is_ escaped by a backslash, and therefore the word ``$date'' is
literally inserted into the definition.  When the bye alias is actually
used, only then would the second instance of $date be recognized (since
the backslash would not be present), and the current time inserted. As a
result, the bye alias displays both the login and logout times before
disconnecting.
.PP
The same is true when assigning variables to a variable.  If you want your
shell prompt to display the current working directory, use:
.IP 5
.AF
set prompt="\$cwd> "
.AF
.IP
If the $cwd variable reference had not been escaped with a backslash,
this command would assign the prompt variable a value containing the
current working directory at the time when set was issued.
The prompt would never change even as new directories were chosen.
.PP
.PP Shell Scripts
.BR
You can instruct the shell to execute more than just one command at a time
by entering command sequences separated by semicolons (;) on the same
line.  But, if you need to execute many, often repeated command
sequences, it is best to put them into a shell script.
.PP
A shell script contains any commands you would enter on the command
line.  Once created using any text editor, you can execute the script by
using the _source_ command.  (To make a script executable without having
to use _source_, change its file type to CMD with the _setfile_ command).
.PP
.PP Initialization Scripts
.BR
When first launched, _csh_ sets up an internal environment which can
be further customized through various initialization scripts.
If it exists, _csh_ invokes a system-wide initialization
script _$/etc/cshrc_.  This script is set up by the administrator to
perform various sign-on tasks, like reporting new system bulletins
(_news_), reporting mail, and finally invoking the user's personal
_login_ script (discussed next).
.PP
When interactive subshells are launched without arguments, _csh_ does
not execute _$/etc/cshrc_ nor the user's _login_ script, but will
attempt to execute the user's personal _cshrc_ file, if it exists in the
home directory.
.PP
.PP The $/etc/cshrc Script
.BR
The system-wide startup script, _cshrc_, is expected to reside in $/etc
or the configured temporary files directory ($tmpdir), which might be a
high-speed RAM disk. If the system-wide _cshrc_ does not exist, _csh_
attempts to execute the user's _login_ script during a login session.
.PP
.PP The Login Script
.BR
Each user has a special script of startup commands. The script is
called _login_ (~/login). This file can
contain a variety of shell commands, and can be modified as desired,
allowing a unique and personal entry into the system for each session.
Once the _login_ script has done its job, the
shell may prompt for further commands, but typically _login_
invokes the user's personal _cshrc_ file.
.PP
The _login_ script is derived originally from the default script
($/etc/default/login) when an account is first created.
.PP
.PP Personal cshrc Script
.BR
The personal _cshrc_ file (~/cshrc), contains commands that are used
to install aliases and set variables such that each shell is set up
as the user desires.  This script is normally launched by a command
in the user's ~/login script, but is automatically run whenever
_csh_ invokes an interactive subshell.
.PP
.PP Script Control Using the IF Directive
.BR
To control execution of script commands, use the _if_ directive. _If_,
and its partners _else_ and _endif_, are used to test certain conditions
and execute only the commands which should be processed based on the
results of those conditions.  The condition is determined by the
logical expression given to _if_.
.PP
An example:
.IP 5
.AF
if $a = $b then echo TRUE else echo FALSE
.AF
.IP
Another example:
.IP 5
.AF
if $time[0] = "Sun" and -f workfile then
    echo It is Sunday AND the workfile exists!
else
    echo EITHER it is not Sunday
    echo OR the workfile does not exist.
endif
.IP
.AF
For more details on _if_ statements, see the if(C) manual entry.
.SH Files
$/bin/csh - C-Shell initialization program,
.BR
$/etc/cshrc - system-wide initialization script,
.BR
$/bin/cshx - C-Shell kernel code,
.BR
$/usr/* - your ``home'' directory (~),
.BR
~/login - your login startup script,
.BR
~/cshrc - your shell initialization script,
.BR
$/sys/modules/parse - parsing tools,
.BR
$tmpdir/cshenv* - temporary environment file,
.BR
$tmpdir/* - C-Shell runs faster when $/bin/cshx, $/etc/cshrc, and
$/sys/modules/parse live on a RAM disk.
.SH Author
Morgan Davis (mdavis@mdg.cts.com)
.SH See Also
if(C), plush(C), rc(ADM), scripts(M)
