**********************************************************
*                                                        *
*         NadaNet Definitions for Applications           *
*                                                        *
*            Michael J. Mahon - Oct 14, 2004             *
*                 Revised Apr 29, 2010                   *
*                                                        *
*         Copyright (c) 2004, 2008, 2009, 2010           *
*                                                        *
**********************************************************

version equ $31 ; NadaNet v3.1

********** Control Packet Definition **********

 dum 0 ; Control packet format:
rqmd ds 1 ;   Request & Modifier
frmc ds 1 ;   Complement of sending ID
dst ds 1 ;   Destination ID (0 = bcast)
frm ds 1 ;   Sending ID (never 0)
adr ds 2 ;   Address field
len ds 2 ;   Length field
   ; =========================
lenctl ds 0 ; Length of control packet
 dend

* Request codes (upper 5 bits) and modifiers (lower 3 bits)

reqfac equ 8 ; Request code factor (2^3)
reqmask equ 256-reqfac ; Request code mask (7..3)
modmask equ reqfac-1 ; Modifier code mask (2..0)

 dum reqfac ; Request codes (0 invalid):
r_PEEK ds reqfac ;   PEEK request
r_POKE ds reqfac ;   POKE request
r_CALL ds reqfac ;   CALL request
r_PUTMSG ds reqfac ;   PUTMSG request
r_GETMSG ds reqfac ;   GETMSG request
r_GETID ds reqfac ;   GETID request
r_BOOT ds reqfac ;   BOOT request
r_BCAST ds reqfac ;   BCAST request
r_BPOKE ds reqfac ;   Broadcast POKE request
r_PKINC ds reqfac ;   PEEK & INCrement request
r_PKPOK ds reqfac ;   PEEKPOKE request
r_RUN ds reqfac ;   RUN request
r_BRUN ds reqfac ;   BRUN request
   ; ==========================
maxreq ds 0 ;   Max request + reqfac
 dend

 dum 1 ; Modifier codes (0 invalid):
rm_REQ ds 1 ;   Request
rm_ACK ds 1 ;   Acknowledge
rm_DACK ds 1 ;   Data Acknowledge
rm_NAK ds 1 ;   Negative Acknowledge
 dend

***************** BCAST tags *******************
*                                              *
* High byte of BCAST address field.  Tags <$D0 *
* can be confused with RAM addresses. (The low *
* byte may be an additional specification.)    *
*                                              *
************************************************

t_BASIC equ $E0 ; Applesoft BASIC program
t_SYNTH equ $F0 ; Crate SYNTH program
t_VOICE equ $F1 ; Crate SYNTH voice

************ NadaNet Page 3 Vector *************

 dum $3CC ; Fixed memory vector
bootself db 0 ; Machine ID from BOOT
warmstrt jmp 0*0 ; Warm start SERVE loop entry
nadapage equ *-1 ; NADANET load page
 dend

**************** Entry points *****************

 dum loadpnt ; NadaNet load address

entry jsr * ; BOOT entry: init and
servelp jsr * ;  Run request server
 jmp servelp ;    forever...
init jmp * ; Initialize and return
serve jmp * ; Run reqest server
peek jmp * ; Peek/Poke 'sbuf+dst' for
poke jmp * ;  'sbuf+len' bytes at 'sbuf+adr'
call jmp * ; Call 'sbuf+dst' at 'sbuf+adr'
putmsg jmp * ; Put message to server
getmsg jmp * ; Get message from server
bcast jmp * ; Broadcast data
bpoke jmp * ; Broadcast 2-byte POKE
peekinc jmp * ; PEEK & INC 2-byte val
peekpoke jmp * ; PEEKPOKE 2-byte val
run jmp * ; RUN Applseoft prog
brun jmp * ; BRUN M/L prog
rcvctl jmp * ; Receive control pkt
rcvptr jmp * ; Receive to 'ptr'
rarl=>al jmp * ; Rbuf adr,len=>address,length
rcvlong jmp * ; Receive long data
 pag
********** Parameters and variables ************

self db 0 ; Our own machine ID
sbuf ds lenctl ; Control pkt send buffer
rbuf ds lenctl ; Control pkt receive buffer
locaddr dw 0 ; Local address of req data
retrylim db 0 ; Limit of REQUEST resends
servecnt db 0 ; SERVE iterations (0=256)

parmsiz equ *-self ; Size of parameter area

************ Counters and Version **************

arbxv db 0 ; Arbitrate X iters (modified)
tolim db 0 ; RCVPKT timeout limit
reqctr db 8 ; SERVER request counter
reqretry db 0 ; xxxREQ retries remaining
retrycnt db 0 ; REQUEST resend count
errprot dw 0 ; Protocol error count
ckerr dw 0 ; Checksum error count
frmcerr dw 0 ; 'frmc' collision errors
nadaver db version ; NadaNet version

* Table of allocated machine IDs (allocated = non-zero)
*        (Only present in "master" machines)

maxid equ 31 ; Maximum number of machines

idtable db maxid ; Table of machine attributes
 ds maxid ; Rest of ID table (=0)

 dend
