****************** Second-stage Boot *********************

*--------------------------------------------------------*
*         Requester                  Master (ID=1)       *
*  ========================     =======================  *
*  GETID  REQ              ====>                         *
*                          <==== GETID  ACK (ID)         *
*  GETID  DACK  ($A5)      ====>                         *
*--------------------------------------------------------*
         pag
**********************************************************
*                                                        *
*                       B O O T 2                        *
*                                                        *
*            Michael J. Mahon - May 13, 2004             *
*                 Adapted Apr 15, 2008                   *
*                 Revised Jan 24, 2009                   *
*                                                        *
*            Copyright (c) 2004, 2008, 2009              *
*                                                        *
*  Second boot stage for AppleCrate machines.            *
*                                                        *
*  The second boot stage gets control immediately after  *
*  the boot image has been loaded by the ROM boot code.  *
*                                                        *
*  The second stage performs the following steps:        *
*     1. Set "Inhibit GETID Out" to postpone GETID of    *
*        physically next board in AppleCrate.            *
*     2. Read Paddle 3 and use it to form a unique       *
*        "pseudo-ID" to minimize arbitration collisions. *
*     3. Wait for "Inhibit GETID in" to go low.          *
*     4. Send a GETID request to the booting machine to  *
*        request a unique machine ID.  Then receive ACK  *
*        containing assigned machine ID.                 *
*     5. If any error, "beep" 100ms and retry step 3.    *
*     6. Respond to master with DACK using new ID.       *
*     7. Clear "Inhibit GETID Out" to enable GETID of    *
*        physically next board.                          *
*     8. Coldstart BASIC and set HIMEM to NadaNet base.  *
*     9. Set KSW to re-enter 'servelp' on input req.     *
*    10. Set warm start address (and PWREDUP byte) for   *
*        entry to NadaNet, so second-stage boot page     *
*        is free after boot.                             *
*    11. Jump to NadaNet entry address.                  *
*                                                        *
**********************************************************

ep       jmp   BOOT2      ; Load page for boot loader

BOOT2    sta   an2+1      ; Set Inhibit GETID out
         lda   #3         ; Set GETID 'request'
         sta   retrylim   ;  retrys to 3.
         lda   rbuf+frm-self+$280 ; Use ID of BOOTing
         sta   sbuf+dst   ;  machine for GETID.
         ldx   #3         ; Set to read Paddle 3
         jsr   PREAD      ; Read Paddle 3 (to Y)
         tya              ; Create pseudo-ID
         ora   #$80       ; (pseudo is >127)
         jsr   setid
         jmp   :inhibit   ; No initial beep/delay.

:retry   jsr   BELL       ; Delay 100ms & blink LED.
:inhibit lda   pb2        ; Test Inhibit GETID in
         bmi   :inhibit   ;  and wait until low.
         lda   #reqto     ; Set RCVPKT timeout
         sta   tolim      ;  to min arb time.
         lda   #r_GETID   ; Perform a GETID
         jsr   REQUEST    ;  request.
         bcs   :retry     ; GETID failed.
         lda   rbuf+adr   ; Save new assigned ID
         sta   bootself   ;  in 'bootself',
         jsr   setid      ;   etc.
         lda   #rm_DACK   ; Send DACK.
         jsr   SENDRSP
         sta   an2+0      ; Clear Inhibit GETID out.
         lda   #maxretry  ; Reset 'request'
         sta   retrylim   ;  retrys to default.
         mov16 #:resume   ;KSW ; Set KSW to keep control
         jmp   COLDSTRT   ; Coldstart Applesoft.
:resume  lda   #>entry    ; Set HIMEM
         sta   HIMEM+1    ;  and FRETOP to
         sta   FRETOP+1   ;   base of NadaNet.
         lda   #0         ; Clear the
         sta   ONERR      ;  ONERR flag.
         mov16 #warmstrt  ;KSW ; KSW goes to servelp.
         lda   #<entry    ; Set SOFTEV vector to
         sta   SOFTEV     ;  point to NadaNet entry.
         lda   #>entry
         sta   SOFTEV+1
         eor   #$A5       ; Compute power-up byte
         sta   PWREDUP    ;  and save it for RESET.
         jmp   (SOFTEV)   ; Give NadaNet control...

]end     align 256
xboot    equ   *-]end     ; Slack space after boot2.
         pag
