************ Enhanced Boot code definitions **************

* Boot data and definitions

idmsg    asc   "AppleCrate //e, v3.x"  ; Boot msg
idlen    equ   *-idmsg    ; Length of message
         asc   ": Awaiting boot."
wtlen    equ   *-idmsg    ; Length of full msg.
         pag
**********************************************************
*                                                        *
*                       R E S E T                        *
*                                                        *
*            Michael J. Mahon - Oct 20, 2004             *
*                 Revised Apr 30, 2010                   *
*                                                        *
*               Copyright (c) 2004, 2010                 *
*                                                        *
*  Upon power-up or hardware reset, this routine looks   *
*  at the network state.  If it is ZERO, it initiates    *
*  the boot sequence.  If it is ONE, it looks at the     *
*  $3F2 reset vector and decides whether to reboot or    *
*  warm restart.                                         *
*                                                        *
*  This normally forces a reboot, but, if the network is *
*  held at ONE (locked), Crate machines may be reset to  *
*  force a warm restart.                                 *
*                                                        *
**********************************************************

RESET    lda   drecv      ; Sample network state
         bpl   BOOT       ;  & force boot if ZERO.
         lda   SOFTEV+1   ; Is the PWREDUP byte
         eor   #$A5       ;  correct for a warm
         cmp   PWREDUP    ;   restart?
         bne   BOOT       ; -No, boot required.
         jmp   (SOFTEV)   ; -Yes, give code control.
         pag
**********************************************************
*                                                        *
*                        B O O T                         *
*                                                        *
*            Michael J. Mahon - May 13, 2004             *
*                 Revised Apr 30, 2010                   *
*                                                        *
*            Copyright (c) 2004, 2008, 2010              *
*                                                        *
*  Boot a diskless machine from the network.             *
*                                                        *
*  This version of BOOT is passive, to allow it to be    *
*  shorter than $200.  This allows it to fit in the ROM  *
*  of an Enhanced //e ROM, replacing the self-test code  *
*  from $C600..C7FF.                                     *
*                                                        *
*  BOOT does the following steps:                        *
*     1. Clear screen and display "Awaiting boot".       *
*     2. Go into a RCVCTL loop waiting for the broadcast *
*        BOOT request that contains the load address     *
*        ($0400..$BFFF) and length of the boot code.     *
*     3. Receive the boot code into memory.              *
*     4. If any error, retry starting at step 1.         *
*     5. Clear screen and display ID message.            *
*     6. Jump to start of second-stage boot.             *
*                                                        *
**********************************************************

BOOT     jsr   HOME       ; Clear the display
         ldx   #40-wtlen/2-1 ; and print enough
         jsr   PRBL2      ;     blanks to center
         ldy   #0         ;      the "Awaiting boot"
:msglp   lda   idmsg,y    ;       message.
         jsr   COUT
         iny
         cpy   #wtlen
         bcc   :msglp
:restart ldx   #servegap  ; Delay min arb time.
         cmp   zipslow    ; Zip Chip to 1MHz mode.
         ldy   drecv      ; Sample net state.
:waitidl tya
         eor   drecv      ; Has net changed?
         bmi   :restart   ; -Yes, restart timing.
         dex              ; -No, count down.
         bne   :waitidl
         lda   #idleto    ; Set RCVPKT timeout
         sta   tolim      ;  to 20ms.
:again   lda   ptrig      ; Flash "Send" LED while
         jsr   RCVCTL     ;  waiting for a BOOT req.
         bcc   :ok        ; -good pkt.
         beq   :again     ; -timed out, go again.
         bne   :restart   ; -bad cksum, start over.

:ok      lda   rbuf+dst   ; Broadcast?
         bne   :restart   ; -No, start over.
         lda   rbuf+frmc  ; Verify that
         eor   #$FF       ;  complement of 'frmc'
         cmp   rbuf+frm   ;   is equal to 'frm'.
         bne   :restart   ; -No, start over.
         lda   rbuf+rqmd
         cmp   #r_BOOT+rm_REQ ; BOOT request?
         bne   :restart   ; -No, start over.
         lda   #reqto     ; Set RCVPKT timeout
         sta   tolim      ;  short again.
         jsr   rarl=>al   ; Set address/length.
         lda   rbuf+adr+1 ; Look at adr hi byte
         cmp   #$04       ; Load addr < $0400
         bcc   :restart   ;  not permitted.
         cmp   #$C0       ; Load addr >= $C000
         bcs   :restart   ;  not permitted.
         jsr   RCVLONG    ; Read the boot code.
         bcs   :restart   ; -error, start over.
         jsr   HOME       ; Clear the display
         ldx   #40-idlen/2-1 ; and print enough
         jsr   PRBL2      ;     blanks to center
         ldy   #0         ;      the banner.
:msgloop lda   idmsg,y
         jsr   COUT
         iny
         cpy   #idlen
         bcc   :msgloop
         lda   #0         ; Set bootself to 0 to run
         sta   bootself   ;  second-stage boot code.
         jmp   (rbuf+adr) ; Give boot code control...
         pag
