**********************************************************
*                                                        *
*                A T T A C H . S L A V E                 *
*                                                        *
*            Michael J. Mahon - Sep 29, 2004             *
*                 Revised Apr 30, 2010                   *
*                                                        *
*      Copyright (c) 2004, 2007, 2008, 2009, 2010        *
*                                                        *
*   ATTACH.SLAVE is the slave server for ATTACH, which   *
*   allows another machine on the network to control the *
*   slave machine by substituting for its keyboard and   *
*   display.                                             *
*                                                        *
*   The install code uses the current 'CSW' address for  *
*   local echo if DOS or ProDOS is active, then sets up  *
*   the character input and output vectors redirecting   *
*   all output to a circular buffer in the master machine*
*   and taking all input from a local circular buffer.   *
*                                                        *
**********************************************************
*                                                        *
*                    Change History                      *
*                                                        *
*   04/30/10:                                            *
*                                                        *
*   Acquire lock on CB using new PEEKPOKE instead of     *
*   PEEKINC, since "set to 1" is more reliable.          *
*                                                        *
*   01/29/09:                                            *
*                                                        *
*   Fixed deadlock w/ master when the slave sends while  *
*   the master is sending an input line, set "timeout"   *
*   to 1 (only 1 x 3 retries, or about 60ms.) and added  *
*   40 ms. "serve" calls to slave release retries.       *
*                                                        *
*   Added mechanism to allow ATTACH to detect when slave *
*   is already attached by another machine.  The first   *
*   two bytes of ATTACH.SLAVE are a "signature" of being *
*   attached, clobbered by DETACH, and the third byte is *
*   the ID of the attaching machine.                     *
*                                                        *
*   01/03/09:                                            *
*                                                        *
*   Modified initialization to check for ProDOS and DOS, *
*   then handle other cases (CRATE, MSERVE) as "bare".   *
*                                                        *
*   12/19/08:                                            *
*                                                        *
*   Removed output "prefix" code, since ATTACH can only  *
*   be attached to one machine at a time.                *
*                                                        *
*   12/10/08:                                            *
*                                                        *
*   Suppressed echo of CR (just like all other chars).   *
*   Deleted ctl-Z detach mechanism from Keyin.           *
*                                                        *
*   12/06/08:                                            *
*                                                        *
*   Added DETACH entry point.  Changed output prefix to  *
*   3 characters: <2-dig decimal ID> + ":".              *
*                                                        *
*   11/25/08:                                            *
*                                                        *
*   Added code to save CSW/KSW when ATTACHing and to     *
*   restore them when DETACHing, to keep any active      *
*   OS connected after the machine is DETACHed.          *
*                                                        *
*   Moved 'ATTACH' to end so that it is overwritten by   *
*   outbuf and inbuf.  Special-cased one reloc in ATTACH.*
*                                                        *
*   07/11/07:                                            *
*                                                        *
*   Re-wrote communication routines to use circular      *
*   buffers for passing messages directly instead of     *
*   using a Message Server.                              *
*                                                        *
*   Expanded simple relocator to handle up to 512 byte   *
*   range of code to be relocated.                       *
*                                                        *
*   12/14/04:                                            *
*                                                        *
*   Added ctl-Z command to "detach" by restoring saved   *
*   I/O hooks, then giving control back to 'warmstrt'.   *
*                                                        *
*   Changed install routine (ATTACH) to be OS-specific   *
*   and to save the current I/O hooks, and then install  *
*   new output and input hooks to keep OS connected.     *
*                                                        *
*   11/13/04:                                            *
*                                                        *
*   Changed load address to $6000.                       *
*                                                        *
*   Now gets input and output queue numbers from param   *
*   area just after entry JMP.  Allows ATTACH to set up  *
*   queues.                                              *
*                                                        *
*   11/08/04:                                            *
*                                                        *
*   Removed suppression of CR echo to fix output bug.    *
*                                                        *
*   Moved initialization of 'sbuf+dst' and 'sbuf+len+1'  *
*   from ATTACH to just prior to PUTMSG call, so that    *
*   ATTACH.SLAVE can be used to perform network requests *
*   (which change the contents of 'sbuf').               *
*                                                        *
*   11/05/04:                                            *
*                                                        *
*   Added jump to 'start' so that the program load page  *
*   is easily available in the program's third byte.     *
*                                                        *
*   10/20/04:                                            *
*                                                        *
*   Removed call to HOME since screen initialization is  *
*   now done in Boot ROM.                                *
*                                                        *
*   10/18/04:                                            *
*                                                        *
*   Added fix-up code to allow NADANET code to be loaded *
*   anywhere.  Code will get actual load page from $3CF  *
*   and patch up to 256 bytes of code by using a unique  *
*   fake NADANET page number as a fix-up indicator.      *
*                                                        *
*   10/16/04:                                            *
*                                                        *
*   Fixed ID prefixing.                                  *
*                                                        *
*   Added 25ms delay in GETMSG and PUTMSG retry loop to  *
*   reduce net busy time and allow SERVER to timeout     *
*   each iteration (to improve approximate timekeeping). *
*                                                        *
*   Changed to new NADAUSER definitions include file.    *
*                                                        *
*   10/06/04:                                            *
*                                                        *
*   Changed chout and flush to prefix machine ID only    *
*   when CR caused flush.                                *
*                                                        *
*   10/02/04:                                            *
*                                                        *
*   Numerous changes and bug fixes.                      *
*                                                        *
*   09/29/04:                                            *
*                                                        *
*   Initial version.                                     *
*                                                        *
**********************************************************
         pag
         tr    on         ; Only one line of data per op

* Apple ][ definitions

keybd    equ   $C000      ; Keyboard port
VBL      equ   $C019      ; Vertical blanking
spkr     equ   $C030      ; Speaker toggle
ptrig    equ   $C070      ; Paddle trigger

dsk6off  equ   $C0E8      ; Deselect 5.25" disk in slot 6

* Apple II ROM-related addresses

CH       equ   $24        ; Horizontal cursor position
BASL     equ   $28        ; Text line base address
CSW      equ   $36        ; Character output vector
KSW      equ   $38        ; Keyboard input vector
COUT1    equ   $FDF0      ; ROM video out routine
MONZ     equ   $FF69      ; Monitor entry point
         pag
loadpnt  equ   $7800      ; Fake NADANET load point
         put   NADAUSER
         pag
         use   NADAMACS
***** Circular Buffer Control Block Definition *****

         dum   0          ; Control Block layout:
lok      ds    2          ;   Lock word (0=unlocked)
tlx      ds    1          ;   Tail index
hdx      ds    1          ;   Head index
buf      ds    2          ;   Ptr to 256-byte buffer
                          ; ========================
CBCBlen  ds    0          ; Length of CBCB
         dend

         org   $6000
enter    jmp   relay      ; Standard entry on load page
DETACH   jmp   detach     ; DETACH entry point

* Parameter area

oucbadr  da    0*0        ; Ptr to output CBCB in master
incb     ds    CBCBlen-2  ; Local input CB control block
         da    inbuf      ; ptr to input CB data

* Definitions

buflen   equ   $76        ; Length of outbuf

address  equ   $FC        ; Page 0 scratch pointer

* DOS and ProDOS I/O vector addresses

DOShooks equ   $AA53
Prohooks equ   $BE30

* Non-Page Zero variables

mcb      ds    CBCBlen    ; Local copy of master CBCB
ctlid    equ   enter+2    ; Controlling machine's ID
savex    db    0          ; Register save temp
savey    db    0          ; Register save temp
outlen   db    0          ; Points to next outbuf char
inch     db    0          ; Previous input character
hookadr  da    0          ; Address of OS I/O hooks

origCSW  dw    0          ; CSW at ATTACH
         dw    0          ; KSW at ATTACH

prevCOUT jmp   COUT1      ; I/O hooks are saved
         da    warmstrt   ;  here if an OS is active.

hooks    da    chout      ; ATTACH hook vector
         da    keyin

relay    jmp   start      ; (entry vector on load page)
         pag
**********************************************************
*                                                        *
*                       C H O U T                        *
*                                                        *
*            Michael J. Mahon - Sep 29, 2004             *
*                  Revised Apr 30, 2010                  *
*                                                        *
*          Copyright (c) 2004, 2007, 2009, 2010          *
*                                                        *
*   CHOUT adds output characters to outbuf, suppressing  *
*   local input echo, and flushes the buffer to the      *
*   controlling machine whenever a CR is received or the *
*   buffer is filled.                                    *
*                                                        *
**********************************************************

chout    pha              ; Save output char.
         jsr   prevCOUT   ; Send to local video display
         cmp   inch       ; Is this an input echo?
         bne   :out       ; -No, process it.
         lda   #0         ; -Yes, clear the
         sta   inch       ;   input character
         pla              ;    restore A
         rts              ;     and return.

:out     sty   savey      ; Save Y
         stx   savex      ;  and X.
         ldy   #0         ; Clear input
         sty   inch       ;  character.
         ldy   outlen     ; Add char
         sta   outbuf,y   ;  to output buffer
         iny              ;   and bump pointer.
         cmp   #$8D       ; Carriage Return?
         beq   :cr        ; -Yes, flush.
         cpy   #buflen    ; -No. outbuf full?
         bcc   :exit      ; -No, exit.
:cr      jsr   flush      ; -Yes, flush it.
:exit    sty   outlen     ; Update outlen
         ldy   savey      ; Restore Y
         ldx   savex      ;  and X
         pla              ;   and A
         rts              ; Return.


flush    sty   outlen     ; Save output length
         ldy   #1         ; Set timeout to 1
         sty   retrylim   ;  cycle of 3 retries.
:puttoCB mov16 oucbadr    ;sbuf+adr ; Lock output CB
         mov16 #1         ;sbuf+len ; in controlling machine.
         lda   ctlid
         sta   sbuf+dst
         jsr   peekpoke
         bcs   :serve     ; Serve on failure.
         lda   rbuf+len   ; Did we get
         ora   rbuf+len+1 ;  the lock?
         beq   :locked    ; -Yes!
:serve   lda   #2         ; -No, serve a request.
         sta   servecnt
         jsr   serve
         jmp   :puttoCB   ;   and try again.

:locked  mov16 #CBCBlen-tlx ;sbuf+len ; Get CB ctl block
         clc
         lda   oucbadr    ; sbuf+adr = oucbadr+tlx
         adc   #tlx
         sta   sbuf+adr
         lda   oucbadr+1
         adc   #0
         sta   sbuf+adr+1
         mov16 #mcb+tlx   ;locaddr
         jsr   peek
         bcs   :unlock    ; Unlock & retry on failure.
         clc              ; Compute space avail
         lda   mcb+hdx    ;  = hdx - tlx - 1
         sbc   mcb+tlx
         cmp   outlen     ; Will data fit?
         bcs   :fits      ; -Yes.
:unlock  mov16 #2         ;sbuf+len ;-No, release lock.
         mov16 oucbadr    ;sbuf+adr
         mov16 #mcb       ;locaddr
         lda   ctlid
         sta   sbuf+dst
         jsr   poke       ; Release MCB lock,
         bcc   :serve     ;  serve, and try again.
         lda   #2         ; On failure, serve
         sta   servecnt   ;  for 40 ms. and
         jsr   serve
         jmp   :unlock    ;   try to unlock again.

:fits    clc              ; Set sbuf+adr
         lda   mcb+buf    ;  = (mcb+buf) + tlx
         adc   mcb+tlx
         sta   sbuf+adr
         lda   mcb+buf+1
         adc   #0
         sta   sbuf+adr+1
         mov16 #outbuf    ;locaddr
         sec              ; Compute length to end
         lda   #0         ;  of MCB = 256 - tlx
         sbc   mcb+tlx
         cmp   outlen     ; Does string wrap buffer?
         bcc   :wrap      ; -Yes, save 1st chunk length
         lda   outlen     ; -No, send in one chunk.
:wrap    sta   sbuf+len   ; Length of 1st chunk (L1)
         jsr   poke       ; POKE first part
         clc
         lda   locaddr
         adc   sbuf+len   ; Advance locaddr by L1
         sta   locaddr
         lda   locaddr+1
         adc   #0
         sta   locaddr+1
         sec
         lda   outlen
         sbc   sbuf+len   ; outlen > L1?
         beq   :done      ; -No, we're done.
         sta   sbuf+len   ; -Yes, set 2nd chunk length
         mov16 mcb+buf    ;sbuf+adr
         jsr   poke       ; POKE wrapped chunk.
:done    clc
         lda   outlen     ; Update tlx
         adc   mcb+tlx    ;  = tlx + total length
         sta   mcb+tlx
:rerel   mov16 #tlx+1     ;sbuf+len ; Length of (lock + tlx)
         mov16 oucbadr    ;sbuf+adr
         mov16 #mcb       ;locaddr
         lda   ctlid
         sta   sbuf+dst
         jsr   poke       ; Release lock & update tlx.
         bcc   :exit      ; -OK
         lda   #2         ; -NG, serve
         sta   servecnt   ;   for 40 ms.
         jsr   serve      ;    and
         jmp   :rerel     ;     try release again.

:exit    ldy   #0         ; Set outbuf empty.
         sty   outlen
         rts
         pag
**********************************************************
*                                                        *
*                       K E Y I N                        *
*                                                        *
*            Michael J. Mahon - Sep 29, 2004             *
*                  Revised Dec 10, 2008                  *
*                                                        *
*             Copyright (c) 2004, 2007, 2008             *
*                                                        *
*   KEYIN first checks the output buffer.  If it is not  *
*   empty, it flushes it (and any prompt).  It then looks*
*   in the input buffer for an imput character.  If the  *
*   input circular buffer is empty, it serves until more *
*   input is received.                                   *
*                                                        *
**********************************************************

keyin    ldy   CH         ; Horizontal cursor
         sta   (BASL),y   ; Restore char at cursor postion
         stx   savex      ; Save X
         ldy   outlen     ; Is outbuf empty?
         beq   :getchr    ; -Yes, do input.
         jsr   flush      ; -No, flush it.
:getchr  lda   incb+lok   ; Is input CB
         ora   incb+lok+1 ;  locked?
         beq   :ok        ; -No, check for input.
:wait    jsr   serve      ; -Yes, serve a request
         jmp   :getchr    ;  and try again.

:ok      ldy   incb+hdx   ; Index to head of CB
         cpy   incb+tlx   ; CB empty?
         beq   :wait      ; -Yes, wait for input.
         inc   incb+hdx   ; -No, inc head index
         lda   inbuf,y    ;   and get next character.
         sta   inch       ; Save for echo suppression
         ldx   savex      ; Restore X
         rts              ;  and return with char in A.
         pag
**********************************************************
*                                                        *
*                      D E T A C H                       *
*                                                        *
*            Michael J. Mahon - Sep 29, 2004             *
*                  Revised Jan 29, 2009                  *
*                                                        *
*          Copyright (c) 2004, 2007, 2008, 2009          *
*                                                        *
*   Detach from this machine by restoring the OS hooks   *
*   (if any) and the original CSW/KSW hooks, then re-    *
*   enter serverlp, restoring the original state of the  *
*   machine.                                             *
*                                                        *
**********************************************************

detach   mov16 hookadr    ;address ; Point at hooks
         ldy   #3
:restore lda   prevCOUT+1,y ; Restore previous
         sta   (address),y  ;  I/O hooks and
         lda   origCSW,y  ;     original CSW/KSW
         sta   CSW,y      ;      vectors.
         dey
         bpl   :restore
         sty   enter      ; Clobber "attached" signature.
         sty   servecnt   ; Set servecnt back to max.
         ldy   #50        ; Set "timeout" back
         sty   retrylim   ;  to default.
         jmp   warmstrt   ; and re-enter 'servelp'.
         pag
* Output and input buffers

outbuf   equ   *          ; Output buffer
inbuf    equ   *+buflen   ; 256-byte circular buffer

**********************************************************
*                                                        *
*   Code to fix up references to NadaNet param area and  *
*   ATTACH hooks for remote operation of the machine.    *
*                                                        *
*   (Following code is overwritten by outbuf and inbuf.) *
*                                                        *
**********************************************************

]iter    equ   outbuf-flush/2 ; # of iters needed
         err   ]iter/256  ; Reloc limited to 2 pages.

start    ldy   #]iter     ; Fix up references to
         ldx   nadapage   ;  fake NADANET load page
         stx   reloc+2    ; Special ATTACH fix-up
:loop    lda   flush,y    ; Get byte in first half
         cmp   #>loadpnt  ; Fake page?
         bne   :sk1       ; -No, skip this one.
         txa              ; -Yes, patch it with
         sta   flush,y    ;   the real page #.
:sk1     lda   flush+]iter,y ; (same for second half)
         cmp   #>loadpnt  ; Fake page?
         bne   :skip      ; -No, skip this one.
         txa              ; -Yes, patch it with
         sta   flush+]iter,y ; the real page #.
:skip    dey
         bne   :loop      ; (fall into ATTACH)
         pag
**********************************************************
*                                                        *
*                      A T T A C H                       *
*                                                        *
*            Michael J. Mahon - Sep 29, 2004             *
*                  Revised Dec 19, 2008                  *
*                                                        *
*                Copyright (c) 2004, 2008                *
*                                                        *
*   ATTACH saves the CSW/KSW vectors for restoration by  *
*   'detach', then saves the character output routine if *
*   a disk OS is active and 'chout' is not _already_     *
*   installed, then sets the output and input hooks so   *
*   that the OS is still connected.                      *
*                                                        *
*   It then enters the ROM Monitor under remote control. *
*                                                        *
**********************************************************

ATTACH   mov16 #CSW       ;address ; Default hook address
         ldx   nadapage   ; What environment?
         cpx   #$91       ; ProDOS machine?
         bne   :ckdos     ; -No, check if DOS.
         mov16 #Prohooks  ;address ; -Yes, ProDOS hooks.
         bne   :ckhook    ; (always)

:ckdos   cpx   #$8D       ; DOS machine?
         bne   :ckhook    ; -No, use default hooks.
         mov16 #DOShooks  ;address ; -Yes, DOS hooks.
:ckhook  ldy   #1
         lda   (address),y ; If active 'CSW'
         cmp   #>chout    ;   is already us,
         beq   :sethook   ;    then just set hookadr.
         ldy   #3         ; Else save it as the
:save    lda   (address),y ; 'local echo' routine
         sta   prevCOUT+1,y ;  along with 'KSW' addr.
         dey
         bpl   :save
         ldy   #3         ; Set hooks for ATTACH, and
:saveset lda   CSW,y      ;  save original CSW/KSW
         sta   origCSW,y  ;   vectors for detach.
         lda   hooks,y
         sta   (address),y
         dey
         bpl   :saveset
:sethook mov16 address    ;hookadr ; Save addr of hooks
reloc    lda   rbuf+frm   ; Get controlling machine's
         sta   ctlid      ;  ID and save it.
         jmp   MONZ       ; Enter the Monitor.
