         pag
**********************************************************
*                                                        *
*                  A M P E R N A D A                     *
*                                                        *
*           Michael J. Mahon - Oct 25, 2004              *
*                 Revised May 3, 2010                    *
*                                                        *
*           Copyright (c) 2004, 2008, 2010               *
*                                                        *
*  Implements an ampersand (&) interface to NadaNet for  *
*  Applesoft programs.  Reduces the need for PEEKs and   *
*  POKEs to set up parameters, saving time and interface *
*  definitions.                                          *
*                                                        *
*  If an error occurs in a command execution routine,    *
*  (signaled by Carry set upon return) the handler will, *
*  by default, throw a "DATA" (49) error, which will halt*
*  the program unless caught by an active ONERR.         *
*                                                        *
*  If an ampersand command is followed by a "#", then no *
*  execution error will be thrown, and the programmer    *
*  is responsible for checking status by PEEKing 1 and 0.*
*                                                        *
**********************************************************

**************** Applesoft Definitions *******************

TXTPTR   equ   $B8        ; Current scan point
VALTYP   equ   $11        ; $FF if var is STRING$
INTFLG   equ   $12        ; $80 if var is INT%
FORPNT   equ   $85        ; Ptr to var
FAC      equ   $9D        ; Floating point accum

AMPVECT  equ   $3F5       ; JMP to ampersand handler

CHRGET   equ   $00B1      ; Get next text char
CHRGOT   equ   $00B7      ; Get last text char
ERROR    equ   $D412      ; Applesoft error handler
SYNERR   equ   $DEC9      ; Syntax Error
ADDON    equ   $D998      ; Advance TXTPTR by Y
SYNCHR   equ   $DEC0      ; Current char must = A
FRMNUM   equ   $DD67      ; Eval expr to FAC
PTRGET   equ   $DFE3      ; Get var, ptr in (Y,A)
GETBYT   equ   $E6F8      ; Eval expr to X
GETADR   equ   $E752      ; Eval expr to (Y,A)
FLO2     equ   $EBA0      ; Normalize FAC (C set)
SETFOR   equ   $EB27      ; Pack FAC to (FORPNT)

********************** Variables *************************

cmdptr   equ   $EC        ; Cmd table cursor
cmdsave  equ   $ED        ; Current parm descriptor
disp     equ   $EF        ; Displacement to parm value

instald  db    0          ; Installed flag
nparms   db    0          ; # of parms seen
errstop  db    0          ; "Throw error" flag
varcmd   db    0          ; var parm descriptor
vartype  db    0          ; variable type
varadr   da    0          ; variable address
         pag
**************** Ampersand Command Table *****************

* Applesoft Token Definitions

CALL_t   equ   140
RUN_t    equ   172
POKE_t   equ   185
GET_t    equ   190
PEEK_t   equ   226

* Syntax string definitions

@        equ   self-1     ; NadaNet parameter origin
byte     equ   $00        ; Byte
word     equ   $40        ; Word
var      equ   $80        ; Numeric variable

         err   parmsiz/63 ; Parm area < 64 bytes

iter     equ   servecnt-@.byte ; SERVER iteration count
dest     equ   sbuf+dst-@.byte ; Destination machine
addr     equ   sbuf+adr-@.word ; Address at destination
lngth    equ   sbuf+len-@.word ; Length
locadr   equ   locaddr-@.word  ; Local address
AX       equ   sbuf+len-@.word ; A,X regs for CALL
class    equ   sbuf+adr-@.word ; Class of message
incr     equ   sbuf+len-@.word ; Increment for PEEK INC
val      equ   sbuf+len-@.word ; Value for BPOKE, PEEKPOKE
n60ms    equ   retrylim-@.byte ; Request resend limit
lngth?   equ   rbuf+len-@.word.var ; Length (var)
val?     equ   rbuf+len-@.word.var ; Value (var)

* In command table, longer commands must precede shorter
* commands with a common prefix.

cmdtable asc   'SERVE',00                  ; &SERVE
         db    iter,0
         da    SERVER

         asc   'PUTMSG',00                 ; &PUTMSG
         db    dest,class,lngth,locadr,0
         da    PUTMREQ

         db    GET_t,'M','S','G',0        ; &GETMSG
         db    dest,class,lngth?,locadr,0
         da    GETMREQ

         db    PEEK_t,'I','N','C',0       ; &PEEKINC
         db    dest,addr,incr,val?,0
         da    PKINCREQ

         db    PEEK_t,POKE_t,0            ; &PEEKPOKE
         db    dest,addr,val,val?,0
         da    PKPOKREQ

         db    PEEK_t,0                   ; &PEEK
         db    dest,addr,lngth,locadr,0
         da    PEEKREQ

         db    POKE_t,0                   ; &POKE
         db    dest,addr,lngth,locadr,0
         da    POKEREQ

         db    RUN_t,0                    ; &RUN
         db    dest,addr,lngth,locadr,0
         da    RUNREQ

         db    'B',RUN_t,0                 ; &BRUN
         db    dest,addr,lngth,locadr,0
         da    BRUNREQ

         db    CALL_t,0                   ; &CALL
         db    dest,addr,AX,0
         da    CALLREQ

         asc   'BOOT',00                   ; &BOOT
         db    addr,lngth,locadr,0
         da    BOOTREQ

         asc   'BCAST',00                  ; &BCAST
         db    addr,lngth,locadr,0
         da    BCASTREQ

         db    'B',POKE_t,0                ; &BPOKE
         db    addr,val,0
         da    BPOKEREQ

         asc   'INIT',00                   ; &INIT
         db    0
         da    INIT

         asc   'TIMEOUT',00                ; &TIMEOUT
         db    n60ms,0
         da    timeout

         asc   'IDTBL',00                  ; &IDTBL
         db    val?,0
         da    idtbl

         db    0          ; End of Command Table
         pag
**********************************************************
*                                                        *
*                    I N S T A L L                       *
*                                                        *
*           Michael J. Mahon - Oct 25, 2004              *
*                Revised Aug 16, 2008                    *
*                                                        *
*              Copyright (c) 2004, 2008                  *
*                                                        *
*  Installs AmperNada as first ampersand routine (if not *
*  installed already) and chains to an existing routine. *
*  if no routine is currently installed, it defaults to  *
*  "SYNTAX ERROR".                                       *
*                                                        *
**********************************************************

INSTALL  lda   instald    ; AmperNada installed?
         bne   :exit      ; -Yes, don't repeat.
         lda   #$4C       ; -No, set flag and install.
         sta   instald
         cmp   AMPVECT    ; Is "&" vector a JMP?
         sta   AMPVECT    ; (always set "jmp")
         bne   :setvect   ; -No, just set vector.
:chain   mov16 AMPVECT+1  ;chain+1 ; -Yes, chain to it.
:setvect mov16 #AMPNADA   ;AMPVECT+1 ; set the vector.
:exit    jmp   INIT       ; Initialize NadaNet.
         pag
**********************************************************
*                                                        *
*                  A M P E R N A D A                     *
*                                                        *
*           Michael J. Mahon - Oct 25, 2004              *
*                Revised Nov 08, 2004                    *
*                                                        *
*                 Copyright (c) 2004                     *
*                                                        *
*  Implements an ampersand (&) interface to NadaNet for  *
*  Applesoft programs.  Reduces the need for PEEKs and   *
*  POKEs to set up parameters, saving time and interface *
*  definitions.                                          *
*                                                        *
**********************************************************

AMPNADA  php              ; Save status
         pha              ;  and A for chain.
         ldx   #0
         stx   nparms     ; # of parms supplied
         stx   varcmd     ; Signal no var params seen
         stx   errstop    ; Clear "throw err" flag.
cmd      ldy   #0         ; Start compare at TXTPTR
         lda   cmdtable,x ; Get command char
         bne   comp       ; -Not end, compare.
         pla              ; -End.  Restore A
         plp              ;   and status and chain
chain    jmp   SYNERR     ;    to next & handler.

comp     cmp   (TXTPTR),y ; Does cmd match text?
         bne   :skipcmd   ; -No, skip this one.
         iny              ; -Yes, advance.
         inx
         lda   cmdtable,x ; End of command?
         bne   comp       ; -No, keep comparing.
         beq   :doit      ; -Yes, go do it.

:skipcmd inx              ; Skip to end of
         lda   cmdtable,x ;  current cmd string
         bne   :skipcmd
:skipp   inx              ; Skip to end of
         lda   cmdtable,x ;  current parm vect
         bne   :skipp
         inx              ; Pass end mark
         inx              ;  and action
         inx              ;   routine address.
         bne   cmd        ; Go check next command.

:doit    pla              ; Discard entry A
         pla              ;  and status.
         lda   (TXTPTR),y ; Look at next character.
         iny              ; (provisional match)
         cmp   #'#'       ; Is it "#"?
         beq   :advance   ; -Yes, don't throw error.
         dey              ; -No, don't match, and
         inc   errstop    ;   set throw err flag.
:advance jsr   ADDON      ; Advance TXTPTR past cmd
         lda   #'('       ; Require initial "("
:nxparm  jsr   SYNCHR     ; Syntax err if no match.
         beq   :synerr    ; End not expected.
         stx   cmdptr     ; Save for :done case
         cmp   #')'       ; Found a ")"?
         beq   :done      ; -Yes, end of parm list.
         inc   nparms     ; -No, another parm.
         inx              ; Advance ptr and
         lda   cmdtable,x ;  get parm descriptor.
         beq   :synerr    ; Too many parms.
         sta   cmdsave    ; Save descriptor
         and   #$3F       ; Mask displacement
         sta   disp       ;  and save it.
         stx   cmdptr     ; Save pointer.
         bit   cmdsave    ; Test parm type.
         bmi   :var       ; -Var parm
         bvc   :byte      ; -Byte value parm
         jsr   FRMNUM     ; -Word value parm
         jsr   GETADR     ; Word val to Y,A
         ldx   disp
         sta   @+1,x      ; Store the value
         tya
         sta   @,x
         jmp   :more?

:byte    jsr   GETBYT     ; Byte value to X
         ldy   disp
         txa
         sta   @,y        ; Store the value
         jmp   :more?

:var     lda   cmdsave    ; Save the parm
         sta   varcmd     ;  descriptor.
         jsr   PTRGET     ; Get var ptr in (A,Y)
         sta   varadr     ;  and save var
         sty   varadr+1   ;   address.
         lda   VALTYP     ; $FF if string
         bne   :synerr    ; String not allowed.
         lda   INTFLG     ; $80 if INT%
         sta   vartype    ; Save for later use
:more?   jsr   CHRGOT     ; Check current test char.
         beq   :synerr    ; End not expected.
         cmp   #')'       ; Closing ")"?
         beq   :done      ; -Yes, finish.
         ldx   cmdptr     ; -No, more parms.
         lda   #','       ; Require a comma.
         bne   :nxparm    ; (always)

:synerr  jmp   SYNERR     ; SYNTAX ERROR

:done    jsr   CHRGET     ; Pass the ")"
         ldx   cmdptr
:skipit  inx              ; Skip to end
         lda   cmdtable,x ;  of parm descriptors.
         bne   :skipit
         mov16 cmdtable+1,x ;$00 ; Action routine
         jsr   :jmp       ; Call the action routine
         sta   $00        ; Save returned A
         lda   #0
         rol              ; C to low bit
         sta   $01        ; Save returned Carry
         beq   :noerr     ; No error, continue.
         lda   errstop    ; Throw error?
         beq   :rts       ; -No, just return.
         ldx   #49        ; -Yes, throw "DATA"
         jmp   ERROR      ;   error.

:jmp     jmp   ($00)      ; To action routine.

:noerr   lda   varcmd     ; Var parm passed?
         bne   :store     ; -Yes, store into it.
:rts     rts              ; -No, return.

:store   and   #$3F       ; Mask displacement
         tay
         lda   @,y        ; Get low byte
         tax              ; X = lo byte of value
         lda   #0         ; Hi byte if byte value
         bit   varcmd     ; Is it byte or word?
         bvc   :byteval   ; -Byte, use 0 hi byte
         lda   @+1,y      ; -Word, get hi byte
:byteval tay              ; Y = hi byte of value
         mov16 varadr     ;FORPNT ; Address of variable
         lda   vartype    ; INT% or FLOAT variable?
         bpl   :float     ; -FLOAT
         tya              ; -INT%
         ldy   #0         ; Store hi byte
         sta   (FORPNT),y ;  in INT% variable.
         iny              ; Point to lo byte
         txa              ; Store lo byte
         sta   (FORPNT),y ;  in INT% variable.
         rts

:float   sty   FAC+1      ; Hi byte to FAC
         stx   FAC+2      ; Lo byte to FAC
         ldx   #$90       ; Binary point 16 bits right
         sec              ; (Don't negate FAC)
         jsr   FLO2       ; Normalize FAC
         jmp   SETFOR     ; Pack FAC into variable.
         pag
**********************************************************
*                                                        *
*                 &TIMEOUT ([n60ms])                     *
*                                                        *
*           Michael J. Mahon - Oct 28, 2004              *
*                 Revised May 3, 2010                    *
*                                                        *
*              Copyright (c) 2004, 2010                  *
*                                                        *
*  Set new request timeout value in units of 60 ms.      *
*                                                        *
*  If no value is supplied, reset timeout to default.    *
*                                                        *
**********************************************************

timeout  lda   nparms     ; Parm supplied?
         bne   null       ; -Yes, timeout set.
         lda   #maxretry  ; -No, restore
         sta   retrylim   ;   the default.
null     clc              ; No error
         rts
         pag
**********************************************************
*                                                        *
*                    &IDTBL (val?)                       *
*                                                        *
*           Michael J. Mahon - Nov 05, 2004              *
*                                                        *
*                 Copyright (c) 2004                     *
*                                                        *
*  Return address of 'idtable' in parm variable.         *
*                                                        *
**********************************************************

idtbl    mov16 #idtable   ;rbuf+len ; Put addr in rbuf
         clc
         rts
         pag
