/*****************************************************************************
 * Copyright (C) 1997-2007 YAE
 * $Id$
 *
 * Author: Doug Kwan <chun_tak@yahoo.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111, USA.
 *****************************************************************************
 * x_window.c
 * X Windows initializations
 *
 */
static char rcsid[]="$Id$";

#define	_X_WINDOW_C_

#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/keysym.h>
#include <X11/extensions/XShm.h>
#include <X11/cursorfont.h>

#include "hardware.h"
#include "x_window.h"
#include "6502.h"
#include "yae.h"

#ifdef	MOTIF
#include <X11/Intrinsic.h>
extern	Widget	DrawingArea;

#endif
#define	LEFT_APPLE_KEY	1
#define	RIGHT_APPLE_KEY	2
#define	DISK_DRIVE_KEY	3


static void X_check_and_handle_event( void *);
static BYTE Apple_Key( XEvent * );

static	BYTE	MouseButtonState[3];

static	Cursor	InvisibleCursor;

Visual *getVisual( Display *dpy, int screen, int depth, int class )
{
	XVisualInfo vinfo, *vinfoList;
	Visual *visual;
	int n;

	vinfo.screen = screen;
	vinfo.depth=depth;
	vinfo.class=class;

	vinfoList=XGetVisualInfo( dpy, 
	   VisualScreenMask|VisualDepthMask|VisualClassMask,
	   &vinfo, &n );

	if ( vinfoList ) {
	   visual = vinfoList[0].visual;
	   XFree(vinfoList);
	   return visual;
	}
	else {
	   fprintf(stderr,"Cannot match visual\n");
	   return NULL;
	}
}

DisplayContext *init_X(void)
{
	DisplayContext		*dc;
	XSetWindowAttributes	set_win_attr;
	long			win_attr_mask;
	XSizeHints		the_size_hints;
	XGCValues		the_GC_value;
	Pixmap			cursor_pixmap,cursor_mask;
	unsigned char		buf[1];
	XColor			xc;

	dc = (DisplayContext*) malloc( sizeof(DisplayContext) );
	if ( !dc ) {
	    fprintf( stderr," init_X:out of memory\n");
	    return NULL;
	}

#ifdef MOTIF
	dc->display = XtDisplay( DrawingArea );
	dc->window = XtWindow( DrawingArea );
	dc->screen = XScreenNumberOfScreen( XtScreen( DrawingArea ) );
#else
	
	dc->display = XOpenDisplay( NULL );
	if ( !dc->display ) {
	   fprintf( stderr, "Cannot open display\n" );
	   exit(1);
	}

	dc->screen = DefaultScreen( dc->display );

#endif
	dc->depth = DefaultDepth( dc->display, dc->screen );
	dc->visual = DefaultVisual( dc->display, dc->screen );

#ifndef	MOTIF
	
	win_attr_mask = 0;

	/* set windows attributes */
	set_win_attr.border_pixel = WhitePixel( dc->display, dc->screen );
	set_win_attr.background_pixel = BlackPixel( dc->display, dc->screen );
	set_win_attr.override_redirect = 0;
	win_attr_mask |= CWBorderPixel | CWBackingPixel | 
	   CWOverrideRedirect;

	/* create a colour map for visual if necessary */
	if ( dc->visual->visualid !=
	   DefaultVisual( dc->display, dc->screen )->visualid ) {
	   dc->colormap = XCreateColormap( dc->display,
	      RootWindow( dc->display, dc->screen ), dc->visual, AllocNone );
	   set_win_attr.colormap = dc->colormap;
	   win_attr_mask |= CWColormap;
	}
	else
	   dc->colormap = DefaultColormap( dc->display, dc->screen );

	dc->window = XCreateWindow( dc->display, 
	        RootWindow( dc->display, dc->screen),
		0, 0, SCREEN_WIDTH, SCREEN_HEIGHT, 
		0, dc->depth,
		InputOutput, dc->visual, win_attr_mask, &set_win_attr );

	/*
	 * Select input
	 */
	XSelectInput( dc->display, dc->window,
	   KeyPressMask | 
	   KeyReleaseMask | 
	   ExposureMask | 
	   ButtonPressMask |
	   ButtonReleaseMask |
	   StructureNotifyMask );

	/*
	 * Set size hints & Properties
	 */
	the_size_hints.width = SCREEN_WIDTH; 
	the_size_hints.height = SCREEN_HEIGHT;
	the_size_hints.max_width = SCREEN_WIDTH;
	the_size_hints.max_height = SCREEN_HEIGHT;
	the_size_hints.min_width = SCREEN_WIDTH;
	the_size_hints.min_height = SCREEN_HEIGHT;
	the_size_hints.flags = PSize | PMaxSize | PMinSize;
	XSetStandardProperties( dc->display, dc->window,
		"Apple ][", "Apple ][",
		None, 0, 0,  &the_size_hints );
#endif

	/* Create a GC for the Apple Window */
	the_GC_value.function = GXcopy;
	the_GC_value.foreground = WhitePixel( dc->display, dc->screen );
	the_GC_value.background = BlackPixel( dc->display, dc->screen );
	the_GC_value.fill_style = FillSolid;
	dc->gc = XCreateGC( dc->display, dc->window,
		GCFunction | GCForeground | GCBackground | GCFillStyle,
		&the_GC_value );

	/* initialize 16 Apple colours */
	allocAppleColours( dc->display, dc->visual, dc->colormap,
	   dc->appleColourPixel );

#if 0
	/*
	 *	Check if backing store is availalable
	 */
	dc->hasBackingStore = DoesBackingStore( ScreenOfDisplay( dc->display,
	   dc->screen ) );

	set_win_attr.backing_store = HasBackingStore;
	win_attr_mask = CWBackingStore;
	XChangeWindowAttributes( dc->display, dc->window, win_attr_mask,
	   &set_win_attr );
#endif

	/*
	 * create an invisible cursor
	 */ 
	buf[0]=0;
	cursor_pixmap=XCreateBitmapFromData( dc->display, dc->window, 
	   buf, 1,1);
	cursor_mask=XCreateBitmapFromData( dc->display, dc->window,
	   buf, 1, 1);
	xc.red=0;
	xc.green=0;
	xc.blue=0;
	InvisibleCursor=XCreatePixmapCursor( dc->display,cursor_pixmap,
	   cursor_mask,&xc,&xc,0,0);
	
#ifndef	MOTIF
	/*
	 * Map the Window so the it can be seen
	 */
	XMapWindow( dc->display, dc->window );
	XFlush( dc->display );
#endif

	/*
	 * startup micro job for X window
	 */
	submit_micro_job( AppleClock + REFRESH_INTERVAL, 
	   X_check_and_handle_event, dc );

	return dc;
error:
	free( dc );
	return NULL;
}

void quit_X( DisplayContext *dc )
{
	cleanupScreenImage( dc );
	XDestroyWindow( dc->display, dc->window );
	XCloseDisplay( dc->display );
}

void	X_check_and_handle_event( void *arg )
{
	DisplayContext	*dc;
	XEvent		event;
	int		count;
	BYTE		key, Apple_Key();
	char		buffer[256];

	dc = (DisplayContext*)arg;

#ifndef	MOTIF
	for( count = XPending( dc->display ); count > 0; count-- ) {
	   XNextEvent( dc->display, &event );
	   switch( event.xany.type ) {
	      case KeyPress:
	         key = Apple_Key( &event );
	         if ( key & 0x80 ) /* normal keystrokes */
	            recordKeyEvent( key, AppleClock, TRUE );
	         else 
	            switch( key ) {
	            case LEFT_APPLE_KEY:
	            case RIGHT_APPLE_KEY:
	               press_apple_key( key );
	               break;
	            case DISK_DRIVE_KEY:
	               /* Should ask which drive, and should
		        * free the existing string if possible - wkt
	                */
	               puts( "Mount new disk\n" );
	               buffer[0] = '\0';
	               fgets( buffer, 256, stdin );
	               if (buffer[0]) 
	                  buffer[strlen( buffer ) - 1 ] = '\0';
	               /* ctkwan: free previosly allocated string */
	               if( disk_name[6][0]!=NULL)
	                  free( disk_name[6][0] );   
		       disk_name[6][0]= strdup(buffer);
	               mount_disk(6,0);
	            }
	         break;
	      case KeyRelease:
	         key = Apple_Key( &event );
	         if ( key & 0x80 ) /* normal keystrokes */
	            recordKeyEvent( key, AppleClock, FALSE );
	         else
	            switch( key ) {
	            case LEFT_APPLE_KEY:
	            case RIGHT_APPLE_KEY:
	               release_apple_key( key );
	               break;
	            }
	         break; 
	      case ButtonPress:
	         if(event.xbutton.button>0 && event.xbutton.button<3 )
	            MouseButtonState[event.xbutton.button-1]=TRUE;
	         break;
	      case ButtonRelease:
	         if(event.xbutton.button>0 && event.xbutton.button<3 )
	            MouseButtonState[event.xbutton.button-1]=FALSE;
	         break;
#if 0
	      case ButtonPress:
	         press_button( event.xbutton.button - 1 );
	         break;
	      case ButtonRelease:
	         release_button( event.xbutton.button - 1 );
	         break;
#endif
	      case Expose:
	         if ( event.xexpose.count == 0 )
#if 0
	            Refresh_Screen( 0, 23 );
#endif
	            refreshScreen();
	         break;
	      case DestroyNotify:
	         Signal6502( SIG_6502_SHUTDOWN );
	         break;

#if 0
	      default:
	         fprintf(stderr,"unknown event type #%d\n",event.xany.type);
#endif
	
	   }
	}

#endif
	/*
	 * re-submit micro job for X window
	 */
	submit_micro_job( AppleClock + REFRESH_INTERVAL, 
	   X_check_and_handle_event, arg );

}

/*
 *	Apple_Key:
 *	try to translate a KeyEvent to an Apple Key
 *	Stroke/Release. Apple_Key returns the ASCII
 *	code of the keys (bit 8 = 1), 0 if no key mapped
 */
static BYTE Apple_Key( XEvent *the_key_event )
{
	KeySym		the_key_sym;
	XComposeStatus	the_XC_status;
	char		buffer[2];
	BYTE		key;
	int		len;

	/*
	 *	Ordinary Characters
	 *	ISO-Latin 1 (ASCII 00-7f)
	 */
	the_key_sym = XLookupKeysym( &(the_key_event->xkey), 0 );
	if ( (unsigned short)the_key_sym < 0x80 ) {
	   len = XLookupString( &(the_key_event->xkey), buffer, 2,
	      &the_key_sym, &the_XC_status );
	   if( len ) {
	      /* case swap. In unix, lowercase is the default */
	      key = buffer[0];
	      if ( isupper( key ) )
	         key = tolower( key );
	      else if ( islower( key ) )
	         key = toupper( key );

	      /* Apple II uses ASCII with bit 7 set */ 	
	      return key | 0x80;
	   }
	   else
	      return 0;
	}

	/*
	 *	Special Characters, Modifiers	
	 */
	switch(the_key_sym) {
	   case XK_Return:
	      return 0x8D;	/* Retrun	*/
	   case XK_Tab:
	      return 0x89;	/* Ctrl-I	*/
	   case XK_BackSpace:
	   case XK_Left:
	      return 0x88;	/* Ctrl-H	*/
	   case XK_Right:
	      return 0x95;	/* Ctrl-U	*/
	   case XK_Up:
	      return 0x8B;	/* Ctrl-K	*/
	   case	XK_Down:
	      return 0x8A;	/* Ctrl-J	*/
	   case	XK_Escape:
	      return 0x9B;	/* Escape	*/
	   case	XK_Delete:
	      if ( the_key_event->xkey.state & ControlMask ) /* Crtl-Del? */
	         assert_RES();
	      return 0xFF;	/* Delete	*/
	
	   /*
	    *	Apple Keys for IIe & IIc
	    */
	   case XK_Alt_L:
	      return LEFT_APPLE_KEY;	/* Left Apple Key */
	   case XK_Alt_R:
	      return RIGHT_APPLE_KEY;	/* Right Apple Key */
	   case XK_F1:
	      return DISK_DRIVE_KEY;	/* Disk ][ Function Key */
#if 0
	   case XK_F3:
	      if (the_key_event->xany.type==KeyPress){
	         dumpIOU();
	      }
	      break;
	   case XK_F4:
	      if (the_key_event->xany.type==KeyPress){
	         enterMonitor();
	      }
#endif
	      break;
	   case XK_F2:
	      shutdown_6502();
	}
	return 0;
}

int getMouseButton(int button)
{
	if (button<0 || button>2)
	  return FALSE;
	else
	  return MouseButtonState[button];
	
}
/*
 * getmouse: return current mouse position relative to apple
 * window. The mouse position is used for paddle emulation.
 * return false if mouse is not on the same screen as the Apple II window.
 */
BOOLEAN getmouse( DisplayContext *dc, int *x, int *y )
{
	int		root_x, root_y;
	Window		root_return, child_return;
	unsigned	mask_return;

	return (BOOLEAN) XQueryPointer( dc->display, dc->window, &root_return, 
	   &child_return, &root_x, &root_y, x, y, &mask_return );

}

void setMousePosition( DisplayContext *dc, int x, int y )
{
	XWarpPointer( dc->display, dc->window, dc->window, 0, 0, 0, 0, x, y );
}

void turnOffCursor( DisplayContext *dc)
{
	XDefineCursor( dc->display, dc->window, InvisibleCursor);
}

void turnOnCursor( DisplayContext *dc )
{
	XUndefineCursor( dc->display, dc->window );
}
