/*****************************************************************************
 * Copyright (C) 1997-2007 YAE
 * $Id$
 *
 * Author: Doug Kwan <chun_tak@yahoo.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111, USA.
 *****************************************************************************
 * video.h
 *
 * SHM based video emulator
 */
#ifndef VIDEO_H
#define VIDEO_H
#include "x_window.h"

#define SCANLINE_MODE_BLANK	0
#define SCANLINE_MODE_TEXT	1
#define SCANLINE_MODE_LORES	2
#define SCANLINE_MODE_HIRES	3
#define SCANLINE_MODE_TEXT80	4
#define SCANLINE_MODE_DLORES	5
#define SCANLINE_MODE_DHIRES	6
#define NO_OF_SCANLINE_MODES	7

extern unsigned ScanlineOffsetTable[192];

typedef struct {
	int y;
	int mode;
	int addr;
	int old_mode;
	int old_addr;
	void *scanline_addr1;
	void *scanline_addr2;
	APPLE_TICK write_lock_set;
	APPLE_TICK aux_write_lock_set;
	int state;
} scanline_t;

#define SCANLINE_STATE_CLEAN	0
#define SCANLINE_STATE_DIRTY	1
#define SCANLINE_STATE_DRAWN	2

typedef struct {
	void (*initScanlineData)( DisplayContext *);
	void (*drawBlankScanline)(scanline_t*);
	void (*drawTextScanline)(scanline_t*);
	void (*drawLoresScanline)(scanline_t*);
	void (*drawHiresScanline)(scanline_t*);
	void (*drawText80Scanline)(scanline_t*);
	void (*drawDLoresScanline)(scanline_t*);
	void (*drawDHiresScanline)(scanline_t*);
	void (*changeCharSet)(int);
} VideoModeDriver;

void initScreen(Display *);
int drawScreen(void);
void updateScreen(DisplayContext *);

#endif /* VIDEO_H */
