/*****************************************************************************
 * Copyright (C) 1997-2007 YAE
 * $Id$
 *
 * Author: Doug Kwan <chun_tak@yahoo.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111, USA.
 *****************************************************************************
 *
 * vbl.c
 *
 * vertical blinking register
 */
#include <stdio.h>
#include "hardware.h"
#include "yae.h"

#define SCAN_LINE_TICKS	65
#define LINES_PER_FRAME 262
#define VBL_START	192
#define FRAME_TICKS	(SCAN_LINE_TICKS*LINES_PER_FRAME)

static APPLE_TICK NextVBLRecalibrate;
static APPLE_TICK VBLTimeBase;
static void VBLRecalibrate(void*);

void	(*VBLCallback)();

void initVBL(void)
{
	VBLCallback=NULL;
	if (MachineType >= APPLE_IIE)
	   submit_micro_job( VBLTimeBase+VBL_START*SCAN_LINE_TICKS, 
	      VBLRecalibrate, NULL );
}

void addVBLCallback(void (*callback)())
{
	VBLCallback=callback;
}

int isVBL(void)
{
	int	lines;

	lines=(AppleClock-VBLTimeBase)/SCAN_LINE_TICKS;
	if (lines>=LINES_PER_FRAME)
	   lines %= LINES_PER_FRAME;
	return lines>=VBL_START;
}

static void VBLRecalibrate(void *arg)
{
	int frames;

	frames = (AppleClock - VBLTimeBase)/FRAME_TICKS;
	VBLTimeBase += FRAME_TICKS*frames;
	NextVBLRecalibrate+=FRAME_TICKS;
	if (VBLCallback)
	   (*VBLCallback)();
	submit_micro_job( NextVBLRecalibrate, VBLRecalibrate, NULL );
}
