/*****************************************************************************
 * Copyright (C) 1997-2007 YAE
 * $Id$
 *
 * Author: Doug Kwan <chun_tak@yahoo.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111, USA.
 *****************************************************************************
 *
 * ucron.c
 * micro job scheduler
 */
#include <stdio.h>
#include <sys/types.h>
#include "hardware.h"
#include "6502.h"
#include "yae.h"

#define MAX_JOBS 16 

typedef struct jt{
	APPLE_TICK	start;
	void		(*thunk)();
	caddr_t		data;
	struct jt	*next;
} job_t;


static job_t	Job_Table[MAX_JOBS];
static job_t	*Job_List=(job_t*)0;
static job_t	*Free_Slot=(job_t*)0;
static int	Job_Queue_Size = 0;

int submit_micro_job( when, job, job_data )
APPLE_TICK when;
void (*job)();
void *job_data;
{
	int	i;
	job_t	*new, *ptr;

	/* late jobs are not accepted */
	if ( !TICK_GREATER( when, AppleClock ) )
	   return 0;

	/* queue full */
	if (Job_Queue_Size == MAX_JOBS) {
	   fprintf( stderr, "micro job queue full\n" );
	   return 0;
	}

	/* find a free slot */
	if ( !Free_Slot ) { /* data not initialized */
	   for( i = 0; i < MAX_JOBS - 1; i++ )
	      Job_Table[i].next = &Job_Table[i+1];	
	   Job_Table[MAX_JOBS-1].next = (job_t*)0;	
	   Free_Slot = &Job_Table[0];
	}
		
	new = Free_Slot;
	Free_Slot = Free_Slot->next;
	Job_Queue_Size++;
	new->start = when;
	new->thunk = job;
	new->data = job_data;

	/* insert new job in queue */
	if (!Job_List || !TICK_LESS( Job_List->start, when ) ) {
	   new->next = Job_List;
	   Job_List = new;
	   set_next_timer_exception( when );	/* this is the first job */
	}
	else {
	   ptr = Job_List;
	   while( ptr->next && TICK_GREATER( when, ptr->next->start ) ) 
	      ptr = ptr->next;
	   new->next = ptr->next;
	   ptr->next = new;
	}

	return 0;

}

void execute_micro_jobs()
{
	job_t		*ptr;
	void		(*thunk)();
	caddr_t		data;

	while( Job_Queue_Size > 0 && 
	   !TICK_GREATER(Job_List->start, AppleClock ) ) {
	   thunk = Job_List->thunk;
	   data = Job_List->data;
	   ptr = Job_List;
	   Job_List = Job_List->next;
	   ptr->next = Free_Slot;
	   Free_Slot = ptr;
	   Job_Queue_Size--;

	   /*
	    * a micro job must be removed from the list before
	    * it is called because it may re-submit itself
	    */ 
	   (*thunk)(data);
	}
	
	/*
	 * all jobs done, reset CPU exception timer 
	 */
	if ( Job_List ) 
	   set_next_timer_exception( Job_List->start );
	else
	   set_next_timer_exception( AppleClock + 0x80000000 );
}
