/*****************************************************************************
 * Copyright (C) 1992-2007 YAE
 * $Id$
 *
 * Author: Doug Kwan <chun_tak@yahoo.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111, USA.
 *****************************************************************************
 *
 *	main.c -- Globals and emulation setup for Apple ][ Emulator
 *	(C) 1989 Ben Koning [556498717 408/738-1763 ben@apple.com]
 *
 *	modified by Doug C.T. Kwan
 *	to include X window interfaces
 *	(C) 1992 D. C. T. Kwan
 */
#define	_MAIN_C_

#include <stdlib.h>
#include <stdio.h>
#include <signal.h>
#include <unistd.h>

#include "hardware.h"
#include "x_window.h"
#include "memory.h"
#include "6502.h"
#include "iou.h"
#include "yae.h"

#include <X11/Xlib.h>
#include <X11/Xresource.h>

AppleCPUContextStruct	context;

#ifdef SLAVE_PROCESSOR
AppleCPUContextStruct	slave_context;
#endif /* SLAVE_PREOCESSOR */

static char Options[]="2e+";

RETSIGTYPE sigintHandler(int sig)
{
	shutdown_6502();
}

void setDefaultOptions(void)
{
	MachineType=APPLE_IIE;
	UseXShm=TRUE;
	RunningMan=FALSE;
}

void processOptions(int argc, char *argv[])
{
	int	c;

	while((c=getopt(argc,argv,Options))!= EOF) {
	    switch(c) {
	    case '2':
	       break;
	    case 'e':
	       MachineType=APPLE_IIE;
	       break;
	    case '+':
	       MachineType=APPLE_II_PLUS;
	       break;
	    }
	}
}

int main (int argc, char *argv[])
{
	unsigned	sigcode;
	extern int	optind;


	/* Initialize the emulation: */
	AppleClock = 0;

	setDefaultOptions();
	ParseConfigFile();
	processOptions(argc,argv);

	/* mount disks */
	if (optind<argc) disk_name[6][0]=argv[optind++];
	if (optind<argc) disk_name[6][1]=argv[optind++];
	if (optind<argc) disk_name[5][0]=argv[optind++];
	if (optind<argc) disk_name[5][1]=argv[optind++];

	/*
	 * Initialize the world
	 */
	initSpeed();
	(void)init_memory();
	mmuMicrojob();
#if 1
	appleDisplayContext = init_X();
	initVideo( appleDisplayContext );
#endif
	initVBL();
	initMouseCard();
#if 0
	initSerialCard();
#endif


#ifdef	RUN_TIME_TRANSLATION
	(void)InitCompilerTables();
	(void)init_compiler();
#endif
	(void)init_disk2();
	(void)init_sound();

#if 0
	signal( SIGINT, sigintHandler );
	signal( SIGHUP, sigintHandler );
	signal( SIGTERM, sigintHandler );
#endif

	/*
	 *Run it until user wants to quit:
	 */
	(void)init_6502();
	(void)Signal6502( SIG_6502_RES );
#ifdef	SLAVE_PROCESSOR
	(void)InitSlaveCPU();
	(void)SyncSlaveMemory();
	slave_context = context;
#endif

	do {
	   sigcode = CPUExecute( &context );
	   if (sigcode == SIG_6502_EMULATION){
	      ServiceEmulationException(&context);
	   }
#ifdef	SLAVE_PROCESSOR
	   if ( sigcode == SIG_6502_RES ) {
	      (void)InitSlaveCPU();
	      (void)SyncSlaveMemory();
	      slave_context = context;
           }
	   else
	      (void)SlaveCPUExecute( &slave_context );
#endif	/* SLAVE_PROCESSOR*/

#ifdef	RUN_TIME_TRANSLATION
	   (void)RecordLastPC( context.PC & 0xFFFF );
#endif
	   if (sigcode == SIG_6502_RES){
	      resetIOU();
	   }
	
	   if (sigcode == SIG_6502_TIMER)
	      (void)execute_micro_jobs();

	} while ( !( sigcode & SIG_6502_SHUTDOWN ) );

	/* Exit cleanly: */
	quit_X( appleDisplayContext );
	printf( "%d cycles\n", AppleClock );
	printf( "%d cycles in vm\n", VMTime );
	printf( "hit ratio %g\n", (float)VMTime/AppleClock );

	return 0;
}
