/*****************************************************************************
 * Copyright (C) 1994-2007 YAE
 * $Id$
 *
 * Author: Doug Kwan <chun_tak@yahoo.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111, USA.
 *****************************************************************************/

#include "hardware.h"
#include "memory.h"
#include "iou.h"
#include "yae.h"

static char rcsid[]="$Id: iou.c,v 1.15 1998/01/15 09:11:18 ctkwan Exp ctkwan $";

/* soft switches */

int	C800ROMSlot;

#define OFFSET(x)	((x)&0xff)
#define SET(x)		IOUState=(IOUSoftSwitch=IOUSoftSwitch|(x))
#define RESET(x)	IOUState=(IOUSoftSwitch=IOUSoftSwitch&~(x))

static int garbage;

static unsigned IOUSoftSwitch=0;
unsigned IOUState=0;

static char	*IOUSoftSwitchName[]={
	"SS_TEXT",
	"SS_MIXED",
	"SS_PAGE2",
	"SS_HIRES",
	"SS_80COL",
	"SS_DHIRES",
	"SS_80STORE",
	"SS_ALTCHAR",
	"SS_RAMRD",
	"SS_RAMWRT",
	"SS_SLOTCXROM",
	"SS_ALTZP",
	"SS_SLOTC3ROM",
	"SS_IOUDIS",
	"SS_LCBANK2",
	"SS_LCRAMRD",
	"SS_LCRAMWRT",
	"SS_VBLBAR",
	"SS_EXPNROM",
	"SS_AN0",
	"SS_AN1",
	"SS_AN2",
	"SS_AN3" };

#if 0
#define remapLCRead()
#define remapLCHiWrite()
#define remapLCLoWrite()
#define remapHiresRead()
#define remapHiresWrite()
#define remapTextRead()
#define remapTextWrite()
#define remapRAMRead()
#define remapRAMWrite()
#endif

void printer_byte(BYTE data);

void resetIOU(void)
{
	IOUSoftSwitch=0;
	SET(SS_IOUDIS);
	remapZP();
	remapRAMRead();
	remapRAMWrite();
	remapTextRead();
	remapTextWrite();
	remapHiresRead();
	remapHiresWrite();
	remapCXROM();
	remapLCRead();
	remapLCLoWrite();
	remapLCHiWrite();
}

void toggleMemorySoftSwitch(ADDR address)
{	
#if 0
	printf("toggleMemorySoftSwitch $%04X\n",address);
#endif
	switch(address){
	case CLR80STORE:
	   if (IOUSoftSwitch & SS_80STORE) {
	      RESET(SS_80STORE);
	      remapTextRead();
	      remapTextWrite();
	      if (IOUSoftSwitch & SS_HIRES){
	         remapHiresRead();
	         remapHiresWrite();
	      }
	   }
	   break;
	case SET80STORE:
	   if (!(IOUSoftSwitch & SS_80STORE)) {
	      SET(SS_80STORE);
	      remapTextRead();
	      remapTextWrite();
	      if (IOUSoftSwitch & SS_HIRES){
	         remapHiresRead();
	         remapHiresWrite();
	      }
	   }
	   break;
	case RDMAINRAM:
	   if (IOUSoftSwitch&SS_RAMRD){
	      RESET(SS_RAMRD);
	      remapRAMRead();
	      if (!(IOUSoftSwitch&SS_80STORE))
	         remapTextRead();
	      if ((IOUSoftSwitch&(SS_80STORE|SS_HIRES))!=(SS_80STORE|SS_HIRES))
	         remapHiresRead();
	   }
	   break;
	case RDCARDRAM:	
	   SET(SS_RAMRD);
	   remapRAMRead();
	   if (!(IOUSoftSwitch&SS_80STORE))
	      remapTextRead();
	   if ((IOUSoftSwitch&(SS_80STORE|SS_HIRES))!=(SS_80STORE|SS_HIRES))
	      remapHiresRead();
	   break;
	case WRMAINRAM:	
	   RESET(SS_RAMWRT);
	   remapRAMWrite();
	   if (!(IOUSoftSwitch&SS_80STORE))
	      remapTextWrite();
	   if ((IOUSoftSwitch&(SS_80STORE|SS_HIRES))!=(SS_80STORE|SS_HIRES))
	      remapHiresWrite();
	   break;
	case WRCARDRAM:	
	   SET(SS_RAMWRT);
	   remapRAMWrite();
	   if (!(IOUSoftSwitch&SS_80STORE))
	      remapTextWrite();
	   if ((IOUSoftSwitch&(SS_80STORE|SS_HIRES))!=(SS_80STORE|SS_HIRES))
	      remapHiresWrite();
	   break;
	case SETSLOTCXROM:
	   RESET(SS_SLOTCXROM);
	   remapCXROM();
	   break;
	case SETINTCXROM:
	   SET(SS_SLOTCXROM);
	   remapCXROM();
	   break;
	case SETSTDZP:
	   RESET(SS_ALTZP);
	   remapZP();
	   if (IOUSoftSwitch&SS_LCRAMRD)
	      remapLCRead();
	   if (IOUSoftSwitch&SS_LCRAMWRT){
	      remapLCLoWrite();
	      remapLCHiWrite();
	   }
	   break;
	case SETALTZP:
	   SET(SS_ALTZP);
	   remapZP();
	   if (IOUSoftSwitch&SS_LCRAMRD)
	      remapLCRead();
	   if (IOUSoftSwitch&SS_LCRAMWRT) {
	      remapLCLoWrite();
	      remapLCHiWrite();
	   }
	   break;
	case SETINTC3ROM:
	   RESET(SS_SLOTC3ROM);
	   if (C800ROMSlot==3)
	      SET(SS_EXPNROM);
	   remapCXROM();
	   break;
	case SETSLOTC3ROM:
	   SET(SS_SLOTC3ROM);
	   RESET(SS_EXPNROM);
	   remapCXROM();
	   break;
	case CLR80VID:
	   RESET(SS_80COL);
	   break;
	case SET80VID:
	   SET(SS_80COL);
	   break;
	case CLRALTCHAR:
	   RESET(SS_ALTCHAR);
	   break;
	case SETALTCHAR:
	   SET(SS_ALTCHAR);
	}
}

BYTE readSoftSwitch(ADDR address)
{
	int flag,data;
	static unsigned long soft_switch_list[16]={
	   0 /* key strobe */, SS_LCBNK2, SS_LCRAM, SS_RAMRD,
	   SS_RAMWRT, SS_SLOTCXROM, SS_ALTZP, SS_SLOTC3ROM,
	   SS_80STORE, 0 /* VBL */, SS_TEXT, SS_MIXED,
	   SS_PAGE2, SS_HIRES, SS_ALTCHAR, SS_80COL };

	data = garbage>>8;
	flag=soft_switch_list[address&0xf];
	if (flag)
	    data = (flag&IOUSoftSwitch)? data | 0x80: data & 0x7f; 
	else {
	   if (address==KBDSTRB) {
	      strobeKeyboard();
	      return keyHeld();
	   }
	   else if (address==RDVBLBAR) {
	      if (!isVBL())
	         SET(SS_VBLBAR);
	      else
	         RESET(SS_VBLBAR);
	      data = (SS_VBLBAR&IOUSoftSwitch)? data | 0x80: data & 0x7f;
	   }
	}
	return data;
}

void toggleTapeOut(void)
{
}

void toggleVideoSoftSwitch( ADDR address )
{
	/* IOU internal house keeping */
#if 0
	printf("graphics switch $%04X\n",address);
#endif
	switch(address){
	   case TXTCLR:
	      RESET(SS_TEXT);
	      break;
	   case TXTSET:
	      SET(SS_TEXT);
	      break;
	   case MIXCLR:
	      RESET(SS_MIXED);
	      break;
	   case MIXSET:
	      SET(SS_MIXED);
	      break;
	   case LOWSCR:
	      if (IOUSoftSwitch&SS_PAGE2){
	         RESET(SS_PAGE2);
	         if (IOUSoftSwitch&SS_80STORE) {
	            remapTextRead();
	            remapTextWrite();
	            if (IOUSoftSwitch&SS_HIRES){
	               remapHiresRead();
	               remapHiresWrite();
	            }
	         }
	      }
	      break;
	   case HISCR:
	      if (!(IOUSoftSwitch&SS_PAGE2)){
	         SET(SS_PAGE2);
	         if (IOUSoftSwitch&SS_80STORE) {
	            remapTextRead();
	            remapTextWrite();
	            if (IOUSoftSwitch&SS_HIRES){
	               remapHiresRead();
	               remapHiresWrite();
	            }
	         }
	      }
	      break;
	   case LOWRES:
	      if (IOUSoftSwitch&SS_HIRES) {
	         RESET(SS_HIRES);
	         if (IOUSoftSwitch&SS_80STORE) {
	            remapHiresRead();
	            remapHiresWrite();
	         }
	      }
	      break;
	   case HIRES:
	      if (!(IOUSoftSwitch&SS_HIRES)) {
	         SET(SS_HIRES);
	         if (IOUSoftSwitch&SS_80STORE){
	            remapHiresRead();
	            remapHiresWrite();
	         }
	      }
	      break;
	}
}

/*
 * toggleAnnunciator: Handles I/O in the region $C058-$C05F.
 * If IOUDIS is on, access to the annunicator is disabled
 * and access to the DHIRES is enabled. If IOUDIS is off,
 * access to the annunicator is enabled, DHIRES switch is
 * disabled.
 */
void toggleAnnunciator( ADDR address )
{
	static unsigned long soft_switch_list[4]={
	   SS_AN0, SS_AN1, SS_AN2, SS_AN3 };
	int an;

	/*
	 * access DHIRES only if for //e or //c
	 */
	if (MachineType>=APPLE_IIE&&(IOUSoftSwitch&SS_IOUDIS)){
	   if (address==SETDHIRES){
#ifdef DEBUG
              fprintf(stderr,"DHIRES ON\n");
#endif
	      SET(SS_DHIRES);
	   }
	   else if (address==CLRDHIRES){
#ifdef DEBUG
              fprintf(stderr,"DHIRES OFF\n");
#endif
	      RESET(SS_DHIRES);
	   }
	}
	else {
	   an = (address >> 1) & 3;
	   if ( address & 1 ) /* on */
	      SET(soft_switch_list[an]);
	   else
	      RESET(soft_switch_list[an]);
	}
}

void toggleLanguageCard( ADDR address )
{
	unsigned old_ss;

	old_ss=IOUSoftSwitch;

	/* set IOU soft switches */
	switch(address & 0xF){
	case 0:
	    SET(SS_LCBNK2);
	    SET(SS_LCRAMRD);
	    RESET(SS_LCRAMWRT);
	    break;
	case 1:
	    SET(SS_LCBNK2);
	    RESET(SS_LCRAMRD);
	    SET(SS_LCRAMWRT);
	    break;
	case 2:
	    SET(SS_LCBNK2);
	    RESET(SS_LCRAMRD);
	    RESET(SS_LCRAMWRT);
	    break;
	case 3:
	    SET(SS_LCBNK2);
	    SET(SS_LCRAMRD);
	    SET(SS_LCRAMWRT);
	    break;
	case 8:
	    RESET(SS_LCBNK2);
	    SET(SS_LCRAMRD);
	    RESET(SS_LCRAMWRT);
	    break;
	case 9:
	    RESET(SS_LCBNK2);
	    RESET(SS_LCRAMRD);
	    SET(SS_LCRAMWRT);
	    break;
	case 0xA:
	    RESET(SS_LCBNK2);
	    RESET(SS_LCRAMRD);
	    RESET(SS_LCRAMWRT);
	    break;
	case 0xB:
	    RESET(SS_LCBNK2);
	    SET(SS_LCRAMRD);
	    SET(SS_LCRAMWRT);
	}

	if (old_ss!=IOUSoftSwitch){
#if 1 && defined(DEBUG)
	   printf("toggle LC address $%04X at %d\n",address,AppleClock);
#endif
	   remapLCRead();
	   remapLCLoWrite();
	   remapLCHiWrite();
	}
}

unsigned long GetIOUSoftSwitch(void)
{
	return IOUSoftSwitch;
}

BYTE AppleIORead( ADDR address )
{
	int	slot,data;

	garbage=garbage*0x31415927+0x27182818;
	data=garbage>>8;

	if ( address < 0xC080 ) { /* $C000-$C07F soft switches */
	   switch((address>>4)&0xf){
	   case 0: /* KBD */
	      return readKeyboard();

	   case 1: /* KBDSTRB */
	      if (MachineType >= APPLE_IIE)
	         return readSoftSwitch(address); 
	      else
	         strobeKeyboard();
	      break;
	   case 2: /* TAPEOUT */
	      if ( address == PRNTOUT )
	         printer_byte(data);
	      else
	         toggleTapeOut();
	      break;
	   case 3:
	      toggleSpeaker();
	      break;
	   case 4: /* ??? */
	      break;
	   case 5:
	      if (address < 0xC058)
	         toggleVideoSoftSwitch(address);
	      else 
	         toggleAnnunciator(address);
	      break;
	   case 6:
	      if (address>=BUTN0&&address<=PADDL3)
	         return read_paddle(address);
	      break;
	   case 7: /* PTRIG and RDIOUDIS */
	      trigger_paddle(); /* trigger paddle */
	      if (MachineType >= APPLE_IIE ) {
	         RESET(SS_VBLBAR);
	         if (address==RDIOUDIS) /* '1' = off */
	            data=(IOUSoftSwitch & SS_IOUDIS)? data&0x7f:(data|0x80);
	         else if (address==RDDHIRES)
	            data=(IOUSoftSwitch & SS_DHIRES)? (data|0x80): data&0x7f;
	      }
	   }
	}
	else if ( address < 0xC100 ) {
	   slot=(address>>4)&0x7;
	   if (slot==0)
	      toggleLanguageCard(address);
	   else if (expansion_slot_read[slot])
	      data=(*expansion_slot_read[slot])(address);
	}
	else if ( (MachineType >= APPLE_IIE) &&
	   (IOUSoftSwitch & SS_SLOTCXROM) ) { /* internal ROM */
	   return ((BYTE*)MainMemoryROM[(address>>8)])[address&0xff];
	}
	else {
	   if ( address < 0xC800 ) { /* slot ROM */
	      slot = (address >> 8) & 0x7;
	      if ( (MachineType >= APPLE_IIE) && 
	         slot==3 && !(IOUSoftSwitch & SS_SLOTC3ROM)) {
	         if (C800ROMSlot==0) {
	            C800ROMSlot=3;
	            SET(SS_EXPNROM);
	            remapCXROM();
	         }
	         return ((BYTE*)MainMemoryROM[(address>>8)])[address&0xff];
	      }
	      else { 
	         if (C800ROMSlot==0) { /* active expansion ROM */
	            C800ROMSlot=slot;
	            remapCXROM();
	         }
	         if (expansion_slot_read[slot])
	            return(*expansion_slot_read[slot])(address);
	      }
	   }
	   else if (address != CLRROM){ /* $C800-$CFFE expansion ROM */
	      if ((IOUSoftSwitch & SS_EXPNROM))
	         return ((BYTE*)MainMemoryROM[(address>>8)])[address&0xff];
	      if (C800ROMSlot !=0 && expansion_slot_read[C800ROMSlot])
	         return (*expansion_slot_read[C800ROMSlot])(address);
	   }
	   else { /* deactivate expansion ROM */
	      if (C800ROMSlot==3) {
	          MapReadPage(0xC3,NULL);
	          LockReadMappedPage(0xC3,PAGE_LOCK_READ);
	      }
	      C800ROMSlot=0;
	      RESET(SS_EXPNROM);
	      remapCXROM();
	   }
	}

				/* Printer ROM at $C100			*/
				/* Ok, so it's inelegant, but it works  */
				/* STA $C021		8D 21 C0	*/
				/* RTS			60		*/
	if (address == 0xC100) data= 0x8D;
	if (address == 0xC101) data= 0x21;
	if (address == 0xC102) data= 0xC0;
	if (address == 0xC103) data= 0x60;

	return data;
}

int printstream_initialized = FALSE;
FILE *printstream=NULL;

void printer_byte(BYTE data)
{
	/* FIXME: hack to get around a compilation problem. stdout is not
	   a compilation time constant. */
	if (!printstream_initialized) {
	   printstream = stdout;
	   printstream_initialized = TRUE;
	}  
	
	data &= 0x7f;			/* Remove hi-bit */
	if (data==015) data='\n';	/* Convert CR to LF */
	fputc(data,printstream); fflush(printstream);	/* and print it */
}

void AppleIOWrite( ADDR address, BYTE data )
{
	int slot;

	if (address<0xC080){
	   switch((address>>4)&0xf){
	   case 0:
	      if (MachineType >= APPLE_IIE)
	         toggleMemorySoftSwitch(address);
	      break;
	   case 1:
	      if (MachineType < APPLE_IIE || address==KBDSTRB)
	         strobeKeyboard();
	      break;
	   case 2:
	      toggleTapeOut();
	      break;
	   case 3:
	      toggleSpeaker();
	      break;
	   case 5:
	      if (address < 0xC058 )
	         toggleVideoSoftSwitch(address);
	      else 
	         toggleAnnunciator(address);
	      break;
	   case 7:
	      trigger_paddle(); /* trigger paddle */
	      if (MachineType >= APPLE_IIE){
	         RESET(SS_VBLBAR);
	         if ( address==SETIOUDIS) {
                    fprintf(stderr,"IOUDIS ON\n");
	            IOUSoftSwitch |= SS_IOUDIS;
	         }
	         else if (address==CLRIOUDIS) {
                    fprintf(stderr,"IOUDIS OFF\n");
	            IOUSoftSwitch &= ~SS_IOUDIS;
	         }
	      }
	      break;
	   }
	}
	else if (address < 0xC100){ /* slot I/O */
	   slot=(address>>4)&0x7;
	   if (slot==0)
	      toggleLanguageCard(address); 
	   else if (expansion_slot_write[slot])
	      (*expansion_slot_write[slot])(address,data);
	}
	else if ( MachineType < APPLE_IIE || !(IOUSoftSwitch & SS_SLOTCXROM) ) {
	   if (address < 0xC800) { /* slot ROM */
	      slot=(address>>8)&0x7;
	      if ( (MachineType >= APPLE_II) && slot == 3 &&
	         !(IOUSoftSwitch & SS_SLOTC3ROM)){
	         if (C800ROMSlot==0) {
	            C800ROMSlot=3;
	            SET(SS_EXPNROM);
	            remapCXROM();
	         }
	      }
	      else {
	         if (C800ROMSlot==0) { /* active expansion ROM */
	            C800ROMSlot=slot;
	            remapCXROM();
	         }
	         if (expansion_slot_write[slot])
	            (*expansion_slot_write[slot])(address,data);
	      }
	   }
	   else if (address != CLRROM) {
	      if (C800ROMSlot!=0 && expansion_slot_write[C800ROMSlot])
	         (*expansion_slot_write[C800ROMSlot])(address,data);
	   }
	   else { /* deactivate expansion ROM in $C800-$CFFF */
	      if (C800ROMSlot==3) {
	         MapReadPage(0xC3,NULL);
	         LockReadMappedPage(0xC3,PAGE_LOCK_READ);
	      }
	      C800ROMSlot=0;
	      RESET(SS_EXPNROM);
	      remapCXROM();
	   }
	}
}

void dumpIOU()
{
	int	i;

	for(i=0;i<31;i++)
	   if (IOUSoftSwitch&(1<<i))
	      printf("%s ", IOUSoftSwitchName[i]);
	printf("\n");	
}
