/*****************************************************************************
 * Copyright (C) 1994-2007 YAE
 * $Id$
 *
 * Author: Doug Kwan <chun_tak@yahoo.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111, USA.
 *****************************************************************************
 *
 * colour.c
 */

#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>

/* RGB colors */
static struct {
	unsigned short	red;
	unsigned short	green;
	unsigned short	blue;
} AppleIIColor[16]= {
	{0x0,0x0,0x0},	/* Black */
	{0xd,0x0,0x3},	/* Deep Red */
	{0x0,0x0,0x9},	/* Dark Blue */
	{0xd,0x2,0xd},	/* Purple */
	{0x0,0x7,0x2},	/* Dark Green */	
	{0x5,0x5,0x5},	/* Dark Gray */
	{0x2,0x2,0xf},	/* Medium Blue */	
	{0x6,0xa,0xf},	/* Light Blue */
	{0x8,0x5,0x0},	/* Brown */	
	{0xf,0x6,0x0},	/* Orange */
	{0xa,0xa,0xa},	/* Light Gray */
	{0xF,0x9,0x8},	/* Pink */
	{0x1,0xd,0x0},	/* Light Green */
	{0xf,0xf,0x0},	/* Yellow */
	{0x4,0xf,0x9},	/* Aquamarine */
	{0xf,0xf,0xf}	/* White */
};

unsigned long AppleColourPixel[16];

static void findMaskShift( unsigned long mask, int *shift, int *max )
{
	int	s, m;

	if( mask == 0 ) {
	   *shift=0;
	   *max=0;
	}
	else {
	   m = mask;
	   s = 0;
	   while ( !(m & 1 ) ) {
	      m>>=1;
	      s++;
	   }
	   *shift=s;
	   *max=m;
	}
}

int allocAppleColours(Display *dpy, Visual *visual, Colormap cmap,
	unsigned long pixel[16] )
{
	int i, nVisuals;
	XColor color;
	unsigned long c, red_mask, green_mask, blue_mask;
	int red_mask_shift, green_mask_shift, blue_mask_shift;
	int red_max, green_max, blue_max;
	XVisualInfo vinfoTemplate, *vinfoList;

	/* get info about current visual */	
	vinfoTemplate.visualid = visual->visualid;
	vinfoList = XGetVisualInfo( dpy, VisualIDMask, &vinfoTemplate,
	   &nVisuals );

	/* this should never happen */
	if ( !nVisuals || vinfoList[0].visualid != visual->visualid ) {
	   fprintf(stderr,"Cannot get visual information\n" );
	   exit(1);
	}

	switch( visual->class ) {
	case PseudoColor:
	   for(i=0;i<16;i++){
	      color.red=AppleIIColor[i].red<<12;
	      color.green=AppleIIColor[i].green<<12;
	      color.blue=AppleIIColor[i].blue<<12;
	      color.flags=DoRed|DoGreen|DoBlue;
	      if (!XAllocColor(dpy, cmap, &color)) {
	         fprintf(stderr,"Cannot allocate color #%d\n",i);
	         return -1;
	      };
#ifdef DEBUG
	      printf("allocated color %d 0x%02x r=%04X g=%d04X b=%04X\n",i,
	         color.pixel,color.red, color.green,color.blue);
#endif
	      pixel[i]=color.pixel;
	   }
	   break;
	case StaticColor:
	case TrueColor:
	case DirectColor:

	   red_mask = vinfoList[0].red_mask;
	   green_mask = vinfoList[0].green_mask;
	   blue_mask = vinfoList[0].blue_mask;
	   findMaskShift( red_mask, &red_mask_shift, &red_max );
	   findMaskShift( green_mask, &green_mask_shift, &green_max );
	   findMaskShift( blue_mask, &blue_mask_shift, &blue_max );

	   for( i = 0; i< 16; i++ ) {
	      c = ((AppleIIColor[i].red*red_max/15) << red_mask_shift) |
	         ((AppleIIColor[i].green*green_max/15) << green_mask_shift) |
	         ((AppleIIColor[i].blue*blue_max/15) << blue_mask_shift );
	      pixel[i]=c;

	   }
	}

	XFree( vinfoList );
	return 0;
}
