/*
 * yae.h
 *
 * declare functions defined in various modules of YAE
 *
 */
#ifndef _YAE_H_
#define _YAE_H_

/* disk2.c */
void init_disk2(void);
int mount_disk( int, int );
int unmount_disk( void );

/* gcr.c */
void SectorsToNibbles( BYTE *, BYTE *, int, int );
int NibblesToSectors( BYTE *, BYTE *, int, int );

/* keyboard.c */
void recordKeyEvent( BYTE, APPLE_TICK, BOOLEAN );
BYTE readKeyboard(void);
BYTE keyHeld(void);
void strobeKeyboard(void);

/* loadrom.c */
int checkROMFile(char*, int*, int*, int*);
int loadROMFile(char*);

/* memmap.c */
void remapZP(void);
void remapRAMRead(void);
void remapRAMWrite(void);
void remapTextRead(void);
void remapTextWrite(void);
void remapHiresRead(void);
void remapHiresWrite(void);
void remapCXROM(void);
void remapLCRead(void);
void remapLCLoWrite(void);
void remapLCHiWrite(void);

/* monitor.c */
void enterMonitor();

/* paddle.c */
void press_button( int );
void release_button( int );
void press_apple_key( int );
void release_apple_key( int );
void trigger_paddle(void);
unsigned read_paddle( ADDR );

/* sound.c */
int init_sound(void);
void toggleSpeaker(void);

/* speed.c */
void initSpeed(void);
unsigned GetAverageSpeed(void);
unsigned GetAverageRawSpeed(void);
unsigned GetTargetSpeed(void);
void SetTargetSpeed(unsigned);

/* ucron.c */
int submit_micro_job( APPLE_TICK, void(*)(), void * );
void execute_micro_jobs(void);

/* vbl.c */
void initVBL(void);
int isVBL(void);

/* confile.c */
void ParseConfigFile(void);

#endif /* _YAE_H_ */
