/*
 *	x_window.h
 *	X Window initializations header file
 */

#ifndef	_X_WINDOW_H_
#define	_X_WINDOW_H_

#include <X11/Xlib.h>
#include <X11/Xutil.h>

#ifdef	EXTERN
#undef	EXTERN
#endif	/* EXTERN */

#ifdef	_MAIN_C_
#define	EXTERN
#else
#define	EXTERN	extern
#endif

#define LEFT_APPLE_KEY  1
#define RIGHT_APPLE_KEY 2
#define DISK_DRIVE_KEY  3
#define REFRESH_INTERVAL 2000

/*
 *	globals
 */

typedef struct {
	Display		*display;
	int		screen;
	long		depth;
	Visual		*visual;
	Colormap	colormap;	
	Window		window;	
	GC		gc;
	int		hasBackingStore;
	unsigned long	appleColourPixel[16];
} DisplayContext;

EXTERN	DisplayContext	*appleDisplayContext;
/*
 *	function prototyping
 */
DisplayContext *init_X(void);
void quit_X( DisplayContext * );
BOOLEAN getmouse( DisplayContext *, int*, int* );
void setMousePosition( DisplayContext *, int, int );
void turnOnCursor( DisplayContext * );
void turnOffCursor( DisplayContext * );
#endif	/* _X_WINDOW_H_ */

