/*
 * video.h
 *
 * SHM based video emulator
 */
#ifndef VIDEO_H
#define VIDEO_H
#include "x_window.h"

#define SCANLINE_MODE_BLANK	0
#define SCANLINE_MODE_TEXT	1
#define SCANLINE_MODE_LORES	2
#define SCANLINE_MODE_HIRES	3
#define SCANLINE_MODE_TEXT80	4
#define SCANLINE_MODE_DLORES	5
#define SCANLINE_MODE_DHIRES	6
#define NO_OF_SCANLINE_MODES	7

extern unsigned ScanlineOffsetTable[192];

typedef struct {
	int y;
	int mode;
	int addr;
	int old_mode;
	int old_addr;
	void *scanline_addr1;
	void *scanline_addr2;
	APPLE_TICK write_lock_set;
	APPLE_TICK aux_write_lock_set;
	int state;
} scanline_t;

#define SCANLINE_STATE_CLEAN	0
#define SCANLINE_STATE_DIRTY	1
#define SCANLINE_STATE_DRAWN	2

typedef struct {
	void (*initScanlineData)( DisplayContext *);
	void (*drawBlankScanline)(scanline_t*);
	void (*drawTextScanline)(scanline_t*);
	void (*drawLoresScanline)(scanline_t*);
	void (*drawHiresScanline)(scanline_t*);
	void (*drawText80Scanline)(scanline_t*);
	void (*drawDLoresScanline)(scanline_t*);
	void (*drawDHiresScanline)(scanline_t*);
	void (*changeCharSet)(int);
} VideoModeDriver;

void initScreen(Display *);
int drawScreen(void);
void updateScreen(DisplayContext *);

#endif /* VIDEO_H */
