/*
 * speed.c
 *
 * speed regulator
 *
 * $Log: speed.c,v $
 * Revision 1.6  1998/11/28  08:08:21  ctkwan
 * adjust raw speed for other processes
 *
 * Revision 1.5  1998/11/23  09:50:19  ctkwan
 * Add variable default speed (by wkt@cs.adfa.edu.au)
 *
 *
 */
static char rcsid[]="$Id: speed.c,v 1.6 1998/11/28 08:08:21 ctkwan Exp ctkwan $";

#include <stdio.h>
#include <unistd.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/resource.h>

#include <math.h>

#include "hardware.h"
#include "yae.h"

#define MAX_LOG_SIZE 61

/*
 * speed is check 60 times an emulator second
 */
#define SPEED_CHECK_FREQUENCY	60
static int	speedCheckTimeSlice[SPEED_CHECK_FREQUENCY];
static int	speedCheckCounter;

struct {
	APPLE_TICK	start_tick;
	struct timeval	start_time;
	struct timeval	ru_utime;
	struct timeval	ru_stime;
	unsigned	usleep_interval;
} SpeedLog[MAX_LOG_SIZE]; 

APPLE_TICK NextSpeedCheck;
int LogStart;
int LogSize;

#define DEFAULT_SPEED	1022727

/* wkt@cs.adfa.edu.au added variable default speed */
int Default_Speed = DEFAULT_SPEED;

int TargetSpeed;
#define TIME_SLICES_PER_SECOND	60
int AverageSpeed;
int AverageRawSpeed;

static void checkSpeed(void*);
static unsigned AppleuSleep(unsigned);

static void calcSpeedCheckTimeSlices( void )
{
	int 	i;
	int	timeSlice;
	
	timeSlice = TargetSpeed/SPEED_CHECK_FREQUENCY;
	for( i = 0; i < SPEED_CHECK_FREQUENCY-1; i++ )
	   speedCheckTimeSlice[i] = timeSlice;
	speedCheckTimeSlice[SPEED_CHECK_FREQUENCY-1] = 
	   TargetSpeed - timeSlice * ( SPEED_CHECK_FREQUENCY -1 );
}

void initSpeed()
{
	TargetSpeed=Default_Speed;
	AverageSpeed=Default_Speed;
	AverageRawSpeed=Default_Speed;
	calcSpeedCheckTimeSlices();
	checkSpeed(NULL);
}

unsigned GetAverageSpeed(void)
{
	return AverageSpeed;
}

unsigned GetAverageRawSpeed(void)
{
	return AverageRawSpeed;
}

unsigned GetTargetSpeed(void)
{
	return TargetSpeed;
}

void SetTargetSpeed(unsigned speed)
{
	if (speed==0)
	   speed=Default_Speed;
	TargetSpeed=speed;
	calcSpeedCheckTimeSlices();
}

/*
 * AppleuSleep: sleep for at least us microsecond. Since usleep is only
 * avaliable on BSD systems, better use select to implement sleep. returns
 * number of microsecond slept.
 */
static unsigned AppleuSleep(unsigned us)
{
	struct timeval tv,start,now;
	unsigned elapsed;

	gettimeofday(&start,NULL),
	tv.tv_sec=us/1000000;
	tv.tv_usec=us%1000000;
	select(0,NULL,NULL,NULL,&tv);
	gettimeofday(&now,NULL),
	elapsed=(now.tv_sec-start.tv_sec)*1000000 +
	   (now.tv_usec-start.tv_usec);
	return elapsed;
}

double sum_speed=0.0;
double variance=0.0;
int n;
static void checkSpeed(void *arg)
{
	struct rusage r_usage;
	int userTime, systemTime;
	int i, j, cycles, duration, total_usleep, s, us;
	double usableCPUTime;

#if 0 ||defined(DEBUG)
	double d;

	sum_speed+=AverageSpeed;
	d=(double)(AverageSpeed-TargetSpeed)/TargetSpeed;
	n++;
	variance+=d*d;
	if (speedCheckCounter==0){
	   printf("AverageSpeed=%d TargetSpeed=%d RawSpeed%d\n",
	      AverageSpeed, TargetSpeed, AverageRawSpeed );
	   printf("AvgSpd=%d Avg2Spd=%G AvgRSpd=%d StdDev=%G\n",AverageSpeed,
	      sum_speed/n,AverageRawSpeed,sqrt(variance/n));
	   variance=0.0;
	   sum_speed=0;
	   n=0;
	}
#endif

	/* get new slot */
	if((i=LogStart+LogSize)>=MAX_LOG_SIZE)
	   i -= MAX_LOG_SIZE; /* wrap around */

	if ( LogSize < MAX_LOG_SIZE ) 
	   LogSize++;
	else if(++LogStart==MAX_LOG_SIZE) /* advance head */
	      LogStart=0;

	SpeedLog[i].start_tick=AppleClock;
	gettimeofday(&SpeedLog[i].start_time,NULL);
	SpeedLog[i].usleep_interval=0;

	/* find out how much CPU time we spend since last check */
	getrusage( RUSAGE_SELF, &r_usage ); 
	SpeedLog[i].ru_utime = r_usage.ru_utime;
	SpeedLog[i].ru_stime = r_usage.ru_stime;

	/* try regulate speed */
	if (LogSize>1){
	   /* find average speed */ 
	   cycles=SpeedLog[i].start_tick-SpeedLog[LogStart].start_tick;
	   s=SpeedLog[i].start_time.tv_sec -
	      SpeedLog[LogStart].start_time.tv_sec;
	   us=SpeedLog[i].start_time.tv_usec -
	      SpeedLog[LogStart].start_time.tv_usec;
	   duration=s*1000000+us;

	   s=SpeedLog[i].ru_utime.tv_sec -
	      SpeedLog[LogStart].ru_utime.tv_sec;
	   us=SpeedLog[i].ru_utime.tv_usec -
	      SpeedLog[LogStart].ru_utime.tv_usec;
	   userTime=s*1000000+us;

	   s=SpeedLog[i].ru_stime.tv_sec -
	      SpeedLog[LogStart].ru_stime.tv_sec;
	   us=SpeedLog[i].ru_stime.tv_usec -
	      SpeedLog[LogStart].ru_stime.tv_usec;
	   systemTime=s*1000000+us;

	   /* find accumlated sleep time */
	   j=LogStart;
	   total_usleep=0;
	   while(j!=i){
	      total_usleep+=SpeedLog[j].usleep_interval;
	      if (++j>=MAX_LOG_SIZE)
	         j=0;
	   }

	   /* 
	    * there may be other processes running, we need to
	    * estimate the fraction of CPU time that we can use.
	    */
	   usableCPUTime = (double)(total_usleep + systemTime + userTime) /
	      duration;
	
	   /* update speed */
	   AverageSpeed=(double)cycles*1000000/duration;

	   /* * Raw speed adjusted by faction of usable CPU time */
	   AverageRawSpeed=(double)cycles*1000000/(duration-total_usleep)*
	      usableCPUTime;

	   /* calculate sleep time this round */
	   us=(double)speedCheckTimeSlice[speedCheckCounter] *
	      (1.0/TargetSpeed-1.0/AverageRawSpeed)*1000000;
	   if (us>0){
	      SpeedLog[i].usleep_interval=us;
	      AppleuSleep(us);
	   }
	}

	/* submit microjob */
	NextSpeedCheck += speedCheckTimeSlice[speedCheckCounter];
	submit_micro_job( NextSpeedCheck, checkSpeed, NULL );

	if ( ++speedCheckCounter == SPEED_CHECK_FREQUENCY )
	   speedCheckCounter = 0;
}
