/*
 *	memory.h
 */
#ifndef	_MEMORY_H_
#define	_MEMORY_H_

#include <stdio.h>
#include "hardware.h"

void	init_memory( /*void */);
BYTE	Apple_memory_read(/* ADDR address */);
void	Apple_memory_write(/* ADDR address, BYTE data*/ );

extern	BYTE		*Read_Page_Table[256];
extern	BYTE		*Write_Page_Table[256];

#ifdef	RUN_TIME_TRANSLATION
extern	unsigned	*Image_Page_Table[256];
#define	COMPILED(page)			(Image_Page_Table[(page)]!=NULL)
#define	ENTRY_POINT(page,offset)	(Image_Page_Table[(page)][offset])
#endif	/* RUN_TIME_TRANSLATION */

extern	BYTE		*InternalROM[16];

/*
 * define AppleMemoryPage as an pointer to an opaque type
 */
typedef	struct _AppleMemoryPageRec {
	BYTE		data[256];	
	unsigned	tag;
	int		read_page_no;
	int		write_page_no;
	int		page_id;
	unsigned	*code;
	unsigned	lock;
	APPLE_TICK	write_lock_set;
	APPLE_TICK	write_lock_broken;
} AppleMemoryPageRec;

/*
 * originally the AppleMemoryPage is defined as an opage
 * pointer type for better encapsulation but it seems that
 * the overhead of read the locks and other stuff is too
 * much a performance hit. There goes the protection and
 * encapsultation. 
 */
typedef	struct	_AppleMemoryPageRec	*AppleMemoryPage;

extern	AppleMemoryPage	MainMemoryRAM[256];
extern	AppleMemoryPage AuxMemoryRAM[256];
extern	AppleMemoryPage	MainMemoryROM[256];

#define	PAGE_LOCK_WRITE	(1<<0)
#define	PAGE_LOCK_CODE	(1<<1)
#define	PAGE_LOCK_READ	(1<<2)

AppleMemoryPage AppleCreateMemoryPage(void);
void AppleDestroyMemoryPage( AppleMemoryPage );
AppleMemoryPage GetNullPage(void);
int MapReadPage( int, AppleMemoryPage );
int MapWritePage( int, AppleMemoryPage );
int MapImagePage( int, unsigned* );
int UnmapReadPage( int );
int UnmapWritePage( int );
int LockReadMappedPage( int, unsigned );
int LockWriteMappedPage( int, unsigned );
int UnlockReadMappedPage( int, unsigned );
int UnlockWriteMappedPage( int, unsigned );
int LockAppleMemoryPage( AppleMemoryPage, unsigned );
int UnlockAppleMemoryPage( AppleMemoryPage, unsigned );

#if 1 
#define GetPageLock(amp)		((amp)->lock)
#define GetWriteLockSetTime(amp)	((amp)->write_lock_set)
#define GetWriteLockBrokenTime(amp)	((amp)->write_lock_broken)
#else
unsigned GetPageLock( AppleMemoryPage );
APPLE_TICK GetWriteLockSetTime( AppleMemoryPage );
APPLE_TICK GetWriteLockBrokenTime( AppleMemoryPage );
#endif

#endif	/* _MEMORY_H_ */
