/*
 *	memory.c
 *
 *	memory module for Apple II emulator
 *	by Doug kwan 
 *	March 10 1994
 *
 */
#define	_MEMORY_C_

#include <stdio.h>
#include "hardware.h"
#include "memory.h"
#include "iou.h"
#include "yae.h"

BYTE		*Read_Page_Table[256];
BYTE		*Write_Page_Table[256];
unsigned	*Image_Page_Table[256];

AppleMemoryPage MainMemoryRAM[256];
AppleMemoryPage AuxMemoryRAM[256];
AppleMemoryPage MainMemoryROM[256];

/* file names of ROM files are now not hard coded (by wkt@cs.adfa.edu.au) */
char *Apple2ROM="APPLE2.ROM";
char *Apple2eROM="APPLE2E.ROM";

void	init_memory()
{
	int		i;
	AppleMemoryPage	amp;

	init_mm();

	for( i = 0; i < 256; i++ ) {
	   amp = AppleCreateMemoryPage();
	   if ( !amp ) 
	      exit(1);
	   MainMemoryRAM[i] = amp;
	}

	for(i=0;i<192;i++){
	   MapReadPage(i,MainMemoryRAM[i]);
	   MapWritePage(i,MainMemoryRAM[i]);
	}

	if (MachineType >=APPLE_IIE){	
	   for(i=0;i<256;i++){
	      amp = AppleCreateMemoryPage();
	      if ( !amp ) 
	         exit(1);
	      AuxMemoryRAM[i] = amp;
	   }
	}

	/*
	 *	initialize ROM
	 *	address $C000-$FFFF
	 */
	for( i = 0x00; i< 0xC0; i++)
	   MainMemoryROM[i]=NULL;

	for( i = 0xC0; i<= 0xFF; i++) {
	   amp = AppleCreateMemoryPage();
	   if ( !amp ) 
	      exit(1);
	   MainMemoryROM[i] = amp;
	}

	if (MachineType < APPLE_IIE)
	   loadROMFile( Apple2ROM );
	else
	   loadROMFile( Apple2eROM );

	for( i = 0; i < 8; i++ ) {
	   expansion_slot_read[i] = NULL;
	   expansion_slot_write[i] = NULL;
	}

#if 1
	for(i=0x02;i<0x100;i++){
	   MapReadPage( i, NULL );
	   MapWritePage( i, NULL );
	   LockReadMappedPage( i, PAGE_LOCK_READ );
	   LockWriteMappedPage( i, PAGE_LOCK_WRITE );
	}

#endif
}

void foo(){}
void	Apple_memory_write( address, data )
ADDR	address;
BYTE	data;
{
	int	page,offset;
	unsigned lock;
	AppleMemoryPage amp;

	address &= 0xFFFF;

	if (address==0x1e&&data==0x3){
	   fprintf(stderr,"gotcha\n");
	   foo();
	}
	   
	/* slow memory write */
	page=address>>8;
	offset=address&0xff;

	switch(page){
	case 0: case 1:
	    amp=(IOUState&SS_ALTZP?AuxMemoryRAM:MainMemoryRAM)[page];
	    ((BYTE*)amp)[offset]=data;
	    return;

	case 4: case 5: case 6: case 7:
	    if (IOUState&SS_80STORE)
	       amp=(IOUState&SS_PAGE2?AuxMemoryRAM:MainMemoryRAM)[page];
	    else
	       amp=(IOUState&SS_RAMWRT?AuxMemoryRAM:MainMemoryRAM)[page];
	    break;

	case 0x20: case 0x21: case 0x22: case 0x23:
	case 0x24: case 0x25: case 0x26: case 0x27:
	case 0x28: case 0x29: case 0x2A: case 0x2B:
	case 0x2C: case 0x2D: case 0x2E: case 0x2F:
	case 0x30: case 0x31: case 0x32: case 0x33:
	case 0x34: case 0x35: case 0x36: case 0x37:
	case 0x38: case 0x39: case 0x3A: case 0x3B:
	case 0x3C: case 0x3D: case 0x3E: case 0x3F:
	   if ((IOUState&(SS_80STORE|SS_HIRES))==(SS_80STORE|SS_HIRES))
	      amp=(IOUState&SS_PAGE2?AuxMemoryRAM:MainMemoryRAM)[page];
	   else
	      amp=(IOUState&SS_RAMWRT?AuxMemoryRAM:MainMemoryRAM)[page];
	   break;

	case 0xC0: case 0xC1: case 0xC2: case 0xC3:
	case 0xC4: case 0xC5: case 0xC6: case 0xC7:
	case 0xC8: case 0xC9: case 0xCA: case 0xCB:
	case 0xCC: case 0xCD: case 0xCE: case 0xCF:
	   AppleIOWrite(address,data);
	   return;

	case 0xD0: case 0xD1: case 0xD2: case 0xD3:
	case 0xD4: case 0xD5: case 0xD6: case 0xD7:
	case 0xD8: case 0xD9: case 0xDA: case 0xDB:
	case 0xDC: case 0xDD: case 0xDE: case 0xDF:
	   if (IOUState&SS_LCRAMWRT){
	      if (!(IOUState&SS_LCBNK2))
	          page-=0x10;
	      amp=(IOUState&SS_ALTZP?AuxMemoryRAM:MainMemoryRAM)[page];
	   }
	   else /* cannot write to ROM */
	       return;
	   break;
	case 0xE0: case 0xE1: case 0xE2: case 0xE3:
	case 0xE4: case 0xE5: case 0xE6: case 0xE7:
	case 0xE8: case 0xE9: case 0xEA: case 0xEB:
	case 0xEC: case 0xED: case 0xEE: case 0xEF:
	case 0xF0: case 0xF1: case 0xF2: case 0xF3:
	case 0xF4: case 0xF5: case 0xF6: case 0xF7:
	case 0xF8: case 0xF9: case 0xFA: case 0xFB:
	case 0xFC: case 0xFD: case 0xFE: case 0xFF:
	   if (IOUState&SS_LCRAMWRT)
	       amp=(IOUState&SS_ALTZP?AuxMemoryRAM:MainMemoryRAM)[page];
	   else /* cannot write to ROM */
	       return;
	   break;
	default: /* RAM exclude ZP, stack, Text Page 1 and Hires Page */
	   amp=(IOUState&SS_RAMWRT?AuxMemoryRAM:MainMemoryRAM)[page];
	}

	/* write data to memroy page */
	((BYTE*)amp)[offset]=data;

	/* check to see if page is locked */
	/* video driver require pages locking */
	lock=GetPageLock(amp)&(PAGE_LOCK_CODE|PAGE_LOCK_WRITE);
	if (lock)
	   UnlockAppleMemoryPage(amp,lock);
}

BYTE Apple_memory_read( address )
ADDR address;
{
	int page, offset;

	/* Mask off any higer bit */
	address &= 0xffff;

	if ( !((unsigned)Read_Page_Table[address>>8] & 3) ) 
	   return Read_Page_Table[address>>8][address&0xff];

	/* slow read */
	page=address>>8;
	offset=address&0xff;

	switch(page){
	case 0: case 1:
	   return ((BYTE*)(IOUState&SS_ALTZP?AuxMemoryRAM:MainMemoryRAM)
	      [page])[offset];

	case 4: case 5: case 6: case 7:
	   if (IOUState&SS_80STORE)
	      return ((BYTE*)(IOUState&SS_PAGE2?AuxMemoryRAM:MainMemoryRAM)
	         [page])[offset];
	   else
	      return ((BYTE*)(IOUState&SS_RAMRD?AuxMemoryRAM:MainMemoryRAM)
	         [page])[offset];

	case 0x20: case 0x21: case 0x22: case 0x23:
	case 0x24: case 0x25: case 0x26: case 0x27:
	case 0x28: case 0x29: case 0x2A: case 0x2B:
	case 0x2C: case 0x2D: case 0x2E: case 0x2F:
	case 0x30: case 0x31: case 0x32: case 0x33:
	case 0x34: case 0x35: case 0x36: case 0x37:
	case 0x38: case 0x39: case 0x3A: case 0x3B:
	case 0x3C: case 0x3D: case 0x3E: case 0x3F:
	   if ((IOUState&(SS_80STORE|SS_HIRES))==(SS_80STORE|SS_HIRES))
	      return ((BYTE*)(IOUState&SS_PAGE2?AuxMemoryRAM:MainMemoryRAM)
	         [page])[offset];
	   else
	      return ((BYTE*)(IOUState&SS_RAMRD?AuxMemoryRAM:MainMemoryRAM)
	         [page])[offset];

	case 0xC0: case 0xC1: case 0xC2: case 0xC3:
	case 0xC4: case 0xC5: case 0xC6: case 0xC7:
	case 0xC8: case 0xC9: case 0xCA: case 0xCB:
	case 0xCC: case 0xCD: case 0xCE: case 0xCF:
	   return AppleIORead(address);

	case 0xD0: case 0xD1: case 0xD2: case 0xD3:
	case 0xD4: case 0xD5: case 0xD6: case 0xD7:
	case 0xD8: case 0xD9: case 0xDA: case 0xDB:
	case 0xDC: case 0xDD: case 0xDE: case 0xDF:
	   if (IOUState&SS_LCRAMRD){
	       if (!(IOUState&SS_LCBNK2))
	          page-=0x10;
	      return ((BYTE*)(IOUState&SS_ALTZP?AuxMemoryRAM:MainMemoryRAM)
	         [page])[offset];
	   }
	   else
	       return ((BYTE*)MainMemoryROM[page])[offset];

	case 0xE0: case 0xE1: case 0xE2: case 0xE3:
	case 0xE4: case 0xE5: case 0xE6: case 0xE7:
	case 0xE8: case 0xE9: case 0xEA: case 0xEB:
	case 0xEC: case 0xED: case 0xEE: case 0xEF:
	case 0xF0: case 0xF1: case 0xF2: case 0xF3:
	case 0xF4: case 0xF5: case 0xF6: case 0xF7:
	case 0xF8: case 0xF9: case 0xFA: case 0xFB:
	case 0xFC: case 0xFD: case 0xFE: case 0xFF:
	   if (IOUState&SS_LCRAMRD)
	       return ((BYTE*)(IOUState&SS_ALTZP?AuxMemoryRAM:MainMemoryRAM)
	          [page])[offset];
	   else
	       return ((BYTE*)MainMemoryROM[page])[offset];

	default: /* RAM exclude ZP, stack, Text Page 1 and Hires Page */
	   return ((BYTE*)(IOUState&SS_RAMRD?AuxMemoryRAM:MainMemoryRAM)
	      [page])[offset];
	}
}
