/*
 * memmap.c
 *
 * memory mapping
 *
 * Change log
 * $Log: memmap.c,v $
 * Revision 1.13  1997/08/09  12:47:47  ctkwan
 * *** empty log message ***
 *
 * Revision 1.13  1997/08/09  12:47:47  ctkwan
 * *** empty log message ***
 *
 * Revision 1.12  1997/08/07  08:13:32  ctkwan
 * fix C800 ROM mapping bug.
 *
 * Revision 1.11  1997/08/06  21:29:04  ctkwan
 * *** empty log message ***
 *
 * Revision 1.10  1997/08/06  19:19:14  ctkwan
 * *** empty log message ***
 *
 * Revision 1.9  1997/08/06  18:56:48  ctkwan
 * fix bug!!! Airheart runs!
 *
 * Revision 1.8  1997/08/06  09:49:49  ctkwan
 * deferred memory mapping change.
 *
 * Revision 1.7  1997/08/05  16:26:29  ctkwan
 * revised memory mapping.
 *
 * Revision 1.6  1997/08/04  16:34:39  ctkwan
 * add $C100-$CEFF direct mapping for read.
 *
 * Revision 1.6  1997/08/04  16:34:39  ctkwan
 * add $C100-$CEFF direct mapping for read.
 *
 * Revision 1.5  1997/08/04  11:42:00  ctkwan
 * correct SLOTCXROM switch semantics.
 *
 * Revision 1.4  1997/08/02  09:30:29  ctkwan
 * *** empty log message ***
 *
 * Revision 1.4  1997/08/02  09:30:29  ctkwan
 * *** empty log message ***
 *
 * Revision 1.3  1997/08/01  18:11:50  ctkwan
 * change Language Card switch to ALTZP.
 *
 * Revision 1.2  1997/08/01  14:24:45  ctkwan
 * *** empty log message ***
 *
 */

#include "hardware.h"
#include "memory.h"
#include "iou.h"

static char rcsid[]="$Id: memmap.c,v 1.13 1997/08/09 12:47:47 ctkwan Exp $";

static int	  RAMReadMapValid=0;
static int	  RAMWriteMapValid=0;
static int	  TextReadMapValid=0;
static int	  TextWriteMapValid=0;
static int	  HiresReadMapValid=0;
static int	  HiresWriteMapValid=0;
static int	  LCReadMapValid=0;
static int	  LCLoWriteMapValid=0;
static int	  LCHiWriteMapValid=0;

static APPLE_TICK RAMReadMapLastChange;
static APPLE_TICK RAMWriteMapLastChange;
static APPLE_TICK TextReadMapLastChange;
static APPLE_TICK TextWriteMapLastChange;
static APPLE_TICK HiresReadMapLastChange;
static APPLE_TICK HiresWriteMapLastChange;
static APPLE_TICK LCReadMapLastChange;
static APPLE_TICK LCLoWriteMapLastChange;
static APPLE_TICK LCHiWriteMapLastChange;

static void unmapReadRange( int, int );
static void unmapWriteRange( int, int );

static void unmapReadRange( int start, int end )
{
	int	page;

	for(page=start;page<=end;page++){
	   MapReadPage(page,NULL);
	   LockReadMappedPage(page,PAGE_LOCK_READ);
	}
}

static void unmapWriteRange( int start, int end )
{
	int	page;

	for(page=start;page<=end;page++){
	   MapWritePage(page,NULL);
	   LockWriteMappedPage(page,PAGE_LOCK_WRITE);
	}
}

/*
 * remapZP:
 *
 * set up zero page and stack memory mapping
 */
void remapZP(void)
{
	AppleMemoryPage test_page, *bank;

	test_page=(void*)((unsigned)Read_Page_Table[0]&~3);
	bank=(GetIOUSoftSwitch()&SS_ALTZP)? AuxMemoryRAM: MainMemoryRAM;
	if (test_page!=bank[0]){
#if defined(DEBUG)
	   printf("remap %s\n", bank==MainMemoryRAM? "STDZP": "ALTZP");
#endif /* DEBUG */
	   MapReadPage( 0, bank[0] );
	   MapReadPage( 1, bank[1] );
	   MapWritePage( 0, bank[0] );
	   MapWritePage( 1, bank[1] );
	}
}

/*
 * remapRAMRead:
 *
 * set up read mapping in region $200-$BFFF except text page 1 $400-$7FF
 * and hires page 1 $2000-$3FFF.
 */
void remapRAMRead(void)
{
	int i;
	AppleMemoryPage test_page, *bank;
	unsigned state;

	state=GetIOUSoftSwitch();

	if (RAMReadMapValid){
	    unmapReadRange(0x02,0x03);
	    unmapReadRange(0x08,0x1F);
	    unmapReadRange(0x40,0xBF);
	    RAMReadMapValid=0;
	    RAMReadMapLastChange=AppleClock;
	    return;
	}

	if (AppleClock-RAMReadMapLastChange<156000){
	    return;	
	}

	bank=state&SS_RAMRD? AuxMemoryRAM : MainMemoryRAM;
	test_page=(void*)((unsigned)Read_Page_Table[2]&~3);
	if (test_page!=bank[2]){
#ifdef DEBUG
	   printf("remamp %s RAM for read at %d\n",
	      state&SS_RAMRD? "aux":"main",AppleClock);
#endif
	   MapReadPage( 2, bank[2]);
	   MapReadPage( 3, bank[3]);
	   for(i=0x08;i<0x20;i++)
	      MapReadPage( i, bank[i]);
	   for(i=0x40;i<0xc0;i++)
	      MapReadPage( i, bank[i]);
	}
	RAMReadMapValid=1;
	RAMReadMapLastChange=AppleClock;
}

/*
 * remapRAMWrite:
 *
 * set up write mapping in region $200-$BFFF except text page 1 $400-$7FF
 * and hires page 1 $2000-$3FFF.
 */
void remapRAMWrite(void)
{

	int i;
	AppleMemoryPage test_page, *bank;
	unsigned state;

	state=GetIOUSoftSwitch();

	if (RAMWriteMapValid){
	    unmapWriteRange(0x02,0x03);
	    unmapWriteRange(0x08,0x1F);
	    unmapWriteRange(0x40,0xBF);
	    RAMWriteMapValid=0;
	    RAMWriteMapLastChange=AppleClock;
	    return;
	}

	if (AppleClock-RAMWriteMapLastChange<156000){
	    return;	
	}

	bank=state&SS_RAMWRT? AuxMemoryRAM : MainMemoryRAM;
	test_page=(void*)((unsigned)Write_Page_Table[2]&~3);
	if (test_page!=bank[2]){
#ifdef DEBUG
           printf("remap %s RAM for write\n",state&SS_RAMWRT?"aux":"main");
#endif
	   MapWritePage( 2, bank[2]);
	   MapWritePage( 3, bank[3]);
	   for(i=0x08;i<0x20;i++)
	      MapWritePage( i, bank[i]);
	   for(i=0x40;i<0xc0;i++)
	      MapWritePage( i, bank[i]);
	}
	RAMWriteMapValid=1;
	RAMWriteMapLastChange=AppleClock;
}

/*
 * remapText:
 *
 * set up read memory mapping in text page 1 $400-$7FF.
 */
void remapTextRead(void)
{
	int i;
	AppleMemoryPage test_page, *bank;
	unsigned state;

	state=GetIOUSoftSwitch();

	if (TextReadMapValid){
	    unmapReadRange(0x04,0x07);
	    TextReadMapValid=0;
	    TextReadMapLastChange=AppleClock;
	    return;
	}

	if (AppleClock-TextReadMapLastChange<400){
	    return;
	}

	if (state & SS_80STORE)
	   bank=state&SS_PAGE2? AuxMemoryRAM : MainMemoryRAM;
	else
	   bank=state&SS_RAMRD? AuxMemoryRAM : MainMemoryRAM;

	test_page=(void*)((unsigned)Read_Page_Table[4]&~3);
	if (test_page!=bank[4]){
#ifdef DEBUG
	   printf("remap %s Text for read at %d\n",bank==AuxMemoryRAM?
	      "aux":"main",AppleClock);
#endif
	   for(i=0x04;i<0x08;i++)
	      MapReadPage( i, bank[i] );
	}

	TextReadMapValid=1;
	TextReadMapLastChange=AppleClock;
}


/*
 * remapTextWrite:
 *
 * set up write memory mapping in text page 1 $400-$7FF.
 */
void remapTextWrite(void)
{
	int i;
	AppleMemoryPage test_page, *bank;
	unsigned state;

	state=GetIOUSoftSwitch();

	if (TextWriteMapValid){
	    unmapWriteRange(0x04,0x07);
	    TextWriteMapValid=0;
	    TextWriteMapLastChange=AppleClock;
	    return;
	}

	if (AppleClock-TextWriteMapLastChange<400){
	    return;
	}

	if (state & SS_80STORE)
	   bank=state&SS_PAGE2? AuxMemoryRAM : MainMemoryRAM;
	else
	   bank=state&SS_RAMWRT? AuxMemoryRAM : MainMemoryRAM;

	test_page=(void*)((unsigned)Write_Page_Table[4]&~3);
	if (test_page!=bank[4]){
#ifdef DEBUG
	   printf("remap %s Text for write at %d\n",bank==AuxMemoryRAM?
	      "aux":"main",AppleClock);
#endif
	   for(i=0x04;i<0x08;i++)
	      MapWritePage( i, bank[i] );
	}
	TextWriteMapValid=1;
	TextWriteMapLastChange=AppleClock;
}


/*
 * remapHiresRead:
 *
 * set up read memory mapping in text page 1 $2000-$3FFF.
 */
void remapHiresRead(void)
{
	int i;
	AppleMemoryPage test_page, *bank;
	unsigned state;

	state=GetIOUSoftSwitch();

	if (HiresReadMapValid){
	    unmapReadRange(0x20,0x3F);
	    HiresReadMapValid=0;
	    HiresReadMapLastChange=AppleClock;
	    return;
	}

	if (AppleClock-HiresReadMapLastChange<32000){
	    return;	
	}

	if ((state & (SS_80STORE|SS_HIRES)) == (SS_80STORE|SS_HIRES))
	   bank=state&SS_PAGE2? AuxMemoryRAM : MainMemoryRAM;
	else
	   bank=state&SS_RAMRD? AuxMemoryRAM : MainMemoryRAM;

	test_page=(void*)((unsigned)Read_Page_Table[0x20]&~3);
	if (test_page!=bank[0x20]){
#ifdef DEBUG
	   printf("remap %s Hires for read\n",bank==AuxMemoryRAM?
	      "aux":"main");
#endif
	   for(i=0x20;i<0x40;i++)
	      MapReadPage( i, bank[i] );
	}

	HiresReadMapValid=1;
	HiresReadMapLastChange=AppleClock;
}

/*
 * remapHiresWrite:
 *
 * set up write memory mapping in text page 1 $2000-$3FFF.
 */
void remapHiresWrite(void)
{
	int i;
	AppleMemoryPage test_page, *bank;
	unsigned state;

	state=GetIOUSoftSwitch();

	if (HiresWriteMapValid){
	    unmapWriteRange(0x20,0x3F);
	    HiresWriteMapValid=0;
	    HiresWriteMapLastChange=AppleClock;
	    return;
	}

	if (AppleClock-HiresWriteMapLastChange<32000){
	    return;	
	}

	if ((state & (SS_80STORE|SS_HIRES)) == (SS_80STORE|SS_HIRES))
	   bank=state&SS_PAGE2? AuxMemoryRAM : MainMemoryRAM;
	else
	   bank=state&SS_RAMWRT? AuxMemoryRAM : MainMemoryRAM;

	test_page=(void*)((unsigned)Write_Page_Table[0x20]&~3);
	if (test_page!=bank[0x20]){
#ifdef DEBUG
	   printf("remap %s Hires for write\n",bank==AuxMemoryRAM?
	      "aux":"main");
#endif
	   for(i=0x20;i<0x40;i++)
	      MapWritePage( i, bank[i] );
	}

	HiresWriteMapValid=1;
	HiresWriteMapLastChange=AppleClock;
}

/*
 * remapCXROM
 * set up memory mapping in region $C000-$CXXX
 */
void remapCXROM(void)
{
	int i;
	unsigned state;

	return;
	state=GetIOUSoftSwitch();

	/* $C100-$C7FF */
	if (state&SS_SLOTCXROM){
	   for(i=0xC1;i<0xC8;i++)
	      MapReadPage(i, MainMemoryROM[i]);
	}
	else {
	   for(i=0xC1;i<0xC8;i++) {
	      if (i!=0xC3||(state&SS_SLOTC3ROM)) {
	         MapReadPage(i,NULL);
	         LockReadMappedPage(i,PAGE_LOCK_READ);
	      }
	      else { /* 80 column firmware at $C3XX */
	         if (0&state&SS_EXPNROM) 
	            MapReadPage(0xC3,MainMemoryROM[0xC3]);
	         else { /* subsequent read will trap and map C800 */
	            MapReadPage(0xC3,NULL);
	            LockReadMappedPage(0xC3,PAGE_LOCK_READ);
	         }
	      }
	   }
	}

	/* $C800-$CFFF */
	if ((state&SS_SLOTCXROM)||(state&SS_EXPNROM)){ /* internal ROM */
#ifdef DEBUG
	   printf("map $C800-$CEFF internal ROM\n");
#endif
	   for(i=0xC8;i<0xCF;i++)
	      MapReadPage( i, MainMemoryROM[i]);
	}
	else{
	   for(i=0xC8;i<0xCF;i++){
	      MapReadPage(i,NULL);
	      LockReadMappedPage(i,PAGE_LOCK_READ);
	   }
	}
}

/*
 * remapLCRead:
 *
 * set up read memory mapping in region $D000-$FFFF
 */
void remapLCRead(void)
{
	int i;
	AppleMemoryPage test_page, *bank;
	unsigned state;

	state=GetIOUSoftSwitch();

	if (LCReadMapValid){
	    unmapReadRange(0xD0,0xFF);
	    LCReadMapValid=0;
	    LCReadMapLastChange=AppleClock;
	    return;
	}
	return;

	if (AppleClock-LCReadMapLastChange<4800){
	    LCReadMapLastChange=AppleClock;
	    return;
	}

	/* map address $D000-$DFFF for read */	
	if (state & SS_LCRAMRD) {
	   bank=state & SS_ALTZP? &AuxMemoryRAM[0xC0]: &MainMemoryRAM[0xC0];
	   if (state & SS_LCBNK2)
	      bank+=16;
	}
	else
	   bank=&MainMemoryROM[0xD0];

	test_page=(void*)((unsigned)Read_Page_Table[0xD0]&~3);
	if (test_page!=bank[0x00]){
#ifdef DEBUG
	   printf("remmap $D000-$DFFF %s for read\n",
	      state&SS_LCRAM?(state&SS_ALTZP?"aux RAM":"main RAM"):"ROM");
#endif
	   for(i=0;i<0x10;i++)
	      MapReadPage(i+0xD0,bank[i]);
	}

	/* map address $E000-$FFFF */
	bank=(state & SS_LCRAMRD) ?
	   (state & SS_ALTZP? AuxMemoryRAM: MainMemoryRAM):
	   MainMemoryROM;

	test_page=(void*)((unsigned)Read_Page_Table[0xE0]&~3);
	if (test_page!=bank[0xE0]){
#ifdef DEBUG
	   printf("remmap $E000-$FFFF %s for read\n",
	      state&SS_LCRAM?(state&SS_ALTZP?"aux RAM":"main RAM"):"ROM");
#endif
	   for(i=0xE0;i<=0xFF;i++)
	      MapReadPage(i,bank[i]);
	}
	LCReadMapValid=1;
	LCReadMapLastChange=AppleClock;
}

/*
 * remapLCLoWrite:
 *
 * set up write memory mapping in region $D000-$FFFF
 * 1. forced remmaping always work.
 * 2. slow access mode does not work!
 */
void remapLCLoWrite(void)
{
	int i;
	AppleMemoryPage test_page, *bank;
	unsigned state;

	state=GetIOUSoftSwitch();

	if (LCLoWriteMapValid){
	    unmapWriteRange(0xD0,0xDF);
	    LCLoWriteMapValid=0;
	    LCLoWriteMapLastChange=AppleClock;
	    return;
	}

	if (AppleClock-LCLoWriteMapLastChange<1600){
	    return;	
	}

	/* map address $D000-$DFFF for write */	
	if (state & SS_LCRAMWRT) {
	   bank=(state & SS_ALTZP)? &AuxMemoryRAM[0xC0]: &MainMemoryRAM[0xC0];
	   if (state & SS_LCBNK2)
	      bank+=16;
	}
	else
	   bank=NULL;
	test_page=(void*)((unsigned)Write_Page_Table[0xD0]&~3);
	if (test_page!=(bank?bank[0x00]:GetNullPage())){
#ifdef DEBUG
	   printf("remmap $D000-$DFFF %s for write\n",
	      bank?((state&SS_ALTZP)?"aux RAM":"main RAM"):"ROM");
#endif
	   if (bank)
	      for(i=0;i<0x10;i++)
	         MapWritePage(i+0xD0,bank?bank[i]:NULL);
	   else
	      for(i=0xD0;i<0xE0;i++)
	         MapWritePage(i,NULL);
	}

	LCLoWriteMapValid=1;
	LCLoWriteMapLastChange=AppleClock;
}

/*
 * remapLCWrite:
 *
 * set up write memory mapping in region $D000-$FFFF
 *
 * 1. forced remapping allways work.
 * 2. Slow acess mode does not work.
 */
void remapLCHiWrite(void)
{
	int i;
	AppleMemoryPage test_page, *bank;
	unsigned state;

	state=GetIOUSoftSwitch();

	if (LCHiWriteMapValid){
	    unmapWriteRange(0xE0,0xFF);
	    LCHiWriteMapValid=0;
	    LCHiWriteMapLastChange=AppleClock;
	    return;
	}

	if (AppleClock-LCHiWriteMapLastChange<3200){
	    return;	
	}

	bank=(state & SS_LCRAMWRT) ?
	   ((state & SS_ALTZP)? AuxMemoryRAM: MainMemoryRAM): NULL;
	test_page=(void*)((unsigned)Write_Page_Table[0xE0]&~3);
	if (test_page!=(bank?bank[0xE0]:GetNullPage())){
#ifdef DEBUG
	   printf("remmap $E000-$FFFF %s for write\n",
	      bank?(state&SS_ALTZP?"aux RAM":"main RAM"):"ROM");
#endif
	   if (bank)
	      for(i=0xE0;i<=0x100;i++)
	         MapWritePage(i,bank[i]);
	   else
	      for(i=0xE0;i<=0x100;i++)
	         MapWritePage(i,NULL);
	}

	LCHiWriteMapValid=1;
	LCHiWriteMapLastChange=AppleClock;
}

void mmuMicrojob(void*args)
{
	/* check segments one by one */
	if (!RAMReadMapValid)
	   remapRAMRead(); 

	if (!RAMWriteMapValid)
	   remapRAMWrite(); 

	if (!TextReadMapValid)
	   remapTextRead(); 

	if (!TextWriteMapValid)
	   remapTextWrite(); 

	if (!HiresReadMapValid)
	   remapHiresRead(); 

	if (!HiresWriteMapValid)
	   remapHiresWrite(); 

	if (!LCReadMapValid)
	   remapLCRead();

	if (!LCLoWriteMapValid)
	   remapLCLoWrite();

	if (!LCHiWriteMapValid)
	   remapLCHiWrite();

	submit_micro_job( AppleClock+1000, mmuMicrojob, NULL );
}
