/*
 * Apple II ROM loader
 *
 */
static char rcsid[]="$Id: loadrom.c,v 1.3 1997/08/11 02:44:57 ctkwan Exp $";

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/stat.h>

#include "hardware.h"
#include "memory.h"
#include "yae.h"

#define XXXX -1	/* don't care */

typedef struct {
	char	*machine_name;
	int	loc_FBB3;
	int	loc_FB1E;
	int	loc_FBC0;
	int	loc_FBDD;
	int	loc_FBBE;
	int	loc_FBBF;

	/*
	 * C800 is not in the official family identification but some
	 * ROM images of IIe or IIc have two copy of the ROM in $D000-$FFFF
	 * and just one copy of the internal ROM in $C100-CFFF. This is
	 * added to circumvent this problem. May not work.
	 */
	int	loc_C800;

	int	start;
	int	size;
} AppleROMSignature;

/*
 * ROM signatures for Apple II family from Apple ][ to Apple IIc Plus
 * Note: this does not include the IIgs
 */

#define NO_OF_MACHINES	11

AppleROMSignature	AppleIIFamilySignature[NO_OF_MACHINES]={
	/*FBB3  FB1E  FBC0  FBDD  FBBE  FBBF  C800 */
	{ "Apple ][",
          0x38, XXXX, XXXX, XXXX, XXXX, XXXX, XXXX, 0xD000, 0x3000 },
	{ "Apple ][+",
	  0xEA, 0xAD, XXXX, XXXX, XXXX, XXXX, XXXX, 0xD000, 0x3000 },
	{ "Apple /// (emulation)",
	  0xEA, 0x8A, XXXX, XXXX, XXXX, XXXX, XXXX, 0xD000, 0x3000 },
	{ "Apple IIe",
	  0x06, XXXX, 0xEA, XXXX, XXXX, XXXX, XXXX, 0xC100, 0x3F00 },
	{ "Apple IIe (enhanced)",
	  0x06, XXXX, 0xE0, XXXX, XXXX, XXXX, 0x4C, 0xC100, 0x3F00 },
	{ "Apple IIe Option Card",
	  0x06, XXXX, 0xE0, 0x02, 0x00, XXXX, XXXX, 0xC100, 0x3F00 },
	{ "Apple IIc",
	  0x06, XXXX, 0x00, XXXX, XXXX, 0xFF, XXXX, 0xC100, 0x3F00 },
	{ "Apple IIc (3.5 ROM)",
	  0x06, XXXX, 0x00, XXXX, XXXX, 0x00, XXXX, 0xC100, 0x3F00 },
	{ "Apple IIc (Org. Mem. Exp.)",
	  0x06, XXXX, 0x00, XXXX, XXXX, 0x03, XXXX, 0xC100, 0x3F00 },
	{ "Apple IIc (Rev. Mem. Exp.)",
	  0x06, XXXX, 0x00, XXXX, XXXX, 0x04, XXXX, 0xC100, 0x3F00 },
	{ "Apple IIc Plus",
	  0x06, XXXX, 0x00, XXXX, XXXX, 0x05, XXXX, 0xC100, 0x3F00 }};

int checkROMFile(char *fname, int *offset, int *start, int *size )
{
	BYTE buf[256];
	FILE	 *fp;
	int i, val, pos, head, tail;
	struct stat	stat_buf;

	if (stat(fname,&stat_buf)){
	   fprintf(stderr,"checkROMFile: Cannot stat file %s\n",fname);
	   return -1;
	}

	fp=fopen(fname,"r");
	if (!fp) {
	   fprintf(stderr,"checkROMFile: Cannot open file %s\n",fname);
	   return -1;
	}

	while(fread(buf,256,1,fp)){
	   for(i=0;i<NO_OF_MACHINES;i++){
	      val=AppleIIFamilySignature[i].loc_FBB3;
	      if (val != XXXX && buf[0xB3]!=val)
	         continue;
	      val=AppleIIFamilySignature[i].loc_FB1E;
	      if (val != XXXX && buf[0x1E]!=val)
	         continue;
	      val=AppleIIFamilySignature[i].loc_FBC0;
	      if (val != XXXX && buf[0xC0]!=val)
	         continue;
	      val=AppleIIFamilySignature[i].loc_FBDD;
	      if (val != XXXX && buf[0xDD]!=val)
	         continue;
	      val=AppleIIFamilySignature[i].loc_FBBF;
	      if (val != XXXX && buf[0xBE]!=val)
	         continue;

	      /* check size */
	      pos=ftell(fp)-0x100;
	      head=pos-(0xFB00-AppleIIFamilySignature[i].start);
	      tail=head + AppleIIFamilySignature[i].size;

	      if ( head < 0 || tail >stat_buf.st_size )
	         break;

	      /* roll back to check $C800 */
	      val=AppleIIFamilySignature[i].loc_C800;
	      if (val != XXXX ) {
	         fseek( fp, 0xC800-0xFC00, SEEK_CUR );
	         fread( buf, 256, 1, fp );
	         fseek( fp, pos+0x100, SEEK_SET );
	         if (val != XXXX && buf[0x00]!=val)
	            continue;
	      }
	 
	      /* got a match */
#ifdef DEBUG
	      printf("found %s ROM\n", AppleIIFamilySignature[i].machine_name);
	      printf("head=%d, tail=%d file size %u\n",head,tail,
	         stat_buf.st_size);
#endif
	      if (head>=0 && tail<=stat_buf.st_size) {
	         *offset=head;
	         *size=AppleIIFamilySignature[i].size;
	         *start=AppleIIFamilySignature[i].start;
	         fclose(fp);
	         return 0;
	      }
	      continue;
	      break;
	    }
	}
	fclose(fp);
	return -1;
}

int loadROMFile(char *fname)
{
	int offset, start, size, page, n;
	FILE	*fp;

	if (checkROMFile(fname, &offset, &start, &size)){
	   return -1;
	}

	page=start>>8;
	n=size>>8;
	fp=fopen(fname,"r");
	if (!fp) {
	   fprintf(stderr,"loadROMFile: cannot open %s\n", fname );
	   return -1;
	}

	fseek(fp,offset,SEEK_SET);
	while(n){
	   if (page<0x100)
	      fread(MainMemoryROM[page],1,256,fp);
	   page++;
	   n--;
	}	
	fclose(fp);
	return 0;
}
