#include <stdio.h>
#include "hardware.h"
#include "6502.h"

#define MAX_QUEUE_SIZE	16

struct {
	void	(*handler)(AppleCPUContextStruct*,void*);
	void	*arg;
} EmulationTrapQueue[MAX_QUEUE_SIZE];

int EmulationTrapQueueSize=0;

int RaiseEmulationException(void (*handler)(AppleCPUContextStruct*,void*),
	void* arg)
{
	if (EmulationTrapQueueSize==MAX_QUEUE_SIZE){
	   fprintf(stderr,"EmulationTrap: queue full\n");
	   return -1;
	}

	EmulationTrapQueue[EmulationTrapQueueSize].handler=handler;
	EmulationTrapQueue[EmulationTrapQueueSize].arg=arg;
	EmulationTrapQueueSize++;

	Signal6502(SIG_6502_EMULATION);
	return 0;
}

void ServiceEmulationException(AppleCPUContextStruct *context)
{
	int i;

	for(i=0;i<EmulationTrapQueueSize;i++)
	    (*EmulationTrapQueue[i].handler)(context,
	       EmulationTrapQueue[i].arg);
	EmulationTrapQueueSize=0;
}
