/*
 * confile.c
 *
 * yae configuration file processing
 * by Warren Toomey <wkt@cs.adfa.edu.au>
 *
 * $Log$
 */
static char rcsid[]="$Id$";

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "hardware.h"

/* Simple routines to handle .yaerc config file and command-line inputs */


typedef struct var {
	char *name;			/* Name of variable, or comment */
					/* or NULL if it has been deleted */
	char *value;			/* Variable's value */
} VAR;

#define LISTSIZE	100		/* Surely won't need more than this */
VAR varlist[LISTSIZE];			/* List of variables */
int varcnt=0;				/* Number of variables */

/* External variables required */
extern char *Apple2ROM;
extern char *Apple2eROM;
extern char *DiskROM;
extern FILE *printstream;
extern int Default_Speed;
extern int MachineType;

/* Find a variable's value and position */
/* If no value, return NULL */
static char *FindValue(char *name, int *pos)
{
  int i;

  if (name==NULL) return(NULL);
  for (i=0; i<varcnt; i++) {
    if (!strcmp(name, varlist[i].name)) { 
	if (pos) *pos=i;		/* Save position */
	return varlist[i].value;
    }
  }
  return(NULL);
}

/* The public version of the routine */
char *FindVal(char *name)
{
  return(FindValue(name, NULL));
}

/* Add a comment, a new value, or overwrite an existing value */
void AddVar(char *name, char *value)
{
  int p;

  if (name==NULL) return;
  if (varcnt>=LISTSIZE) return;

  if (*name=='#') {			/* Comment, append */
     varlist[varcnt].name=strdup(name);
     varlist[varcnt++].value=NULL;
     return;
  }

  if (FindValue(name, &p)==NULL) {	/* Try & find existing value */
     varlist[varcnt].name=strdup(name); /* Nope, just append */
     if (value==NULL) varlist[varcnt].value=NULL;
     else varlist[varcnt].value=strdup(value);
     varcnt++;
  } else {				/* Overwrite old value */
     if (varlist[p].value!=NULL) free(varlist[p].value);
     varlist[p].value=strdup(value);
  }
}

/* Delete a variable */
void DelVar(char *name)
{
  int p;

  if (FindValue(name, &p)!=NULL) {	/* Try & find existing value */
     if (varlist[p].name!=NULL) free(varlist[p].name);
     if (varlist[p].value!=NULL) free(varlist[p].value);
     varlist[p].name=NULL; varlist[p].value=NULL;
  }
}

/* Open and parse the configuration file, setting global variables as
 * we go, and/or warning of errors in the values and names. The command
 * line variables are done after we read the config file, and several of
 * the main variables have been initialised before we get here, but not
 * recorded in the var array above.
 */
#define YAERC ".yaerc"		/* Should be in a header file I guess */
#define SBUFSIZE 100
void ParseConfigFile(void)
{
 FILE *zin;
 char *h, *v, cfile[SBUFSIZE], line[SBUFSIZE];
 int speed;

 /* Try .yaerc first, then try $HOME/.yaerc if we can't find .yaerc */
 strcpy(cfile, YAERC);
 zin=fopen(cfile, "r");
 if (zin==NULL) {
    h=getenv("HOME");
    if (h==NULL) return;	/* No HOME, give up */

    /* ctkwan: at least IRIX 5.3 does not have snprintf */
#ifdef HAVE_SNPRINTF
    snprintf(cfile, SBUFSIZE, "%s/%s", h, YAERC);
#else /* HAVE_SNPRINTF */
    sprintf(cfile, "%s/%s", h, YAERC);
#endif

    zin=fopen(cfile, "r");
    if (zin==NULL) return;	/* No $HOME/.yaerc either, give up */
 }

 while (fgets(line, SBUFSIZE, zin)) {	/* Get a line */
    line[strlen(line)-1]='\0';		/* Trim the newline char */
    if (*line=='#') { AddVar(line,NULL); continue; }

					/* Find the start of the variable */
    v=line;
    while ((*v==' ') || (*v=='\t')) v++;
    if (*v=='\0') continue;		/* Hmm, blank line */
					/* Find the end of the variable */
    h=v;
    while ((*h!=' ') && (*h!='\t') && (*h!='\0')) h++;
    if (*h=='\0') { h=NULL; }		/* No variable value */
    else {				/* Skip any leading whitespace */
      *h='\0'; h++;			/* Break line */
      while ((*h==' ') || (*h=='\t')) h++;
      if (*h=='\0') { h=NULL; }		/* Again, no variable */
    }
    if (h==NULL) {
	fprintf(stderr, "No value in %s for %s\n", cfile,v);
 	continue;
    }
    AddVar(v,h);			/* Save name and value */

					/* Now use values to set globals */
					/* For the `string' variables, we */
					/* could probably set up an array */
					/* containing the names, and the */
					/* char * pointers to the globals */
					/* This would save code */
    if (!strcmp(v, "Apple2ROM")) {
      Apple2ROM= FindVal("Apple2ROM"); continue;
    }
    if (!strcmp(v, "Apple2eROM")) {
      Apple2eROM= FindVal("Apple2eROM"); continue;
    }
    if (!strcmp(v, "DiskROM")) {
      DiskROM= FindVal("DiskROM"); continue;
    }
		/* Hmm, we probably should parse the slot and drive */
		/* numbers, and store the name in a 2-d array */
		/* We would have to modify disk2.c to keep the 2-d array */
		/* and the 2-d array of FILE pointers. Both in a struct? */
    if (!strcmp(v, "DiskS6D1")) {
      disk_name[6][0]= FindVal("DiskS6D1"); continue;
    }
    if (!strcmp(v, "DiskS6D2")) {
      disk_name[6][1]= FindVal("DiskS6D2"); continue;
    }
    if (!strcmp(v, "DiskS5D1")) {
      disk_name[5][0]= FindVal("DiskS5D1"); continue;
    }
    if (!strcmp(v, "DiskS5D2")) {
      disk_name[5][1]= FindVal("DiskS5D2"); continue;
    }
    if (!strcmp(v, "Printer")) {
      printstream= fopen(h, "a");
      if (printstream==NULL) {
	fprintf(stderr, "Could not open printer file %s\n", h);
	printstream=stdout;
      }
      continue;
    }
    if (!strcmp(v, "Speed")) {
      speed=atoi(h);
      if (speed<1000)
	fprintf(stderr, "Bad Speed value in %s\n",cfile);
      else Default_Speed=speed;
      continue;
    }
    if (!strcmp(v, "MachineType")) {
      if (!strcmp(h,"IIe")) { MachineType=APPLE_IIE; }
      else if (!strcmp(h,"II+")) { MachineType=APPLE_II_PLUS; }
      else fprintf(stderr,"Unknown MachineType %s in %s\n",h,cfile);
      continue;
    }
    if (!strcmp(v, "RunningMan")) { 
      if (!strcmp(h,"TRUE")) { RunningMan=TRUE; }
      else if (!strcmp(h,"FALSE")) { RunningMan=FALSE; }
      else fprintf(stderr,"Unknown RunningMan value %s in %s\n",h,cfile);
      continue;
    }
    if (!strcmp(v, "UseXShm")) {
      if (!strcmp(h,"TRUE")) { UseXShm=TRUE; }
      else if (!strcmp(h,"FALSE")) { UseXShm=FALSE; }
      else fprintf(stderr,"Unknown UseXShm value %s in %s\n",h,cfile);
      continue;
    }
 }
 fclose(zin);
}
