#ifndef	_6502_H_
#define	_6502_H_

#define	SIG_6502_SHUTDOWN	(1<<0)
#define	SIG_6502_RES		(1<<1)
#define	SIG_6502_NMI		(1<<2)
#define	SIG_6502_IRQ		(1<<3)
#define	SIG_6502_TIMER		(1<<4)
#define	SIG_6502_CONTEXT	(1<<5)
#define	SIG_6502_MEMORY		(1<<6)
#define	SIG_6502_EMULATION	(1<<7)

typedef	struct	{
	ADDR	PC;
	BYTE	A;
	BYTE	X;
	BYTE	Y;
	BYTE	P;
	BYTE	S;
	} AppleCPUContextStruct;

/* P register flags */
#define N_BIT	(1<<7)
#define V_BIT	(1<<6)
/*
 *	owing to a bug in 6502, the bit 5 must be always 1;
 *	otherwise, programs like DOS 3.3 will break down
 *	see instructions in $9FF4-$9FF5 of DOS 3.3
 */
#define B_BIT	(1<<4)
#define D_BIT	(1<<3)
#define I_BIT	(1<<2)
#define Z_BIT	(1<<1)
#define C_BIT	(1<<0)

/* function prototypes */
void init_6502(void);
void assert_RES(void);
void assert_NMI(void);
void assert_IRQ(void);
void shutdown_6502(void);
void set_next_timer_exception( APPLE_TICK );
void set_trace(void);
void Signal6502( unsigned );
int CPUExecute( AppleCPUContextStruct* );

#endif	/* _6502_H_ */
