/*
 *	x_window.c
 *	X Window initializations
 */
static char rcsid[]="$Id: x_window.c,v 1.4 1997/08/06 09:49:49 ctkwan Exp ctkwan $";

#define	_X_WINDOW_C_

#include <stdio.h>
#include <ctype.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/keysym.h>
#include <X11/extensions/XShm.h>

#include "hardware.h"
#include "x_window.h"
#include "6502.h"
#include "yae.h"

#ifdef	MOTIF
#include <X11/Intrinsic.h>
extern	Widget	DrawingArea;

#endif
#define	LEFT_APPLE_KEY	1
#define	RIGHT_APPLE_KEY	2
#define	DISK_DRIVE_KEY	3


static void X_check_and_handle_event(void);
static BYTE Apple_Key( XEvent * );

void init_X(void)
{
	XSetWindowAttributes	set_win_attr;
	long			win_attr_mask;
	XSizeHints		the_size_hints;
	XGCValues		the_GC_value;

#ifdef MOTIF
	theDisplay = XtDisplay( DrawingArea );
	theWindow = XtWindow( DrawingArea );
	theScreen = XScreenNumberOfScreen( XtScreen( DrawingArea ) );
#else
	
	theDisplay = XOpenDisplay( NULL );
	if ( !theDisplay ) {
	   fprintf( stderr, "Cannot open display\n" );
	   exit(1);
	}
	theScreen = DefaultScreen( theDisplay );
#endif

	theRootWindow = RootWindow( theDisplay, theScreen );
	theBlackPixel = BlackPixel( theDisplay, theScreen );
	theWhitePixel = WhitePixel( theDisplay, theScreen );
	theScreenDepth = DefaultDepth( theDisplay, theScreen );

#ifndef	MOTIF
	set_win_attr.border_pixel = theWhitePixel;
	set_win_attr.backing_pixel = theBlackPixel;
	set_win_attr.override_redirect = 0;
	win_attr_mask = CWBorderPixel | CWBackingPixel | 
	   CWOverrideRedirect;

	theWindow = XCreateWindow( theDisplay, theRootWindow,
		0, 0, SCREEN_WIDTH, SCREEN_HEIGHT, 
		1, DefaultDepth( theDisplay, theScreen ),
		InputOutput, CopyFromParent, win_attr_mask, &set_win_attr );

	/*
	 * Select input
	 */
	XSelectInput( theDisplay, theWindow,
	   KeyPressMask | 
	   KeyReleaseMask | 
	   ExposureMask | 
	   ButtonPressMask |
	   ButtonReleaseMask |
	   StructureNotifyMask );

	/*
	 * Set size hints & Properties
	 */
	the_size_hints.width = SCREEN_WIDTH; 
	the_size_hints.height = SCREEN_HEIGHT;
	the_size_hints.max_width = SCREEN_WIDTH;
	the_size_hints.max_height = SCREEN_HEIGHT;
	the_size_hints.min_width = SCREEN_WIDTH;
	the_size_hints.min_height = SCREEN_HEIGHT;
	the_size_hints.flags = PSize | PMaxSize | PMinSize;
	XSetStandardProperties( theDisplay, theWindow,
		"Apple ][", "Apple ][",
		None, 0, 0,  &the_size_hints );

#endif

	/*
	 *	Create a GC for the Apple Window
	 */
	the_GC_value.function = GXcopy;
	the_GC_value.foreground = theWhitePixel;
	the_GC_value.background = theBlackPixel;
	the_GC_value.fill_style = FillSolid;
	theGC = XCreateGC( theDisplay, theWindow,
		GCFunction | GCForeground | GCBackground | GCFillStyle,
		&the_GC_value );

#if 0
	/*
	 *	Check if backing store is availalable
	 */
	HasBackingStore = DoesBackingStore( ScreenOfDisplay( theDisplay,
	   theScreen ) );

	set_win_attr.backing_store = HasBackingStore;
	win_attr_mask = CWBackingStore;
	XChangeWindowAttributes( theDisplay, theWindow, win_attr_mask,
	   &set_win_attr );
#endif

#ifndef	MOTIF
	/*
	 * Map the Window so the it can be seen
	 */
	XMapWindow( theDisplay, theWindow );
	XFlush( theDisplay );
#endif

	/*
	 * startup micro job for X window
	 */
	submit_micro_job( AppleClock + REFRESH_INTERVAL, 
	   X_check_and_handle_event, NULL );
}

void quit_X(void)
{

	cleanupScreenImage();
	XDestroyWindow( theDisplay, theWindow );
	XCloseDisplay( theDisplay );
}

void	X_check_and_handle_event()
{
	XEvent		event;
	int		count;
	BYTE		key, Apple_Key();
	char		buffer[256];

	if ( Video_Dirty ) {
	   XFlush( theDisplay );
	   Video_Dirty = 0;
	}

#ifndef	MOTIF
	for( count = XPending( theDisplay ); count > 0; count-- ) {
	   XNextEvent( theDisplay, &event );
	   switch( event.xany.type ) {
	      case KeyPress:
	         key = Apple_Key( &event );
	         if ( key & 0x80 ) /* normal keystrokes */
	            recordKeyEvent( key, AppleClock, TRUE );
	         else 
	            switch( key ) {
	            case LEFT_APPLE_KEY:
	            case RIGHT_APPLE_KEY:
	               press_apple_key( key );
	               break;
	            case DISK_DRIVE_KEY:
	               puts( "Mount new disk\n" );
	               buffer[0] = '\0';
	               fgets( buffer, 256, stdin );
	               if (buffer[0]) 
	                  buffer[strlen( buffer ) - 1 ] = '\0';
	               mount_disk( 6, 1, buffer );
	            }
	         break;
	      case KeyRelease:
	         key = Apple_Key( &event );
	         if ( key & 0x80 ) /* normal keystrokes */
	            recordKeyEvent( key, AppleClock, FALSE );
	         else
	            switch( key ) {
	            case LEFT_APPLE_KEY:
	            case RIGHT_APPLE_KEY:
	               release_apple_key( key );
	               break;
	            }
	         break; 
	      case ButtonPress:
	         press_button( event.xbutton.button - 1 );
	         break;
	      case ButtonRelease:
	         release_button( event.xbutton.button - 1 );
	         break;
	      case Expose:
	         if ( event.xexpose.count == 0 )
#if 0
	            Refresh_Screen( 0, 23 );
#endif
	            refreshScreen();
	         break;
	      case DestroyNotify:
	         Signal6502( SIG_6502_SHUTDOWN );
	         break;

#if 0
	      default:
	         fprintf(stderr,"unknown event type #%d\n",event.xany.type);
#endif
	
	   }
	}

#endif
	/*
	 * re-submit micro job for X window
	 */
	submit_micro_job( AppleClock + REFRESH_INTERVAL, 
	   X_check_and_handle_event, NULL );

}

/*
 *	Apple_Key:
 *	try to translate a KeyEvent to an Apple Key
 *	Stroke/Release. Apple_Key returns the ASCII
 *	code of the keys (bit 8 = 1), 0 if no key mapped
 */
static BYTE Apple_Key( XEvent *the_key_event )
{
	KeySym		the_key_sym;
	XComposeStatus	the_XC_status;
	char		buffer[2];
	BYTE		key;
	int		len;

	/*
	 *	Ordinary Characters
	 *	ISO-Latin 1 (ASCII 00-7f)
	 */
	the_key_sym = XLookupKeysym( &(the_key_event->xkey), 0 );
	if ( (unsigned short)the_key_sym < 0x80 ) {
	   len = XLookupString( &(the_key_event->xkey), buffer, 2,
	      &the_key_sym, &the_XC_status );
	   if( len ) {
	      /* case swap. In unix, lowercase is the default */
	      key = buffer[0];
	      if ( isupper( key ) )
	         key = tolower( key );
	      else if ( islower( key ) )
	         key = toupper( key );

	      /* Apple II uses ASCII with bit 7 set */ 	
	      return key | 0x80;
	   }
	   else
	      return 0;
	}

	/*
	 *	Special Characters, Modifiers	
	 */
	switch(the_key_sym) {
	   case XK_Return:
	      return 0x8D;	/* Retrun	*/
	   case XK_Tab:
	      return 0x89;	/* Ctrl-I	*/
	   case XK_BackSpace:
	   case XK_Left:
	      return 0x88;	/* Ctrl-H	*/
	   case XK_Right:
	      return 0x95;	/* Ctrl-U	*/
	   case XK_Up:
	      return 0x8B;	/* Ctrl-K	*/
	   case	XK_Down:
	      return 0x8A;	/* Ctrl-J	*/
	   case	XK_Escape:
	      return 0x9B;	/* Escape	*/
	   case	XK_Delete:
	      if ( the_key_event->xkey.state & ControlMask ) /* Crtl-Del? */
	         assert_RES();
	      return 0xFF;	/* Delete	*/
	
	   /*
	    *	Apple Keys for IIe & IIc
	    */
	   case XK_Alt_L:
	      printf("foo\n");
	      return LEFT_APPLE_KEY;	/* Left Apple Key */
	   case XK_Alt_R:
	      return RIGHT_APPLE_KEY;	/* Right Apple Key */
	   case XK_F1:
	      return DISK_DRIVE_KEY;	/* Disk ][ Function Key */
	   case XK_F2:
	      shutdown_6502();
	}
	return 0;
}

/*
 * getmouse: return current mouse position relative to apple
 * window. The mouse position is used for paddle emulation.
 * return false if mouse is not on the same screen as the Apple II window.
 */
BOOLEAN getmouse( int *x, int *y )
{
	int		root_x, root_y;
	Window		root_return, child_return;
	unsigned	mask_return;

	return (BOOLEAN) XQueryPointer( theDisplay, theWindow, &root_return, 
	   &child_return, &root_x, &root_y, x, y, &mask_return );

}
