/*
 * video.h
 *
 * SHM based video emulator
 */
#ifndef VIDEO_H
#define VIDEO_H

#define SCANLINE_MODE_BLANK	0
#define SCANLINE_MODE_TEXT	1
#define SCANLINE_MODE_LORES	2
#define SCANLINE_MODE_HIRES	3
#define SCANLINE_MODE_TEXT80	4
#define SCANLINE_MODE_DLORES	5
#define SCANLINE_MODE_DHIRES	6

extern unsigned ScanlineOffsetTable[192];
extern unsigned AppleColourPixel[16];
extern unsigned AppleColourQuad[16];

typedef struct {
	int y;
	int mode;
	int addr;
	int old_mode;
	int old_addr;
	void *scanline_addr1;
	void *scanline_addr2;
	APPLE_TICK write_lock_set;
	APPLE_TICK aux_write_lock_set;
	int state;
} scanline_t;

#define SCANLINE_STATE_CLEAN	0
#define SCANLINE_STATE_DIRTY	1
#define SCANLINE_STATE_DRAWN	2

extern void initScanlineData(void);
extern void drawBlankScanline(scanline_t*);
extern void drawTextScanline(scanline_t*);
extern void drawLowresScanline(scanline_t*);
extern void drawHiresScanline(scanline_t*);
extern void drawText80Scanline(scanline_t*);
extern void drawDLoresScanline(scanline_t*);
extern void drawDHiresScanline(scanline_t*);
extern void changeCharSet(int);

void initScreen(Display *);
int drawScreen(void);
void updateScreen(void);

#endif /* VIDEO_H */
