/*
 * vbl.c
 *
 * vertical blinking register
 */
#include <stdio.h>
#include "hardware.h"
#include "yae.h"

#define SCAN_LINE_TICKS	65
#define LINES_PER_FRAME 262
#define VBL_START	192
#define FRAME_TICKS	(SCAN_LINE_TICKS*LINES_PER_FRAME)

static APPLE_TICK NextVBLRecalibrate;
static APPLE_TICK VBLTimeBase;
static void VBLRecalibrate(void*);

void initVBL(void)
{
	if (MachineType >= APPLE_IIE)
	   submit_micro_job( VBLTimeBase+FRAME_TICKS, VBLRecalibrate, NULL );
}

int isVBL(void)
{
	int	lines;

	lines=(AppleClock-VBLTimeBase)/SCAN_LINE_TICKS;
	if (lines>=LINES_PER_FRAME)
	   lines %= LINES_PER_FRAME;
	return lines>=VBL_START;
}

static void VBLRecalibrate(void *arg)
{
	int frames;

	frames = (AppleClock - VBLTimeBase)/FRAME_TICKS;
	VBLTimeBase += FRAME_TICKS*frames;
	NextVBLRecalibrate+=FRAME_TICKS;
	submit_micro_job( NextVBLRecalibrate, VBLRecalibrate, NULL );
}
