/*
 * speed.c
 *
 * speed regulator
 */
static char rcsid[]="$Id: speed.c,v 1.3 1997/08/06 09:49:49 ctkwan Exp ctkwan $";

#include <stdio.h>
#include <unistd.h>
#include <sys/time.h>
#include <sys/types.h>
#include <math.h>

#include "hardware.h"
#include "yae.h"

#define MAX_LOG_SIZE 61

struct {
	APPLE_TICK	start_tick;
	struct timeval	start_time;
	unsigned	usleep_interval;
} SpeedLog[MAX_LOG_SIZE]; 

APPLE_TICK NextSpeedCheck;
int LogStart;
int LogSize;

#define DEFAULT_SPEED	1022727
int TargetSpeed=DEFAULT_SPEED;
#define TIME_SLICES_PER_SECOND	60
int TimeSliceSize=(DEFAULT_SPEED/TIME_SLICES_PER_SECOND);
int AverageSpeed=DEFAULT_SPEED;
int AverageRawSpeed=DEFAULT_SPEED;

static void checkSpeed(void*);
static unsigned AppleuSleep(unsigned);

void initSpeed()
{
	checkSpeed(NULL);
}

unsigned GetAverageSpeed(void)
{
	return AverageSpeed;
}

unsigned GetAverageRawSpeed(void)
{
	return AverageRawSpeed;
}

unsigned GetTargetSpeed(void)
{
	return TargetSpeed;
}

void SetTargetSpeed(unsigned speed)
{
	if (speed==0)
	   speed=DEFAULT_SPEED;
	TargetSpeed=speed;
	TimeSliceSize=speed/60;
}

/*
 * AppleuSleep: sleep for at least us microsecond. Since usleep is only
 * avaliable on BSD systems, better use select to implement sleep. returns
 * number of microsecond slept.
 */
static unsigned AppleuSleep(unsigned us)
{
	struct timeval tv,start,now;
	unsigned elapsed;

	gettimeofday(&start,NULL),
	tv.tv_sec=us/1000000;
	tv.tv_usec=us%1000000;
	select(0,NULL,NULL,NULL,&tv);
	gettimeofday(&now,NULL),
	elapsed=(now.tv_sec-start.tv_sec)*1000000 +
	   (now.tv_usec-start.tv_usec);
	return elapsed;
}

double sum_speed=0.0;
double variance=0.0;
int n;
static void checkSpeed(void *arg)
{
	int i, j, cycles, duration, total_usleep, s, us;

#if 1 ||defined(DEBUG)
	static int c;
	double d;

	if (++c==60){
	   sum_speed+=AverageSpeed;
	   d=(double)(AverageSpeed-TargetSpeed)/TargetSpeed;
	   variance+=d*d;
	   n++;
	   printf("AvgSpd=%d Avg2Spd=%G AvgRSpd=%d StdDev=%G\n",AverageSpeed,
	      sum_speed/n,AverageRawSpeed,sqrt(variance/n));
	   c=0;
	}
#endif

	/* get new slot */
	if((i=LogStart+LogSize)>=MAX_LOG_SIZE)
	   i -= MAX_LOG_SIZE; /* wrap around */

	if ( LogSize < MAX_LOG_SIZE ) 
	   LogSize++;
	else if(++LogStart==MAX_LOG_SIZE) /* advance head */
	      LogStart=0;

	SpeedLog[i].start_tick=AppleClock;
	gettimeofday(&SpeedLog[i].start_time,NULL);
	SpeedLog[i].usleep_interval=0;

	/* try regulate speed */
	if (LogSize>1){
	   /* find average speed */ 
	   cycles=SpeedLog[i].start_tick-SpeedLog[LogStart].start_tick;
	   s=SpeedLog[i].start_time.tv_sec -
	      SpeedLog[LogStart].start_time.tv_sec;
	   us=SpeedLog[i].start_time.tv_usec -
	      SpeedLog[LogStart].start_time.tv_usec;
	   duration=s*1000000+us;

	   /* find accumlated sleep time */
	   j=LogStart;
	   total_usleep=0;
	   while(j!=i){
	      total_usleep+=SpeedLog[j].usleep_interval;
	      if (++j>=MAX_LOG_SIZE)
	         j=0;
	   }

	   /* update speed */
	   AverageSpeed=(double)cycles*1000000/duration;
	   AverageRawSpeed=(double)cycles*1000000/(duration-total_usleep);

	   /* calculate sleep time this round */
	   us=(double)TimeSliceSize*(1.0/TargetSpeed-1.0/AverageRawSpeed)*
	      1000000;
	   if (us>0){
	      SpeedLog[i].usleep_interval=us;
	      AppleuSleep(us);
	   }
	}

	/* submit microjob */
	NextSpeedCheck+=TimeSliceSize;
	submit_micro_job( NextSpeedCheck, checkSpeed, NULL );
}
