/*
 *	shm.c
 */

#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/shm.h>
#include <X11/extensions/XShm.h>

XImage *createShmImage( Display *dpy, int width, int height,
   XShmSegmentInfo *info )
{
	XImage *image;

	/* set values for undo in case of error */
	image=NULL;
	info->shmid=-1;
	info->shmaddr=(char*)-1;

	image = XShmCreateImage( dpy,
	   DefaultVisual(dpy,DefaultScreen(dpy)),
	   DefaultDepth(dpy,DefaultScreen(dpy)), ZPixmap, NULL,
	   info, width, height );
	if (!image) {
	   fprintf( stderr, "XShmCreateImage failed\n" );
	   goto error;
	}

	info->shmid = shmget( IPC_PRIVATE, image->bytes_per_line *
	   image->height, IPC_CREAT|0777 );
	if (info->shmid==-1) {
	   fprintf( stderr, "shmget failed\n" );
	   goto error;
	}

	info->shmaddr = image->data = (char*)shmat( info->shmid, NULL, 0 );
	info->readOnly = False;
	if ( !XShmAttach( dpy, info ) ) {
	   fprintf( stderr, "XShmAttach failed\n" );
	   goto error;
	}

	return image;

error:
	/* undo what have done so far */

	if (info->shmaddr!=(char*)-1)
	   shmdt( info->shmaddr );
	if (info->shmid!=-1)
	   shmctl( info->shmid, IPC_RMID, NULL );
	if(image!=NULL)
	   XDestroyImage(image);
	return NULL;
}

void destroyShmImage(Display *dpy, XImage *image, XShmSegmentInfo *info)
{
	XShmDetach( dpy, info );
	XDestroyImage( image );
	if (shmctl( info->shmid, IPC_RMID, NULL )==-1){
	   perror("destroyShmImage() cannot remove share memory");
	}
}
