/*
 *	main.c -- Globals and emulation setup for Apple ][ Emulator
 *	(C) 1989 Ben Koning [556498717 408/738-1763 ben@apple.com]
 *
 *	modified by Doug C.T. Kwan
 *	to include X window interfaces
 *	(C) 1992 D. C. T. Kwan
 */
#define	_MAIN_C_

#include <stdlib.h>
#include <stdio.h>
#include <signal.h>
#include <unistd.h>

#include "hardware.h"
#include "memory.h"
#include "6502.h"
#include "yae.h"

AppleCPUContextStruct	context;

#ifdef SLAVE_PROCESSOR
AppleCPUContextStruct	slave_context;
#endif /* SLAVE_PREOCESSOR */

static char Options[]="2e+";

void sigintHandler(int sig)
{
	shutdown_6502();
}

void processOptions(int argc, char *argv[])
{
	int	c;

	while((c=getopt(argc,argv,Options))!= EOF) {
	    switch(c) {
	    case 'e':
	       MachineType=APPLE_IIE;
	       break;
	    case '2':
	    case '+':
	       MachineType=APPLE_II_PLUS;
	       break;
	    }
	}
}

int main (int argc, char *argv[])
{
	unsigned	sigcode;
	extern int	optind;
 
	/* Initialize the emulation: */
	AppleClock = 0;
	MachineType=APPLE_IIE;

	processOptions(argc,argv);

	/* mount disk */
	if (optind<argc)	
	   bootdisk=argv[optind];

	/*
	 * Initialize the world
	 */
	(void)init_memory();
	mmuMicrojob();
	(void)init_X();

#ifdef	RUN_TIME_TRANSLATION
	(void)init_compiler();
#endif
	(void)init_disk2();
	(void)init_sound();
	initSpeed();
	initVideo();
	initVBL();

	signal( SIGINT, sigintHandler );
	signal( SIGHUP, sigintHandler );
	signal( SIGTERM, sigintHandler );

	/*
	 *Run it until user wants to quit:
	 */
	(void)init_6502();
	(void)Signal6502( SIG_6502_RES );
#ifdef	SLAVE_PROCESSOR
	(void)InitSlaveCPU();
	(void)SyncSlaveMemory();
	slave_context = context;
#endif

	do {
	   sigcode = CPUExecute( &context );
#ifdef	SLAVE_PROCESSOR
	   if ( sigcode == SIG_6502_RES ) {
	      (void)InitSlaveCPU();
	      (void)SyncSlaveMemory();
	      slave_context = context;
           }
	   else
	      (void)SlaveCPUExecute( &slave_context );
#endif	/* SLAVE_PROCESSOR*/

#ifdef	RUN_TIME_TRANSLATION
	   (void)RecordLastPC( context.PC & 0xFFFF );
#endif
	   (void)execute_micro_jobs();

	} while ( !( sigcode & SIG_6502_SHUTDOWN ) );

	/* Exit cleanly: */
	quit_X();
	printf( "%d cycles\n", AppleClock );
	printf( "%d cycles in vm\n", VMTime );
	printf( "hit ratio %g\n", (float)VMTime/AppleClock );

	return 0;
}
