/*
 *
 * $Log: iou.c,v $
 * Revision 1.9  1997/08/06  09:49:49  ctkwan
 * *** empty log message ***
 *
 * Revision 1.8  1997/08/05  16:26:29  ctkwan
 * *** empty log message ***
 *
 * Revision 1.7  1997/08/04  11:42:00  ctkwan
 * correct SLOTCXROM switch semantics.
 *
 * Revision 1.6  1997/08/04  06:46:15  ctkwan
 * add MachineType and VBL support.
 *
 * Revision 1.5  1997/08/02  12:23:50  ctkwan
 * *** empty log message ***
 *
 * Revision 1.4  1997/08/02  09:30:29  ctkwan
 * *** empty log message ***
 *
 * Revision 1.3  1997/08/01  18:14:40  ctkwan
 * change Language Card switch to ALTZP.
 *
 */

#include "hardware.h"
#include "memory.h"
#include "iou.h"
#include "yae.h"

static char rcsid[]="$Id: iou.c,v 1.9 1997/08/06 09:49:49 ctkwan Exp ctkwan $";

/* soft switches */

int	C800ROMSlot;

#define OFFSET(x)	((x)&0xff)
#define SET(x)		IOUState=(IOUSoftSwitch=IOUSoftSwitch|(x))
#define RESET(x)	IOUState=(IOUSoftSwitch&=IOUSoftSwitch&~(x))

static int garbage;

static unsigned IOUSoftSwitch=0;
unsigned IOUState=0;

void toggleMemorySoftSwitch(ADDR address)
{	
	switch(address){
	case CLR80STORE:
	   if (IOUSoftSwitch & SS_80STORE) {
	      RESET(SS_80STORE);
	      remapTextRead();
	      remapTextWrite();
	      if (IOUSoftSwitch & SS_HIRES){
	         remapHiresRead();
	         remapHiresWrite();
	      }
	   }
	   break;
	case SET80STORE:
	   if (!(IOUSoftSwitch & SS_80STORE)) {
	      SET(SS_80STORE);
	      remapTextRead();
	      remapTextWrite();
	      if (IOUSoftSwitch & SS_HIRES){
	         remapHiresRead();
	         remapHiresWrite();
	      }
	   }
	   break;
	case RDMAINRAM:
	   if (IOUSoftSwitch&SS_RAMRD){
	      RESET(SS_RAMRD);
	      remapRAMRead();
	      if (!(IOUSoftSwitch&SS_80STORE))
	         remapTextRead();
	      if ((IOUSoftSwitch&(SS_80STORE|SS_HIRES))!=(SS_80STORE|SS_HIRES))
	         remapHiresRead();
	   }
	   break;
	case RDCARDRAM:	
	   SET(SS_RAMRD);
	   remapRAMRead();
	   if (!(IOUSoftSwitch&SS_80STORE))
	      remapTextRead();
	   if ((IOUSoftSwitch&(SS_80STORE|SS_HIRES))!=(SS_80STORE|SS_HIRES))
	      remapHiresRead();
	   break;
	case WRMAINRAM:	
	   RESET(SS_RAMWRT);
	   remapRAMWrite();
	   if (!(IOUSoftSwitch&SS_80STORE))
	      remapTextWrite();
	   if ((IOUSoftSwitch&(SS_80STORE|SS_HIRES))!=(SS_80STORE|SS_HIRES))
	      remapHiresWrite();
	   break;
	case WRCARDRAM:	
	   SET(SS_RAMWRT);
	   remapRAMWrite();
	   if (!(IOUSoftSwitch&SS_80STORE))
	      remapTextWrite();
	   if ((IOUSoftSwitch&(SS_80STORE|SS_HIRES))!=(SS_80STORE|SS_HIRES))
	      remapHiresWrite();
	   break;
	case SETSLOTCXROM:
	   RESET(SS_SLOTCXROM);
	   remapCXROM();
	   break;
	case SETINTCXROM:
	   SET(SS_SLOTCXROM);
	   remapCXROM();
	   break;
	case SETSTDZP:
	   RESET(SS_ALTZP);
	   remapZP();
	   if (IOUSoftSwitch&SS_LCRAMRD)
	      remapLCRead();
	   if (IOUSoftSwitch&SS_LCRAMWRT)
	      remapLCWrite();
	   break;
	case SETALTZP:
	   SET(SS_ALTZP);
	   remapZP();
	   if (IOUSoftSwitch&SS_LCRAMRD)
	      remapLCRead();
	   if (IOUSoftSwitch&SS_LCRAMWRT)
	      remapLCWrite();
	   break;
	case SETINTC3ROM:
	   RESET(SS_SLOTC3ROM);
	   if (C800ROMSlot==3)
	      SET(SS_EXPNROM);
	   remapCXROM();
	   break;
	case SETSLOTC3ROM:
	   SET(SS_SLOTC3ROM);
	   RESET(SS_EXPNROM);
	   remapCXROM();
	   break;
	case CLR80VID:
	   RESET(SS_80COL);
	   break;
	case SET80VID:
	   SET(SS_80COL);
	   break;
	case CLRALTCHAR:
	   RESET(SS_ALTCHAR);
	   break;
	case SETALTCHAR:
	   SET(SS_ALTCHAR);
	}
}

BYTE readSoftSwitch(ADDR address)
{
	int flag,data;
	static unsigned long soft_switch_list[16]={
	   0 /* key strobe */, SS_LCBNK2, SS_LCRAM, SS_RAMRD,
	   SS_RAMWRT, SS_SLOTCXROM, SS_ALTZP, SS_SLOTC3ROM,
	   SS_80STORE, 0 /* VBL */, SS_TEXT, SS_MIXED,
	   SS_PAGE2, SS_HIRES, SS_ALTCHAR, SS_80COL };

	data = garbage>>8;
	flag=soft_switch_list[address&0xf];
	if (flag)
	    data = (flag&IOUSoftSwitch)? data | 0x80: data & 0x7f; 
	else {
	   if (address==KBDSTRB) {
	      return keyHeld();
	   }
	   else if (address==RDVBLBAR) {
	      if (!isVBL()){
	         SET(SS_VBLBAR);
	      }
	      data = (SS_VBLBAR&IOUSoftSwitch)? data | 0x80: data & 0x7f;
	   }
	}
	return data;
}

void toggleTapeOut(void)
{
}

void toggleVideoSoftSwitch( ADDR address )
{
	/* IOU internal house keeping */
	switch(address){
	   case TXTCLR:
	      RESET(SS_TEXT);
	      break;
	   case TXTSET:
	      SET(SS_TEXT);
	      break;
	   case MIXCLR:
	      RESET(SS_MIXED);
	      break;
	   case MIXSET:
	      SET(SS_MIXED);
	      break;
	   case LOWSCR:
	      if (IOUSoftSwitch&SS_PAGE2){
	         RESET(SS_PAGE2);
	         if (IOUSoftSwitch&SS_80STORE) {
	            remapTextRead();
	            remapTextWrite();
	            if (IOUSoftSwitch&SS_HIRES){
	               remapHiresRead();
	               remapHiresWrite();
	            }
	         }
	      }
	      break;
	   case HISCR:
	      if (!(IOUSoftSwitch&SS_PAGE2)){
	         SET(SS_PAGE2);
	         if (IOUSoftSwitch&SS_80STORE) {
	            remapTextRead();
	            remapTextWrite();
	            if (IOUSoftSwitch&SS_HIRES){
	               remapHiresRead();
	               remapHiresWrite();
	            }
	         }
	      }
	      break;
	   case LOWRES:
	      if (IOUSoftSwitch&SS_HIRES) {
	         RESET(SS_HIRES);
	         if (IOUSoftSwitch&SS_80STORE) {
	            remapHiresRead();
	            remapHiresWrite();
	         }
	      }
	      break;
	   case HIRES:
	      if (!(IOUSoftSwitch&SS_HIRES)) {
	         SET(SS_HIRES);
	         if (IOUSoftSwitch&SS_80STORE){
	            remapHiresRead();
	            remapHiresWrite();
	         }
	      }
	      break;
	}
}

void toggleAnnunciator( ADDR address )
{
	static unsigned long soft_switch_list[4]={
	   SS_AN0, SS_AN1, SS_AN2, SS_AN3 };
	int an;

	if (MachineType>=APPLE_IIE){
	   if (address==SETDHIRES){
	      SET(SS_DHIRES);
	      return;
	   }
	   if (address==CLRDHIRES){
	      RESET(SS_DHIRES);
	      return;
	   }
	}
	an = (address >> 1) & 3;
	if ( address & 1 ) /* on */
	   SET(soft_switch_list[an]);
	else
	   RESET(soft_switch_list[an]);
}

void toggleLanguageCard( ADDR address )
{
	unsigned old_ss;

	old_ss=IOUSoftSwitch;

	/* set IOU soft switches */
	if (((address>>1)^address)&1)
	   RESET(SS_LCRAM);
	else
	   SET(SS_LCRAM);

	if (address & 1)
	   SET(SS_LCRAMWRT);
	else
	   RESET(SS_LCRAMWRT);

	if (address & 0x08)
	   RESET(SS_LCBNK2);
	else
	   SET(SS_LCBNK2);

	if (old_ss!=IOUSoftSwitch){
#if 0 && defined(DEBUG)
	   printf("toggle LC address $%04X at %d\n",address,AppleClock);
#endif
	   remapLCRead();
	   remapLCWrite();
	}
}

unsigned long GetIOUSoftSwitch(void)
{
	return IOUSoftSwitch;
}

BYTE AppleIORead( ADDR address )
{
	int	slot,data;

	garbage=garbage*0x31415927+0x27182818;
	data=garbage>>8;

	if ( address < 0xC080 ) { /* $C000-$C07F soft switches */
	   switch((address>>4)&0xf){
	   case 0: /* KBD */
	      return readKeyboard();

	   case 1: /* KBDSTRB */
	      strobeKeyboard();
	      if (MachineType >= APPLE_IIE)
	         return readSoftSwitch(address); 
	      break;
	   case 2: /* TAPEOUT */
	      toggleTapeOut();
	      break;
	   case 3:
	      toggleSpeaker();
	      break;
	   case 4: /* ??? */
	      break;
	   case 5:
	      if (address < 0xC058)
	         toggleVideoSoftSwitch(address);
	      else 
	         toggleAnnunciator(address);
	      break;
	   case 6:
	      if (address>=BUTN0&&address<=PADDL3)
	         return read_paddle(address);
	      break;
	   case 7: /* PTRIG and RDIOUDIS */
	      trigger_paddle(); /* trigger paddle */
	      if (MachineType >= APPLE_IIE ) {
	         RESET(SS_VBLBAR);
	         if (address==RDIOUDIS)
	            data=(IOUSoftSwitch & SS_IOUDIS)? (data|0x80): data&0x7f;
	         else if (address==RDDHIRES)
	            data=(IOUSoftSwitch & SS_DHIRES)? (data|0x80): data&0x7f;
	      }
	   }
	}
	else if ( address < 0xC100 ) {
	   slot=(address>>4)&0x7;
	   if (slot==0)
	      toggleLanguageCard(address);
	   else if (expansion_slot_read[slot])
	      data=(*expansion_slot_read[slot])(address);
	}
	else if ( MachineType >= APPLE_IIE &&
	   (IOUSoftSwitch & SS_SLOTCXROM) ) { /* internal ROM */
	   return ((BYTE*)MainMemoryROM[(address>>8)])[address&0xff];
	}
	else {
	   if ( address < 0xC800 ) { /* slot ROM */
	      slot = (address >> 8) & 0x7;
	      if ( (MachineType >= APPLE_IIE) && 
	         slot==3 && !(IOUSoftSwitch & SS_SLOTC3ROM)) {
	         if (C800ROMSlot==0) {
	            C800ROMSlot=3;
	            SET(SS_EXPNROM);
	            remapCXROM();
	         }
	         return ((BYTE*)MainMemoryROM[(address>>8)])[address&0xff];
	      }
	      else { 
	         if (C800ROMSlot==0) { /* active expansion ROM */
	            C800ROMSlot=slot;
	            remapCXROM();
	         }
	         if (expansion_slot_read[slot])
	            data=(*expansion_slot_read[slot])(address);
	      }
	   }
	   else if (address != CLRROM){ /* $C800-$CFFE expansion ROM */
	      if (IOUSoftSwitch & SS_EXPNROM)
	         return ((BYTE*)MainMemoryROM[(address>>8)])[address&0xff];
	      if (C800ROMSlot !=0 && expansion_slot_read[C800ROMSlot])
	         return (*expansion_slot_read[C800ROMSlot])(address);
	   }
	   else { /* deactivate expansion ROM */
	      if (C800ROMSlot==3) {
	          MapReadPage(0xC3,NULL);
	          LockReadMappedPage(0xC3,PAGE_LOCK_READ);
	      }
	      C800ROMSlot=0;
	      RESET(SS_EXPNROM);
	      remapCXROM();
	   }
	}
	return data;
}

void AppleIOWrite( ADDR address, BYTE data )
{
	int slot;

	if (address<0xC080){
	   switch((address>>4)&0xf){
	   case 0:
	      if (MachineType >= APPLE_IIE)
	         toggleMemorySoftSwitch(address);
	      break;
	   case 1:
	      strobeKeyboard();
	      break;
	   case 2:
	      toggleTapeOut();
	      break;
	   case 3:
	      toggleSpeaker();
	      break;
	   case 5:
	      if (address < 0xC058 )
	         toggleVideoSoftSwitch(address);
	      else 
	         toggleAnnunciator(address);
	      break;
	   case 7:
	      trigger_paddle(); /* trigger paddle */
	      if (MachineType >= APPLE_IIE){
	         RESET(SS_VBLBAR);
	         if ( address==SETIOUDIS)
	            IOUSoftSwitch |= SS_IOUDIS;
	         else if (address==CLRIOUDIS)
	            IOUSoftSwitch &= ~SS_IOUDIS;
	      }
	      break;
	   }
	}
	else if (address < 0xC100){ /* slot I/O */
	   slot=(address>>4)&0x7;
	   if (slot==0)
	      toggleLanguageCard(address); 
	   else if (expansion_slot_write[slot])
	      (*expansion_slot_write[C800ROMSlot])(address,data);
	}
	else if ( MachineType < APPLE_IIE || !(IOUSoftSwitch & SS_SLOTCXROM) ) {
	   if (address < 0xC800) { /* slot ROM */
	      slot=(address>>8)&0x7;
	      if ( (MachineType >= APPLE_II) && slot == 3 &&
	         !(IOUSoftSwitch & SS_SLOTC3ROM)){
	         if (C800ROMSlot==0) {
	            C800ROMSlot=3;
	            SET(SS_EXPNROM);
	            remapCXROM();
	         }
	      }
	      else {
	         if (C800ROMSlot==0) { /* active expansion ROM */
	            C800ROMSlot=slot;
	            remapCXROM();
	         }
	         if (expansion_slot_write[slot])
	            (*expansion_slot_write[slot])(address,data);
	      }
	   }
	   else if (address != CLRROM) {
	      if (C800ROMSlot!=0 && expansion_slot_write[C800ROMSlot])
	         (*expansion_slot_write[C800ROMSlot])(address,data);
	   }
	   else { /* deactivate expansion ROM in $C800-$CFFF */
	      if (C800ROMSlot==3) {
	         MapReadPage(0xC3,NULL);
	         LockReadMappedPage(0xC3,PAGE_LOCK_READ);
	      }
	      C800ROMSlot=0;
	      RESET(SS_EXPNROM);
	      remapCXROM();
	   }
	}
}
