/*
 *	hardware.h
 */

#ifndef	_HARDWARE_H_
#define	_HARDWARE_H_


/*
 * Storage for global variables
 * are only declared in main.c
 * for other modules, the globals are
 * declared as externs
 */
#ifdef	_MAIN_C_
#define	EXTERN
#else
#define	EXTERN	extern
#endif	

/*
 * Boolean
 */
typedef	unsigned char	BOOLEAN;
#define	TRUE 		1
#define	FALSE 		0

typedef	unsigned char	BYTE;
typedef	unsigned	ADDR;

#define	SIGN_EXTEND(x)	((int)((char)x))

/*
 * CPU TYPE
 *
 */
#define	MC65C02

/*
 * AppleClock
 * AppleClock is a 32-bit cycle counter
 * It is updated by the CPU module for every instruction executed.
 * It is intended to be used as a time reference for
 * intervals shorter than 2^32 cycles. (approx 70 minutes)
 */
typedef	unsigned APPLE_TICK;
#define TICKS_PER_SECOND	1022727
#define MAX_POSITIVE_TICK	(0x7FFFFFFF)
#define TICK_GREATER(x,y)	((int)((x)-(y)) > 0)
#define TICK_LESS(x,y)		((int)((x)-(y)) < 0)
#define TICK_EQUAL(x,y)		((x)=(y))	

EXTERN APPLE_TICK	AppleClock;
EXTERN APPLE_TICK	VMTime;

/*
 * typedef of MREAD_FUNC & MWRITE_FUNC
 */
typedef	BYTE	(*MREAD_FUNC)( ADDR /* a */ );
typedef	void	(*MWRITE_FUNC)( ADDR /* a */, BYTE /* d */);

/*
 * Memory
 * Apple IIX can access an address space of 64k
 * the memory layout is as follows
 *
 *	RAM:
 *
 *	$0000-$00FF	Zero Page
 *	$0100-$01FF	6502 hardware stack
 *	$0200-$03FF	RAM
 *	$0400-$07FF	Text/Low resolution graphics page 1
 *	$0800-$0BFF	Text/Low resolution graphics page 2
 *	$0C00-$1FF	RAM
 *	$2000-$3FFF	High resolution graphics page 1
 *	$4000-$5FFF	high resolution graphics page 2
 *	$6FFF-$BFFF	RAM
 *
 *	I/O:
 *	$C000-$C0FF	Memory mapped I/O, expansion slots I/O
 *	$C100-$C7FF	Expansion slots ROM
 *	$C800-$CFFF	Optional Expansion slots ROM
 *
 *	ROM:
 *	$D000-$F7FF	Applesoft Basic of Integer Basic
 *	$F800-$FFFF	Monitor ROM
 *
 *	$D000-$DFFF	Bank0/Bank1 of lower addresses
 *	$E000-$FFFF	Higher addresses
 */

/*
 * I/O slots thunks
 * Slot I/O are implemented by installing R/W thunks
 * all memory mapped I/O are handled by appropiate thunks
 * NULL thunks will not be called. 
 * memory addresses $C080-$C0FF and $C100-$C7FF are
 * handled by thunks
 */

#define NO_OF_SLOTS 8
EXTERN MREAD_FUNC	expansion_slot_read[NO_OF_SLOTS];
EXTERN MWRITE_FUNC	expansion_slot_write[NO_OF_SLOTS];

/*
 * For a memory write to an address A
 * if ( a & M == T ), where M is a mask & T a tag value
 * the appropriate video routine is called
 */

/* masks	*/
#define	TEXT_LOWRES_MASK	0xFC00
#define	HIRES_MASK		0xE000

/* tag values	*/
#define	TEXT_PAGE1_ADDRESS	0x0400
#define	LOWRES_PAGE1_ADDRESS	0x0400
#define	TEXT_PAGE2_ADDRESS	0x0800
#define	LOWRES_PAGE2_ADDRESS	0x0800
#define	HIRES_PAGE1_ADDRESS	0x2000
#define	HIRES_PAGE2_ADDRESS	0x4000
#define	NO_DISPLAY		(~0)

EXTERN	int		Hires_Tag;
EXTERN	int		Text_Lowres_Tag;

#define			APPLE_II	0
#define			APPLE_II_PLUS	1
#define			APPLE_IIE	2

EXTERN	int		MachineType;
/*
 * Keyboard
 *
 * Last_Apple_Key stores the ASCII of the last key
 * pressed. The MSB of Last_Apple_Key is cleared
 * if KEYBOARD_STROBE is accessed
 */
#define	KEYBOARD_ADDRESS	0xC000	/* $C000	*/
#define KEYPRESS_TEST		0xC008	/* $C008 ?	*/
#define	KEYBOARD_STROBE		0xC010	/* $C010	*/
EXTERN	BYTE	Last_Apple_Key;		
EXTERN	BYTE	Apple_Key_Pressed;		

#define LEFT_APPLE_KEY  1
#define RIGHT_APPLE_KEY 2
#define DISK_DRIVE_KEY  3

/*
 *	Video hardwares
 */
#define	SCREEN_WIDTH	560
#define SCREEN_HEIGHT	384

#define	CHAR40_WIDTH	14
#define CHAR40_HEIGHT	16
#define	LOW_RES_FONT_WIDTH	14
#define	LOW_RES_FONT_HEIGHT	16
#define	CHAR80_WIDTH	7
#define	CHAR80_HEIGHT	16

EXTERN	int	Video_Dirty;

/*
 *
 */
EXTERN char	*bootdisk;



/*
#define	RUN_TIME_TRANSLATION
#define DEBUG
#define SLAVE_PROCESSOR
*/


#endif
