/*
 * disk2.c
 */
static char rcsid[]="$Id: disk2.c,v 1.2 1997/08/02 12:23:50 ctkwan Exp $";

#include <stdio.h>
#include "hardware.h"
#include "yae.h"

/*
 * raw track
 * this is obtained by
 * 14.31818MHz / 14 / 32 / 8
 *
 */

#define RAW_TRACK_BYTES 6392


#define DOS_TRACK_BYTES 4096 
#define RAW_TRACK_BITS (RAW_TRACK_BYTES*8) 

static  FILE	*diskimage;
static	int	write_mode;
static	int	write_protect;
static	BYTE	nibble[RAW_TRACK_BYTES];
static	BYTE	dos_track[4096];
static	int	position;

static BYTE	boot_ROM[256];


#define NO_OF_PHASES 8
#define MAX_PHYSICAL_TRACK_NO (40*NO_OF_PHASES)

static int	stepper_movement_table[16][NO_OF_PHASES] = {
	{  0,  0,  0,  0,  0,  0,  0,  0 },	/* all electromagnets off */
	{  0, -1, -2, -3,  0,  3,  2,  1 },	/* EM 1 on */
	{  2,  1,  0, -1, -2, -3,  0,  3 },	/* EM 2 on */
	{  1,  0, -1, -2, -3,  0,  3,  2 },	/* EMs 1 & 2 on */
	{  0,  3,  2,  1,  0, -1, -2, -3 },	/* EM 3 on */
	{  0, -1,  0,  1,  0, -1,  0,  1 },	/* EMs 1 & 3 on */
	{  3,  2,  1,  0, -1, -2, -3,  0 },	/* EMs 2 & 3 on */
	{  2,  1,  0, -1, -2, -3,  0,  3 },	/* EMs 1, 2 & 3 on */
	{ -2, -3,  0,  3,  2,  1,  0, -1 },	/* EM 4 on */
	{ -1, -2, -3,  0,  3,  2,  1,  0 },	/* EMs 1 & 4 on */
	{  0,  1,  0, -1,  0,  1,  0, -1 },	/* EMs 2 & 4 */
	{  0, -1, -2, -3,  0,  3,  2,  1 },	/* EMs 1, 2 & 4 on */
	{ -3,  0,  3,  2,  1,  0, -1, -2 },	/* EMs 3 & 4 on */
	{ -2, -3,  0,  3,  2,  1,  0, -1 },	/* EMs 1, 3 & 4 on */
	{  0,  3,  2,  1,  0, -1, -2, -3 },	/* EMs 2, 3 & 4 on */
	{  0,  0,  0,  0,  0,  0,  0,  0 } };	/* all electromagnets on */

static int		drive_select;
static int		motor_on;
static int		physical_track_no[2];
static int		stepper_status[2];

static int		track_buffer_valid=0;
static int		track_buffer_dirty=0;
static int		track_buffer_track=0;

static BYTE		data_latch;
static BYTE		address_latch;
static APPLE_TICK	LastAppleClock;

static BYTE read_nibble(void);
static void write_nibble( BYTE );
static BYTE diskCardRead( ADDR );
static void diskCardWrite( ADDR, BYTE );
static void toggleStepper( ADDR );
static void toggleMotor( ADDR );
static void selectDrive( ADDR );
static void load_track_buffer(void);
static void save_track_buffer(void);

void init_disk2(void)
{
	FILE	*f;

	f = fopen( "/postgrad/ctkwan/Xapple/DISK.ROM", "rb" );
	if ( !f )
	   f = fopen( "DISK.ROM", "rb" );
	if ( !f ) {
	   fprintf( stderr, "Cannot read disk II boot rom\n" );
	   exit(1);
	}
	fread( boot_ROM, 1, 256, f );
	fclose( f );
	mount_disk( 6, 1, bootdisk );

	expansion_slot_read[6] = diskCardRead;
	expansion_slot_write[6] = diskCardWrite;

}

int mount_disk( int slot, int drive, char *disk )
{
	if ( diskimage )
	   unmount_disk( slot, drive );
	if ( !disk )
	   return -1;
	write_protect = 0;
	diskimage = fopen( disk, "r+" );
	if ( !diskimage ) {
	   write_protect = 1;
	   diskimage = fopen( disk, "r" );
	}
	if (!diskimage) {
	   fprintf( stderr, "Fail to mount disk %s\n", disk );
	   return -1;
	}
	else {
	   fprintf( stderr, "Mount disk %s\n", disk ); 
	   fprintf( stderr, "write protected = %d\n", write_protect ); 
	   load_track_buffer();
	}
	return 0;
}

int unmount_disk( int slot, int drive )
{
	save_track_buffer();
	if ( diskimage ) {
	   fclose( diskimage );
	   diskimage = NULL;
	}
	return 0;
}

BYTE read_nibble(void)
{ 
	BYTE	data;
	static	flag;
	
	if ( !track_buffer_valid ) {
	  load_track_buffer();
	}

	flag = !flag;
	if ( flag )
	   return 0;

	if ( TICK_GREATER( AppleClock, LastAppleClock + 200 ) ) {
	   position = (position + ( AppleClock - LastAppleClock ) / 32) %
	      RAW_TRACK_BYTES;
	}

	data = nibble[position++];
	if ( position >= RAW_TRACK_BYTES )
	   position = 0;	
	LastAppleClock = AppleClock;
	return data;

	 
}

void write_nibble( BYTE data )
{
	if ( !track_buffer_valid ) {
	  load_track_buffer();
	}
	if ( TICK_GREATER( AppleClock, LastAppleClock + 200 ) ) {
	   position = (position + ( AppleClock - LastAppleClock ) / 32) %
	      RAW_TRACK_BYTES;
	}

	if ( !write_protect ) {
	   nibble[position++] = data;
	   if ( position >= RAW_TRACK_BYTES )
	      position = 0;	
	   track_buffer_dirty = 1;
	}
	LastAppleClock = AppleClock;
}

BYTE diskCardRead( ADDR address )
{
	/*
	 * boot ROM
	 */
	if ( address >= 0xC100 )
	   return boot_ROM[address & 0xFF];

	/*
	 * disk I/O
	 */
	switch( address & 0x0F ) {
	   case 0x0C:
	      if ( address_latch == 0x0E )
	         write_mode = 0;
	      else if ( address_latch == 0x0F )
	         write_mode = 1;
	      if ( write_mode )
	         write_nibble( data_latch );
	      else 
	        data_latch = read_nibble();
	      address_latch = 0x0C;
	      return data_latch;
	      break;
	   case 0x0D:
	      address_latch = 0x0D;
	      break;
	   case 0x0E:
	      if ( address_latch == 0x0D ) {	/* check write protect */
	         address_latch = 0x0E;
	         return write_protect? 0xFF : 0x00;
	      }
	      address_latch = 0x0E;
	      break;
	   case 0x0F:
	      address_latch = 0x0F;
	      break;
	   case 0x08:	/* motor off */
	   case 0x09:	/* motor on */
	      toggleMotor( address );
	      break;
	   case 0x0A:	/* select driver 1 */
	   case 0x0B:	/* select driver 2 */
	      selectDrive( address );
	      break;
	   default:	/* C0X0-C0X7, stepper toggle */
	      toggleStepper( address );
	}
	return 0;
}

          
void diskCardWrite( ADDR address, BYTE data )
{
	if ( address >= 0xC100 )
	   return;

	/*
	 * disk I/O
	 */
	switch( address & 0x0F ) {
	   case 0x0C:
	      if ( address_latch == 0x0E )
	         write_mode = 0;
	      else if ( address_latch == 0x0F )
	         write_mode = 1;
	      if ( write_mode )
	         write_nibble( data_latch ); 
	      address_latch = 0x0C;
	      break;
	   case 0x0D:
	      data_latch = data;
	      address_latch = 0x0D;
	      break;
	   case 0x0E:
	      address_latch = 0x0E;
	      break;
	   case 0x0F:
	      data_latch = data;
	      address_latch = 0x0F;
	      break;
	   case 0x08:	/* motor off */
	   case 0x09:	/* motor on */
	      toggleMotor( address ); 
	      break;
	   case 0x0A:	/* select driver 1 */
	   case 0X0B:	/* select driver 2 */
	      selectDrive( address );
	      break;
	   default:	/* C0X0-C0X7, stepper toggle */
	      toggleStepper( address );
	}

}

static void toggleStepper( ADDR address )
{
	int	magnet, on, old_track_no, new_status,phase;

	if ( track_buffer_valid )
	   save_track_buffer();
	magnet = (address & 0x0E) >> 1;
	on = address & 0x01;
	old_track_no = physical_track_no[drive_select];
	if ( on )
	   stepper_status[drive_select] |= (1<<magnet); 
	else
	   stepper_status[drive_select] &= ~(1<<magnet); 
	if ( motor_on ) {
	   new_status = stepper_status[drive_select];
	   phase = physical_track_no[drive_select] & 0x07;
	   physical_track_no[drive_select] +=
	       stepper_movement_table[new_status][phase];
	   if ( physical_track_no[drive_select] < 0 ) {
	      fprintf( stderr, "Grrrr....\n" );
	      physical_track_no[drive_select] = 0;
	   }
	   else if ( physical_track_no[drive_select] >= MAX_PHYSICAL_TRACK_NO ) 
	      physical_track_no[drive_select] = 0;
	   track_buffer_valid = 0;
	}

}

static void toggleMotor( ADDR address )
{
	int	on;

	on = address & 0x01;
	if ( motor_on != on ) {
	   motor_on = on;
	}

}

static void selectDrive( ADDR address )
{
	int	drive_no;

	drive_no = address & 0x01;
	if ( drive_no != drive_select ) {
	   track_buffer_valid = 0;
	   drive_select = drive_no;
	}

}

void load_track_buffer(void)
{
	int logical_track;

	if (!diskimage)
	   return;

	if ( physical_track_no[drive_select] & 0x3 ) { 
	  fprintf( stderr, "Cannot read half track %g!\n",
	     physical_track_no[drive_select]*.25 );
	}
	
	logical_track = (physical_track_no[drive_select]+1)>>2;
	fseek( diskimage, logical_track * DOS_TRACK_BYTES, 0L );
	fread( dos_track, 1, DOS_TRACK_BYTES, diskimage );
	SectorsToNibbles( dos_track, nibble, 254, logical_track ); 
	track_buffer_track = physical_track_no[drive_select];
	printf( "load track %g\n", track_buffer_track*.25 );
	track_buffer_dirty = 0;
	track_buffer_valid = 1;

}

void save_track_buffer(void)
{
	int	logical_track;

	if (!diskimage || !track_buffer_dirty)
	   return;
	fprintf( stderr, "save track %d\n", track_buffer_track );
	if ( track_buffer_track & 0x3 ) { 
	  fprintf( stderr, "Cannot write half track %d!\n",
	     track_buffer_track );
	  return;
	}

	logical_track = track_buffer_track >> 2; 

	if ( NibblesToSectors( nibble, dos_track, 0, logical_track ) ) { 
	   fseek( diskimage, logical_track * DOS_TRACK_BYTES, 0L );
	   fwrite( dos_track, 1, DOS_TRACK_BYTES, diskimage );
	}
	else {
	   fprintf( stderr, "Track %d corrupted\n", logical_track );
	}
	track_buffer_dirty = 0;
}
