/*
 * colour.c
 */

#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>

/* RGB colors */
static struct {
	unsigned short	red;
	unsigned short	green;
	unsigned short	blue;
} AppleIIColor[16]= {
	{0x0,0x0,0x0},	/* Black */
	{0xd,0x0,0x3},	/* Deep Red */
	{0x0,0x0,0x9},	/* Dark Blue */
	{0xd,0x2,0xd},	/* Purple */
	{0x0,0x7,0x2},	/* Dark Green */	
	{0x5,0x5,0x5},	/* Dark Gray */
	{0x2,0x2,0xf},	/* Medium Blue */	
	{0x6,0xa,0xf},	/* Light Blue */
	{0x8,0x5,0x0},	/* Brown */	
	{0xf,0x6,0x0},	/* Orange */
	{0xa,0xa,0xa},	/* Light Gray */
	{0xF,0x9,0x8},	/* Pink */
	{0x1,0xd,0x0},	/* Light Green */
	{0xf,0xf,0x0},	/* Yellow */
	{0x4,0xf,0x9},	/* Aquamarine */
	{0xf,0xf,0xf}	/* White */
};

unsigned long AppleColourPixel[16];
unsigned long AppleColourQuad[16];

int allocAppleColours(Display *dpy)
{
	int i;
	XColor color;
	unsigned long c;

	for(i=0;i<16;i++){
		color.red=AppleIIColor[i].red<<12;
		color.green=AppleIIColor[i].green<<12;
		color.blue=AppleIIColor[i].blue<<12;
		color.flags=DoRed|DoGreen|DoBlue;
		if (!XAllocColor(dpy, DefaultColormap(dpy,DefaultScreen(dpy)),
		   &color)) {
	           fprintf(stderr,"Cannot allocate color #%d\n",i);
	           return -1;
	        };
#ifdef DEBUG
	        printf("allocated color %d 0x%02x r=%04X g=%d04X b=%04X\n",i,
	           color.pixel,color.red, color.green,color.blue);
#endif
	        c=color.pixel;
		AppleColourPixel[i]=c;
		c=c|(c<<8);
		AppleColourQuad[i]=c|(c<<16);
	}
	return 0;
}
