#include <stdio.h>

#include "hardware.h"

#ifdef	RUN_TIME_TRANSLATION

#define	CODE_HEAP_SIZE	128

static	int		CodePageSize;
static	int		WordPerCodePage;
static	char		*RealHeapStart;
static	char		*CodeHeapStart;
static	char		*CodeHeapEnd;
static	int		TotalNoOfPages;

static	int		*LinkTable;
static	int		NoOfFreePages;
static	int		FirstFreePageIndex;

#define	NULL_PAGE_INDEX		(-1)
#define	ALLOCATED_PAGE_TAG	(-2)

#define	NEXT_PAGE_INDEX(i)	LinkTable[i]
#define	PAGE_TO_INDEX(p)	(((char*)(p)-CodeHeapStart)/CodePageSize)
#define	INDEX_TO_PAGE(i)	((unsigned*)(CodeHeapStart+(i)*CodePageSize))

void	InitCodeHeap()
{
	unsigned	page_boundary;
	int		i;
	int		rtl_size;
	unsigned	heap_msb;

	CodePageSize = 4096; 
	WordPerCodePage = CodePageSize / sizeof( unsigned );
	RealHeapStart = (char*)malloc(CodePageSize*CODE_HEAP_SIZE);

	/* align heap to page boundary */
	page_boundary = (unsigned)RealHeapStart / CodePageSize * CodePageSize;
	if ( page_boundary == (unsigned)RealHeapStart ) {
	   CodeHeapStart = RealHeapStart;
	   TotalNoOfPages = CODE_HEAP_SIZE;
	}
	else {
	   CodeHeapStart = (char*)(page_boundary+CodePageSize);
	   TotalNoOfPages = CODE_HEAP_SIZE-1;
	}
	CodeHeapEnd = CodeHeapStart + TotalNoOfPages * CodePageSize-1;

	LinkTable = (int*)malloc(sizeof(int)*TotalNoOfPages);

	for( i = 1; i < TotalNoOfPages; i++ )
	   NEXT_PAGE_INDEX(i) = i-1;
	NEXT_PAGE_INDEX(0) = NULL_PAGE_INDEX;

	FirstFreePageIndex = TotalNoOfPages - 1;
	NoOfFreePages = TotalNoOfPages;
}

unsigned *AllocCodePage()
{
	int	new, next;

	if ( FirstFreePageIndex == NULL_PAGE_INDEX ) {
	   fprintf( stderr, "AllocCodePage: out of memory\n" );
	   return NULL;
	}

	new = FirstFreePageIndex;
	next = NEXT_PAGE_INDEX(new);
	NEXT_PAGE_INDEX(new) = ALLOCATED_PAGE_TAG;
	FirstFreePageIndex = next;
	NoOfFreePages--;
	return INDEX_TO_PAGE(new);
}

void	FreeCodePage( p )
unsigned *p;
{
	int		i;

	i = PAGE_TO_INDEX(p);
	if ( i < 0 || i >= TotalNoOfPages || 
	   NEXT_PAGE_INDEX(i) != ALLOCATED_PAGE_TAG ) {
	   fprintf( stderr, "FreeCodePage: invalid page\n" );
	}

	NEXT_PAGE_INDEX(i) = FirstFreePageIndex;
	FirstFreePageIndex = i;
	NoOfFreePages++;
}

int	GetCodePageSize()
{
	return CodePageSize;
}
int	CodePagesLeft()
{
	return	NoOfFreePages;
}

#endif	/* RUN_TIME_CODE_GENERATION */
