#ifndef	_6502_H_
#define	_6502_H_

#define	SIG_6502_SHUTDOWN	(1<<0)
#define	SIG_6502_RES		(1<<1)
#define	SIG_6502_NMI		(1<<2)
#define	SIG_6502_IRQ		(1<<3)
#define	SIG_6502_TIMER		(1<<4)
#define	SIG_6502_CONTEXT	(1<<5)
#define	SIG_6502_MEMORY		(1<<6)

typedef	struct	{
	ADDR	PC;
	BYTE	A;
	BYTE	X;
	BYTE	Y;
	BYTE	P;
	BYTE	S;
	} AppleCPUContextStruct;

/* function prototypes */
void init_6502(void);
void assert_RES(void);
void assert_NMI(void);
void assert_IRQ(void);
void shutdown_6502(void);
void set_next_timer_exception( APPLE_TICK );
void set_trace(void);
void Signal6502( unsigned );
int CPUExecute( AppleCPUContextStruct* );

#endif	/* _6502_H_ */
